#!/bin/bash
# ATMEL Wireless Card Initialization script of the corresponding module
# Copyright 2001 (c) ATMEL Hellas

CFG=/root/.vnetrc


strconcat()
{
for element in "channel" "mode" "rate" "frag" "rts"
do
        a=`grep -v '^#' $CFG | grep $element | cut -d = -f1`
        b=`grep -v '^#' $CFG | grep $element | cut -d = -f2 `
        if [ -z "$b" ]; then 
        case "$element" in
                "mode" )    
                b=Ad-hoc
                ;;
                "channel"  )   
                b=4
                ;;
                "rate"  )   
                b=11M
                ;;
                "frag"  )   
                b=2346
                ;;
                "rts"  )   
                b=2347
                ;;
                * )
                ;;
        esac
                    
fi
        echo $a $b
done
}

var=`strconcat`

name=`grep -v '^#' $CFG | grep essid | cut -d = -f2`
if [ -z "$name" ]; then
        name=InsertName
fi
        

if [ -f $CFG ]; then
        regulatory_domain=`grep -v '^#' $CFG | grep regulatory_domain | cut -d = -f2`
        if [ -z "$regulatory_domain" ]; then
                regulatory_domain=1
        fi
        len=`grep -v '^#' $CFG | grep essid | cut -d = -f2 | awk '{print length}'`
        frag=`grep -v '^#' $CFG | grep frag | cut -d = -f2 `
        if [ -z "$frag" ]; then
                frag=2346
        fi
        
        rts=`grep -v '^#' $CFG | grep rts | cut -d = -f2 `
        if [ -z "$rts" ]; then
                rts=2347
        fi
        if [ $frag -lt 256 ]  && [ $frag -gt 2346 ]; then
                exit
        fi
        if [ $rts -lt 1 ]  && [ $rts -gt 2347 ]; then
                exit
        fi
        if [ $len -gt 32 ]; then
                echo "Length of essid too long (Max 32)"
                exit
        fi
        case "$regulatory_domain" in
                "1" )    
                min=1
                max=11
                ;;
                "2"  )   
                min=1
                max=13
                ;;
                "3"  )   
                min=10
                max=11
                ;;
                "4"  )   
                min=10
                max=13
                ;;
                "5"  )   
                min=1
                max=14
                ;;
                "6"  )   
                min=14
                max=14
                ;;
                "7"  )   
                min=3
                max=9
                ;;
                * )
                min=1
                max=14
                ;;
        esac
                    
        channel=`grep -v '^#' $CFG | grep channel | cut -d =  -f2 `
        if [ -z "$channel" ]; then
                channel=4
        fi
        if [ $channel -gt $min ] || [ $channel -eq $min ] && [ $channel -lt $max ] || [ $channel -eq $max ]; then

        ifname=`grep -v '^#' $CFG | grep interface  | cut -d = -f2 `
        if [ -z "$ifname" ]; then
                ifname=eth1
        fi
# Wep Settings
        enc=`grep -v '^#' $CFG | grep encryption  | cut -d = -f2 `
        key=`grep -v '^#' $CFG | grep key  | cut -d = -f1 `
        num=`grep -v '^#' $CFG | grep key  | cut -d = -f2 `
        value=`grep -v '^#' $CFG | grep value  | cut -d = -f2 `
        mode=`grep -v '^#' $CFG | grep wep  | cut -d = -f2 `

        if [ -z $enc ]; then
                enc=off
        fi

        if [ $enc = "on" ]; then
                iwconfig $ifname key $enc
                iwconfig $ifname $key $num [$value] $mode
        fi

        iwconfig $ifname $var
        iwconfig $ifname essid $name
        else 
        echo "You have selected an invalid channel"
        exit
        fi
        else
        echo -e "$CFG : No such file or directory"
        exit
fi
