/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "xvnet.h"

void exit_cb(FL_OBJECT *ob, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	UCHAR		i;
	struct iwreq wrq;
	if(pOpenCards == NULL)
	{
		fl_finish();
		exit(0);
		return;
	}
	if (fl_get_active_folder_number(pOpenCards->fd_mainform->folder) == 3)
	{
		strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
		wrq.u.data.flags = STOP_SITE_SURVEY;
		ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	}
	for(i=0;i<pOpenCards->NumOfCards;i++)
		free(pOpenCards->pCardInfo[i]);
	free(pOpenCards->fd_mainform);
	free(pOpenCards->fd_errorform);
	free(pOpenCards->fd_alertform);
	free(pOpenCards->fd_warningform);
	free(pOpenCards->fd_monitorform);
	free(pOpenCards->fd_statisticsform);
	free(pOpenCards->fd_sitesurveyform);
	free(pOpenCards->fd_encryptionform);
	free(pOpenCards->fd_advancedform);
	free(pOpenCards->fd_versionform);
	free(pOpenCards);
	pOpenCards=NULL;
	fl_finish();
	exit(0);
}

void retry_cb(FL_OBJECT *ob, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
//	pOpenCards->pCardInfo[pOpenCards->Active]->ErrorStatus = FALSE;
	fl_activate_form(pOpenCards->fd_mainform->mainform);
	fl_resume_timer(pOpenCards->fd_mainform->timer);
	if (fl_form_is_visible(pOpenCards->fd_alertform->alertform))
		fl_hide_form(pOpenCards->fd_alertform->alertform);
	else if (fl_form_is_visible(pOpenCards->fd_warningform->alertform))
		fl_hide_form(pOpenCards->fd_warningform->alertform);
}

void clear_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;
	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer = NULL;
	wrq.u.data.flags = CLEAR_PACKETS;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
}

void My_Timer(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	STATINFO StatInfo;
	int fn = fl_get_active_folder_number(pOpenCards->fd_mainform->folder);
	switch(fn)
	{
		case 1: //Monitor
			Get_Vnet_Stats(pOpenCards);
			ConvertInfo(pOpenCards);
			fl_set_object_label(pOpenCards->fd_monitorform->State, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState);
			fl_set_choice(pOpenCards->fd_monitorform->OpMode, pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode+1);
			fl_set_input(pOpenCards->fd_monitorform->SSID, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.essid);
//			fl_set_choice(pOpenCards->fd_monitorform->Power , pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.PowerMgmtMode );
			fl_set_choice(pOpenCards->fd_monitorform->Roaming , (pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.InternationalRoaming)?1:2);
			fl_set_choice(pOpenCards->fd_monitorform->Radio , (pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.RadioIsOn)?1:2  );
			//fl_set_choice(pOpenCards->fd_monitorform->Channel, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.Channel);
			fl_set_choice(pOpenCards->fd_monitorform->Channel, DomainIndex (pOpenCards));
                        if (pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.RadioIsOn == TRUE && pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState == 0x05 && pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode==1){
                            fl_set_slider_value(pOpenCards->fd_monitorform->Signal_b, pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Rssi*2.5);
                            fl_set_object_label(pOpenCards->fd_monitorform->Signal_b, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.SValue);
                            fl_set_slider_value(pOpenCards->fd_monitorform->Link_b, pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.LinkQuality*2.5);
                            fl_set_object_label(pOpenCards->fd_monitorform->Link_b, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.LValue);
                        }else{

                            fl_set_slider_value(pOpenCards->fd_monitorform->Signal_b, 0);
                            fl_set_object_label(pOpenCards->fd_monitorform->Signal_b, 0);
                            fl_set_slider_value(pOpenCards->fd_monitorform->Link_b, 0);
                            fl_set_object_label(pOpenCards->fd_monitorform->Link_b, 0);
                        }
			break;
		case 2: //Stats
			Get_Stats(&StatInfo, pOpenCards);
			fl_set_object_label(pOpenCards->fd_statisticsform->DTxSucc, StatInfo.DTxSucc);
			fl_set_object_label(pOpenCards->fd_statisticsform->DRxSucc, StatInfo.DRxSucc);
			fl_set_object_label(pOpenCards->fd_statisticsform->DTxUnS, StatInfo.DTxUnS);
			fl_set_object_label(pOpenCards->fd_statisticsform->DRxUnS, StatInfo.DRxUnS);
			
			fl_set_object_label(pOpenCards->fd_statisticsform->MTxSucc, StatInfo.MTxSucc);
			fl_set_object_label(pOpenCards->fd_statisticsform->MRxSucc, StatInfo.MRxSucc);
			fl_set_object_label(pOpenCards->fd_statisticsform->MTxUnS, StatInfo.MTxUnS);
			fl_set_object_label(pOpenCards->fd_statisticsform->MRxUnS, StatInfo.MRxUnS);
			
			fl_set_object_label(pOpenCards->fd_statisticsform->ReJTx, StatInfo.RejTx);
			fl_set_object_label(pOpenCards->fd_statisticsform->ReJRx, StatInfo.RejRx);
			break;
	}	
	fl_set_timer(pOpenCards->fd_mainform->timer, 1);
}

void opmode_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode =
		fl_get_choice(pOpenCards->fd_monitorform->OpMode)-1;
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode==0)
	{
		fl_set_object_color(pOpenCards->fd_monitorform->Channel, FL_COL1, FL_BLACK);
		fl_activate_object(pOpenCards->fd_monitorform->Channel);
	}
	else
	{
		fl_set_object_color(pOpenCards->fd_monitorform->Channel, FL_COL1, FL_INACTIVE);
		fl_deactivate_object(pOpenCards->fd_monitorform->Channel);
	}
}
void channel_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
        int lvalid=0;
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode == 1)
		return;
        switch (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RegDomain) {
        case 0x10:
            lvalid = 1;
            break;
            case
        0x20:
            lvalid = 11;
            break;
            case
        0x30:
            lvalid = 1;
            break;
            case
        0x31:
            lvalid = 10;
            break;
            case
        0x32:
            lvalid = 10;
            break;
            case
        0x40:
            lvalid = 14;
            break;
            case
        0x41:
            lvalid = 1;
            break;
            case
        0x50:
            lvalid = 3;
            break;
        default:
            lvalid = 1;
            break;
        }
            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Channel = (fl_get_choice(pOpenCards->fd_monitorform->Channel) + lvalid) - 1;	
        
}
void ssid_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	strcpy(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSID,fl_get_input(obj));
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSIDlength =
		strlen(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSID);
}

#if 0
void powermgmt_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode =
		fl_get_choice(pOpenCards->fd_monitorform->Power)-1;
}
#endif
void roaming_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
        int flag1;
	flag1 =	fl_get_choice(pOpenCards->fd_monitorform->Roaming);
        switch(flag1)
        {
            case 1:
	            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.InternationalRoaming =TRUE;
                        break;
                
            case 2:
	            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.InternationalRoaming =FALSE;
                
            default:
                    break;
        }

}
void radio_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
        int flag;
	flag =	fl_get_choice(pOpenCards->fd_monitorform->Radio);
        switch(flag)
        {
            case 1:
	            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RadioIsOn =TRUE;
                        break;
                
            case 2:
	            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RadioIsOn =FALSE;
                
            default:
                    break;
        }
}
void txrate_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.TxRate =
		fl_get_choice(pOpenCards->fd_monitorform->TxRate)-1;	
}
void change_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
        int i, hvalid, lvalid;
        char tmp_c[5];
	
	pOpenCards->pCardInfo[pOpenCards->Active]->OpM = pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode;
	fl_suspend_timer(pOpenCards->fd_mainform->timer);
	fl_deactivate_object(pOpenCards->fd_monitorform->Change);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Change, FL_INACTIVE);
	fl_activate_object(pOpenCards->fd_monitorform->OpMode);
	fl_activate_object(pOpenCards->fd_monitorform->Submit);
        

	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode == 0)
	{
		fl_activate_object(pOpenCards->fd_monitorform->Channel);
		fl_set_object_color(pOpenCards->fd_monitorform->Channel, FL_COL1, FL_BLACK);
	}
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Submit, FL_BLACK);
	fl_activate_object(pOpenCards->fd_monitorform->Cancel);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Cancel, FL_BLACK);
	fl_activate_object(pOpenCards->fd_monitorform->SSID);
//	fl_activate_object(pOpenCards->fd_monitorform->Power);
	fl_activate_object(pOpenCards->fd_monitorform->Roaming);
	fl_activate_object(pOpenCards->fd_monitorform->Radio);
	fl_activate_object(pOpenCards->fd_monitorform->TxRate);	
}
void submit_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;

  	strcpy(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSID, fl_get_input(pOpenCards->fd_monitorform->SSID));
  	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSIDlength = strlen(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSID);
	Set_Vnet_Stats(pOpenCards);
	fl_deactivate_object(pOpenCards->fd_monitorform->Cancel);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Cancel, FL_INACTIVE);
	fl_activate_object(pOpenCards->fd_monitorform->Change);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Change, FL_BLACK);
	fl_activate_object(pOpenCards->fd_monitorform->Submit);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Submit, FL_INACTIVE);
	fl_deactivate_object(pOpenCards->fd_monitorform->OpMode);
	fl_deactivate_object(pOpenCards->fd_monitorform->SSID);
	fl_deactivate_object(pOpenCards->fd_monitorform->Channel);
//	fl_deactivate_object(pOpenCards->fd_monitorform->Power);
	fl_deactivate_object(pOpenCards->fd_monitorform->Roaming);
	fl_deactivate_object(pOpenCards->fd_monitorform->Radio);
	fl_deactivate_object(pOpenCards->fd_monitorform->TxRate);
 	fl_resume_timer(pOpenCards->fd_mainform->timer);	
}
void cancel_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode = pOpenCards->pCardInfo[pOpenCards->Active]->OpM;
	fl_deactivate_object(pOpenCards->fd_monitorform->Cancel);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Cancel, FL_INACTIVE);
	fl_activate_object(pOpenCards->fd_monitorform->Change);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Change, FL_BLACK);
	fl_activate_object(pOpenCards->fd_monitorform->Submit);
	fl_set_object_lcolor(pOpenCards->fd_monitorform->Submit, FL_INACTIVE);
	fl_deactivate_object(pOpenCards->fd_monitorform->OpMode);
	fl_deactivate_object(pOpenCards->fd_monitorform->SSID);
	fl_deactivate_object(pOpenCards->fd_monitorform->Channel);
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode == 1)
		fl_set_object_color(pOpenCards->fd_monitorform->Channel, FL_COL1, FL_INACTIVE);
//	fl_deactivate_object(pOpenCards->fd_monitorform->Power);
	fl_deactivate_object(pOpenCards->fd_monitorform->Roaming);
	fl_deactivate_object(pOpenCards->fd_monitorform->Radio);
	fl_deactivate_object(pOpenCards->fd_monitorform->TxRate);
	fl_resume_timer(pOpenCards->fd_mainform->timer);	
}

void tab_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;
	UCHAR  State;
	int val = fl_get_active_folder_number(pOpenCards->fd_mainform->folder);
	int val1 = fl_get_folder_number(pOpenCards->fd_mainform->folder);
	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);

	switch(val)
	{
		case 4:
			Get_Wep(pOpenCards);						
			fl_set_choice(pOpenCards->fd_encryptionform->EncryptionLevel, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel+1);
			fl_set_input(pOpenCards->fd_encryptionform->Wep1, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[0]);
			fl_set_input(pOpenCards->fd_encryptionform->Wep2, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[1]);
			fl_set_input(pOpenCards->fd_encryptionform->Wep3, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[2]);
			fl_set_input(pOpenCards->fd_encryptionform->Wep4, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[3]);
			fl_set_choice(pOpenCards->fd_encryptionform->WepToUse, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepToUse+1);
			fl_set_choice(pOpenCards->fd_encryptionform->WepMode,pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepMode+1);
			fl_set_choice(pOpenCards->fd_encryptionform->AuthType,pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.AuthType+1);
			if(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel==0)
			{
				fl_deactivate_object(pOpenCards->fd_encryptionform->Wep1);
				fl_deactivate_object(pOpenCards->fd_encryptionform->Wep2);
				fl_deactivate_object(pOpenCards->fd_encryptionform->Wep3);
				fl_deactivate_object(pOpenCards->fd_encryptionform->Wep4);
				fl_deactivate_object(pOpenCards->fd_encryptionform->WepToUse);
				fl_deactivate_object(pOpenCards->fd_encryptionform->WepMode);
				fl_deactivate_object(pOpenCards->fd_encryptionform->AuthType);
			}
			else
			{
				fl_activate_object(pOpenCards->fd_encryptionform->Wep1);
				fl_activate_object(pOpenCards->fd_encryptionform->Wep2);
				fl_activate_object(pOpenCards->fd_encryptionform->Wep3);
				fl_activate_object(pOpenCards->fd_encryptionform->Wep4);
				fl_activate_object(pOpenCards->fd_encryptionform->WepToUse);
				fl_activate_object(pOpenCards->fd_encryptionform->WepMode);
				fl_activate_object(pOpenCards->fd_encryptionform->AuthType);			
			}
			break;
		default:
			break;
	}
	
	if (val==3)
	{
		fl_suspend_timer(pOpenCards->fd_mainform->timer);
		wrq.u.data.flags = SITE_SURVEY;
		ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
		return;
	}
	if (val1 != 3)
		return;	
	wrq.u.data.flags = STOP_SITE_SURVEY;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	fl_resume_timer(pOpenCards->fd_mainform->timer);	
}	

UCHAR AsciiToByte(UCHAR Ascii1, UCHAR Ascii2)
{
	UCHAR digit1, digit2;
	if(Ascii1 >= 0x30 && Ascii1 <= 0x39)
			digit1 = Ascii1 - 0x30;
	else if(Ascii1 >= 0x41 && Ascii1 <= 0x46)
			digit1 = Ascii1 - 0x31 - 6;
	else return 0x50;


	if(Ascii2 >= 0x30 && Ascii2 <= 0x39)
			digit2 = Ascii2 - 0x30;
	else if(Ascii2 >= 0x41 && Ascii2 <= 0x46)
			digit2 = Ascii2 - 0x31 - 6;
	else return 0x50;

	return (digit1<<4) + digit2;
}


// WEP tab...
void WepInput(FL_OBJECT *obj, POPEN_CARDS pOpenCards, char WepKey)
{
	UCHAR 		tmp_a[2*LONG_WEP_KEY_SIZE], tmp_b[2*LONG_WEP_KEY_SIZE], w, val;
	UCHAR		WepKeyLength=(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength*2);
	strcpy(tmp_a,fl_get_input(obj));

	if ( strlen(tmp_a) < WepKeyLength )
		fl_set_input(obj, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[WepKey]);
	w=0;
	for (val =0; val < WepKeyLength; val++)
		tmp_a[val]=toupper(tmp_a[val]);
	for (val=0; val<WepKeyLength; val+=2)
	{
		if ( (tmp_b[w++]=AsciiToByte(tmp_a[val],tmp_a[val+1])) == 0x50)
		{
			fl_set_input(obj, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[WepKey]);
			fl_suspend_timer(pOpenCards->fd_mainform->timer);
			fl_deactivate_form(pOpenCards->fd_mainform->mainform);
			fl_set_object_label(pOpenCards->fd_warningform->message, "Invalid WEP KEY. Valid Symbols 0-9, A-F");
			fl_show_form(pOpenCards->fd_warningform->alertform,FL_PLACE_CENTERFREE,FL_FULLBORDER,"Warning");
			return;
		}
	}
	strcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[WepKey],tmp_a);
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[WepKey], tmp_b, WepKeyLength);
	fl_set_input(obj, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[WepKey]);
}
void WepInput1(FL_OBJECT *obj, long data)
{
	WepInput(obj, (POPEN_CARDS)data, 0);
}
void WepInput2(FL_OBJECT *obj, long data)
{
	WepInput(obj, (POPEN_CARDS)data, 1);
}
void WepInput3(FL_OBJECT *obj, long data)
{
	WepInput(obj, (POPEN_CARDS)data, 2);
}
void WepInput4(FL_OBJECT *obj, long data)
{
	WepInput(obj, (POPEN_CARDS)data, 3);
}
void WepToUse_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepToUse = fl_get_choice(pOpenCards->fd_encryptionform->WepToUse)-1;
}
void WepMode_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepMode =	fl_get_choice(pOpenCards->fd_encryptionform->WepMode)-1;
}
void Authtype_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.AuthType = fl_get_choice(pOpenCards->fd_encryptionform->AuthType)-1;
}

void SubmitWep_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	int 		val, w;
	UCHAR		WepKeyLength = pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength*2;
	struct iwreq wrq;
	WEP_INFO 	WepInfo;

			
	switch(fl_get_choice(pOpenCards->fd_encryptionform->EncryptionLevel)-1)
	{	
		case 1:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel = 1;
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 5;
			WepKeyLength = 10;
			break;
		case 2:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel =2;
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 13;
			WepKeyLength = 26;
			break;
		default:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel = 0;
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 0;
			break;
	}

	fl_call_object_callback(pOpenCards->fd_encryptionform->Wep1);
	fl_call_object_callback(pOpenCards->fd_encryptionform->Wep2);
	fl_call_object_callback(pOpenCards->fd_encryptionform->Wep3);
	fl_call_object_callback(pOpenCards->fd_encryptionform->Wep4);
	WepInfo.EncryptionLevel = (UCHAR)pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel;
	WepInfo.WepKeyToUse = (UCHAR)pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepToUse;
	WepInfo.WepMode     = (UCHAR)pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepMode;
	WepInfo.AuthenticationType = (UCHAR)pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.AuthType;

	memcpy(WepInfo.WepKey1, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[0], WepKeyLength);
	memcpy(WepInfo.WepKey2, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[1], WepKeyLength);
	memcpy(WepInfo.WepKey3, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[2], WepKeyLength);
	memcpy(WepInfo.WepKey4, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[3], WepKeyLength);
	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer = (caddr_t)&WepInfo;
	wrq.u.data.length = sizeof(WEP_INFO);
	wrq.u.data.flags = SET_WEP_INFO;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	fl_set_folder_bynumber(pOpenCards->fd_mainform->folder, 1);
}	
void EncryptionLevel_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards 	=	(POPEN_CARDS)data;
	
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel = fl_get_choice(pOpenCards->fd_encryptionform->EncryptionLevel)-1;
	switch(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel)
	{
		case WEP_DISABLED:
			fl_deactivate_object(pOpenCards->fd_encryptionform->Wep1);
			fl_deactivate_object(pOpenCards->fd_encryptionform->Wep2);
			fl_deactivate_object(pOpenCards->fd_encryptionform->Wep3);
			fl_deactivate_object(pOpenCards->fd_encryptionform->Wep4);
			fl_deactivate_object(pOpenCards->fd_encryptionform->WepToUse);
			fl_deactivate_object(pOpenCards->fd_encryptionform->WepMode);
			fl_deactivate_object(pOpenCards->fd_encryptionform->AuthType);
			break;
		case WEP_128bit:
		case WEP_64bit:
			if(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel==WEP_64bit)
			{
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep1, 10);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep2, 10);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep3, 10);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep4, 10);
			}
			else
			{
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep1, 26);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep2, 26);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep3, 26);
				fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep4, 26);
			}
			fl_activate_object(pOpenCards->fd_encryptionform->Wep1);
			fl_activate_object(pOpenCards->fd_encryptionform->Wep2);
			fl_activate_object(pOpenCards->fd_encryptionform->Wep3);
			fl_activate_object(pOpenCards->fd_encryptionform->Wep4);
			fl_activate_object(pOpenCards->fd_encryptionform->WepToUse);
			fl_activate_object(pOpenCards->fd_encryptionform->WepMode);
			fl_activate_object(pOpenCards->fd_encryptionform->AuthType);
			break;
		default:
			break;
	}
}			


void Site_Select_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;
	int APIndex;

	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	APIndex = fl_get_browser(pOpenCards->fd_sitesurveyform->browser);
	wrq.u.data.length = sizeof(int);
	wrq.u.data.pointer= (caddr_t)&APIndex;
	wrq.u.data.flags = SELECT_AP_BY_INDEX;
	fl_deactivate_object(pOpenCards->fd_sitesurveyform->browser);
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	fl_set_folder_bynumber(pOpenCards->fd_mainform->folder, 1);
	fl_resume_timer(pOpenCards->fd_mainform->timer);	
}
void select_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;

	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	fl_deactivate_object(pOpenCards->fd_sitesurveyform->ReScan);
		fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->ReScan, FL_INACTIVE);
	fl_deactivate_object(pOpenCards->fd_sitesurveyform->browser);
	wrq.u.data.flags = SELECT_AP_BY_INDEX;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	fl_resume_timer(pOpenCards->fd_sitesurveyform->Timer);
}
void rescan_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;

	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	fl_deactivate_object(pOpenCards->fd_sitesurveyform->ReScan);
		fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->ReScan, FL_INACTIVE);
	fl_deactivate_object(pOpenCards->fd_sitesurveyform->browser);
	fl_activate_object(pOpenCards->fd_sitesurveyform->Cancel);
	fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->Cancel, FL_BLACK);
	wrq.u.data.flags = SITE_SURVEY;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	fl_resume_timer(pOpenCards->fd_sitesurveyform->Timer);
}

void site_s_cancel_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	struct iwreq wrq;
	printf("called\n");
	fl_suspend_timer(pOpenCards->fd_sitesurveyform->Timer);
	fl_activate_object(pOpenCards->fd_sitesurveyform->ReScan);
	fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->ReScan, FL_BLACK);
	wrq.u.data.flags = STOP_SITE_SURVEY;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
}
void site_s_timer_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	SiteSurveyBrowser(pOpenCards);
}	


void Update_Tabs(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards 	= (POPEN_CARDS)data;
	pOpenCards->Active 		= fl_get_choice(pOpenCards->fd_mainform->eth_select)-1;
}


// Advanced TAB
void Frag_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	char tmp_c[6];
	struct iwreq wrq;
	fl_suspend_timer(pOpenCards->fd_mainform->timer);
	strcpy(tmp_c, fl_get_input(pOpenCards->fd_advancedform->frag_input));
	if (atoi(tmp_c)>2346)
	{
		sprintf(tmp_c, "%d", pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.FragmentationThreshold);
		fl_set_input(pOpenCards->fd_advancedform->frag_input, tmp_c);
		return;
	}
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.FragmentationThreshold = atoi(tmp_c);
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.FragmentationThreshold == 2346)
		fl_set_object_label(pOpenCards->fd_advancedform->frag_ed, "(Disabled)");	
	else
		fl_set_object_label(pOpenCards->fd_advancedform->frag_ed, "(Enabled)");
}
void Rts_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS	pOpenCards = (POPEN_CARDS)data;
	char tmp_c[6];
	struct iwreq wrq;
	fl_suspend_timer(pOpenCards->fd_mainform->timer);
	strcpy(tmp_c, fl_get_input(pOpenCards->fd_advancedform->rts_input));
	if (atoi(tmp_c)>2347)
	{
		sprintf(tmp_c, "%d", pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RtsCtsThreshold);
		fl_set_input(pOpenCards->fd_advancedform->rts_input, tmp_c);
		return;
	}
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RtsCtsThreshold = atoi(tmp_c);
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RtsCtsThreshold == 2347)
		fl_set_object_label(pOpenCards->fd_advancedform->rts_ed, "(Disabled)");
	else
		fl_set_object_label(pOpenCards->fd_advancedform->rts_ed, "(Enabled)");			
}
void adv_submit_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	
	Set_Vnet_Stats(pOpenCards);
	fl_set_folder_bynumber(pOpenCards->fd_mainform->folder, 1);
}
void long_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	
	fl_deactivate_object(pOpenCards->fd_advancedform->b_long);
	fl_activate_object(pOpenCards->fd_advancedform->b_short);
	fl_set_button(pOpenCards->fd_advancedform->b_long, 1);
	fl_set_button(pOpenCards->fd_advancedform->b_short, 0);
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PreambleType = 0;
}
void short_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	
	fl_activate_object(pOpenCards->fd_advancedform->b_long);
	fl_deactivate_object(pOpenCards->fd_advancedform->b_short);
	fl_set_button(pOpenCards->fd_advancedform->b_long, 0);
	fl_set_button(pOpenCards->fd_advancedform->b_short, 1);
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PreambleType = 1;
}

void on_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	
	fl_deactivate_object(pOpenCards->fd_advancedform->b_on);
	fl_activate_object(pOpenCards->fd_advancedform->b_off);
	fl_set_button(pOpenCards->fd_advancedform->b_on, 1);
	fl_set_button(pOpenCards->fd_advancedform->b_off, 0);
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode = 0;
}
void off_cb(FL_OBJECT *obj, long data)
{
	POPEN_CARDS pOpenCards = (POPEN_CARDS)data;
	
	fl_activate_object(pOpenCards->fd_advancedform->b_on);
	fl_deactivate_object(pOpenCards->fd_advancedform->b_off);
	fl_set_button(pOpenCards->fd_advancedform->b_on, 0);
	fl_set_button(pOpenCards->fd_advancedform->b_off, 1);
	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode = 1;
}

