/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include <ncurses.h>
#include "vnet.h"

typedef struct {
	char 	*str;
	UCHAR	value;
}PAIRS;
char *vnetusbaconf = "/tmp/vnetusba.conf";

PAIRS opmodes[] = { {"infrastructure",1},
		  			{"ad-hoc", 0},
					{NULL,0}};

PAIRS intrnrmng[] = { {"enable",1},
					{"disable", 0},
					{NULL,0}};

PAIRS txrate[] = { {"1Mbps",0},
				{"2Mbps",1},
				{"5.5Mbps",2},
		 		{"11Mbps",3},
		 		{"Auto", 4},
		 		{NULL,0} };

PAIRS preamble[] = { {"short",0},
		   			{"long",1},
					{NULL,0} };

PAIRS wep[] = { {"disabled",0},
				{"64bit",1},
				{"128bit",2},
				{NULL,0} };

PAIRS wepmode[] = { {"mandatory",0},
		    		{"optional",1},
					{NULL,0} };

PAIRS authentication[] = { {"opensystem", 0},
							{"sharedkey", 1},
							{NULL,0} };

char *wepkeys[] = { "11223344556677889910111213",
					"00000000000000000000000000",
		    		"00000000000000000000000000",
		    		"00000000000000000000000000",
					NULL};

int weptouse = 0;

char *infilenames[] = { "ssid",
					  "channel",
					  "operatingmode",
					  "txrate",
					  "internatroaming",
					  "preamble",
					  "fragthreshold",
					  "rtsthreshold",
					  //WEP
					  "wep",
					  "weptouse",
					  "wepmode",
					  "authentication",
					  "wep1",
					  "wep2",
					  "wep3",
					  "wep4"
					  };
					  
int fragt = 2347;
int rtst = 2346;
char *ssid = "";


int read_conf(PSTR_LIST str_list)
{
	FILE 		*f;
	PSTR_LIST	str_local = NULL;
	char 		tmp[150], s1[50], s2[50], s3[50];
	
	f=fopen(vnetusbaconf, "r+");
	
	if(f==NULL){
		perror("Unable to open file\n");
		return -1;
	}
	
	while(fgets(tmp, 150, f)!=NULL){
 		if(tmp[0]==';'){
 			continue;
       	}
		sscanf(tmp, "%s : %s", s1, s2);
       	if(str_local == NULL){
			str_local = str_list;
			str_local->string1 = malloc(strlen(s1));
			str_local->value = malloc(strlen(s2));
			str_local->next = NULL;
			memcpy(str_local->string1, s1, strlen(s1));
			memcpy(str_local->value, s2, strlen(s2));
       	}
       	str_local->next = malloc(STR_LIST_SIZE);
       	str_local = str_local->next;
   		str_local->string1 = malloc(strlen(s1));
   		str_local->value = malloc(strlen(s2));
		memcpy(str_local->string1, s1, strlen(s1));
		memcpy(str_local->value, s2, strlen(s2));
       	str_local->next = NULL;

       	printw("\t%s,%s\n====\n", str_local->string1, str_local->value );
//       	printw("-%s\n", str_local->string);
	}
	fclose(f);	
	return 0;
}

// write value stored setting id
int write_conf(char *string, int id)
{

}

typedef struct {
	UCHAR	index;
	UCHAR	status;
	PAIRS	*vals;
}DEV;
			 //index, string or not
DEV devindex[] ={ {2, 1, NULL},//ssid
				 {1, 0, NULL},// NULL},//channel
				 {0, 0, opmodes},//op mode
				 {35, 0, txrate},//txrate
				 {36, 0, intrnrmng},//pwr mgmt
				 {37, 0, preamble},//preamble
				 {38, 0, NULL},//frag
				 {40, 0, NULL},//rts
				}; // */
DEV wepindex[] = {  {4,0, wep},
					{0,0, 0},
					{1,0, wepmode},
					{2,0, authentication},
					{5,1, NULL},
					{18,1, NULL},
					{31,1, NULL},
					{44,1, NULL} };

int parse_output(PSTR_LIST str_list, PUCHAR Dev, PUCHAR Wep)//Buf = pDeviceConf
{
	PSTR_LIST	list=str_list;
	int 		i, StrFound=0;

	/*
	for(i=0; i<8; i++){
		if(strncmp(infilenames[i], str_list->string1, 4)==0){
		// take value and set....
			if(devindex[i].status){//string case
				strcpy(&Dev[devindex[i].index], str_list->value);
			}else{
				if(devindex[i].vals==NULL){//number
					Dev[devindex[i].index]= atoi(str_list->value);
				}else{//parsing needed
					while(devindex[i].vals.str != NULL){
						if(strncmp(devindex[i].vals.str, str_list->value, 4)==0){
							StrFound=1;
							Dev[devindex[i].index]=devindex[i].vals.value;
						}
					}
				}
			}
		}else{
		// set default
		
		}
	}
	
	for(i=8;i<16; i++){
	
	}*/
}
