/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include <signal.h>
#include <menu.h>
#include "vnet.h"
#ifdef ATMEL
char CompanyName[] = "ATMEL";
#elif defined(SMARTBRIDGES)
char CompanyName[] = "SmartBridges";
#endif
extern int wep_reverse;
WINDOW *exit_win;
WINDOW *no_card_win;
WINDOW *set_win;
WINDOW *conf_win;
WINDOW *wep_win;
char *conf_choices[] = {
	"Select SSID name (max 32 characters)",
	"Select Channel",
	"Select Radio State",
	"Select International Roaming State",
	"Select Transmit Rate",
	"Select Operating Mode",
	"Select Preamble Type",
	"Select Power Mgmt Mode",
	"Select Fragmentation Threshold",
	"Select Rts Threshold",
	"Exit   Menu",
};
int reverse;
int epilogh = 0;
int config_choices = sizeof(conf_choices) / sizeof(char *);
void read_ioctls_wlan(PDEVICE_CONFIGURATION pAppInfo, PWEP_INFO pWepInfo,
		      int fd, char *cname)
{
	int c;
	int d;
	int utruth = 0;


	struct iwreq wrq;
	int i, j, coun, errflg, T_Rate, value;
	reverse = 1;
	conf_win = create_newwin(18, 70, 6, 0);
	keypad(conf_win, TRUE);
	refresh();
	print_my_menu(conf_win, reverse);

	while (1) {
		d = wgetch(conf_win);
		utruth = 0;
		switch (d) {
		case KEY_UP:
			if (reverse == 1)
				reverse = config_choices;
			else
				--reverse;
			break;
		case KEY_DOWN:
			if (reverse == config_choices)
				reverse = 1;
			else
				++reverse;
			break;
		case 10:
			epilogh = reverse;
			utruth = 1;
			break;
		default:
			refresh();
			break;
		}
		print_my_menu(conf_win, reverse);
		if (d == KEY_F(1)) {	/* User did a choice come out of the infinite loop */
			wclear(conf_win);
			destroy_win(conf_win);
			break;

		}
		if (utruth == 1) {
			if (epilogh == 11) {	/* User did a choice come out of the infinite loop */
				wclear(conf_win);
				destroy_win(conf_win);
				utruth = 0;
				break;

			}


			switch (epilogh) {
			case 1:	// Set ESSID NAME
				Set_ESSID(pAppInfo, cname, fd);
				refresh();
				break;
			case 2:	// Set Channel
				Set_Channel(pAppInfo, cname, fd);
				refresh();
				break;
			case 3:	// Set Radio 
				Set_Radio(pAppInfo, cname, fd);
				refresh();
				break;
			case 4:	// Set InternationalRoaming 
				Set_InternationalRoaming(pAppInfo, cname, fd);
				refresh();
				break;
			case 5:	// Transmit Rate...
				Set_TxRate(pAppInfo, cname, fd);
				refresh();
				break;
			case 6:	// Operating Mode
				Set_OpMode(pAppInfo, cname, fd);
				refresh();
				break;
			case 7:	// Preamble Type
				Set_Preamble(pAppInfo, cname, fd);
				refresh();
				break;
			case 8:	// PowerMgmtMode Threshold
				Set_PowerMgmtMode(pAppInfo, cname, fd);
				refresh();
				break;
			case 9:	// Fragmentation Threshold
				Set_FragT(pAppInfo, cname, fd);
				refresh();
				break;
			case 10:// Rts Threshold
				Set_RtsT(pAppInfo, cname, fd);
				refresh();
				break;
			default:
				break;
			}
			utruth = 0;
		}
	}
}
int WEP_KEY_CONV(int value, PUCHAR W_KEY)
{
	WINDOW *wep_key_val;
	int coun;
	int a, b, d;
	UCHAR Get_Arg[2 * LONG_WEP_KEY_SIZE + 1], size;
	char c;
	b = 0;
	a = 0;
	size = (W_KEY[0] == 1) ? 5 : 13;
	wep_key_val = newwin(18, 70, 6, 0);
	box(wep_key_val, 0, 0);
	mvwhline(wep_key_val, 2, 1, ACS_HLINE, 68);
	init_pair(9, COLOR_BLUE, COLOR_BLACK);
	wattron(wep_key_val, A_BOLD);
	wattron(wep_key_val, COLOR_PAIR(9));
	mvwprintw(wep_key_val, 1, 18, "Give Wep Key ( %i ) value", value);
	wattroff(wep_key_val, COLOR_PAIR(9));
	wattron(wep_key_val, COLOR_PAIR(1));
	mvwprintw(wep_key_val, 1, 46, "< Cancel : F1 >");
	wattroff(wep_key_val, COLOR_PAIR(1));

	wrefresh(wep_key_val);

	for (coun = 0; coun < size; coun++) {
		mvwprintw(wep_key_val, 3 + coun, 1,
			  "Byte %02d (two characters) \t: ", coun + 1);
		wrefresh(wep_key_val);
		for (a = 0; a < 2; a++) {
			echo();
			c = wgetch(wep_key_val);
			noecho();
			Get_Arg[a] = toupper(c);
			if ((Get_Arg[a] < 0x30) ||
			    ((Get_Arg[a] > 0x39) && (Get_Arg[a] < 0x41)) ||
			    (Get_Arg[a] > 0x46)) {
				return -1;
			}
			wrefresh(wep_key_val);
		}
		wrefresh(wep_key_val);
		W_KEY[b] = AsciiToByte(Get_Arg[0], Get_Arg[1]);
		b++;
	}
	while (d = getch()) {
		if (d == 10) {
			wclear(wep_key_val);
			destroy_win(wep_key_val);
			print_wep_menu(wep_win, wep_reverse);
			break;
		}
	}

	wattroff(wep_key_val, A_BOLD);
	return 0;
}

UCHAR AsciiToByte(UCHAR Ascii1, UCHAR Ascii2)
{
	UCHAR digit1, digit2;

	if (Ascii1 >= 0x30 && Ascii1 <= 0x39)
		digit1 = Ascii1 - 0x30;
	else if (Ascii1 >= 0x41 && Ascii1 <= 0x46)
		digit1 = Ascii1 - 0x31 - 6;

	if (Ascii2 >= 0x30 && Ascii2 <= 0x39)
		digit2 = Ascii2 - 0x30;
	else if (Ascii2 >= 0x41 && Ascii2 <= 0x46)
		digit2 = Ascii2 - 0x31 - 6;

	return (digit1 << 4) + digit2;
}

// Wep Key Information... Details available only if a wep key is used
int Get_Wep(PWEP_INFO pWepInfo, int fd, char *cname)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, cname);
	wrq.u.data.pointer = (caddr_t) pWepInfo;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_WEP_INFO;
	return ioctl(fd, SIOCDEVPRIVATE, &wrq);
}

int Get_Config(PDEVICE_CONFIGURATION pAppInfo, int fd, char *cname)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, cname);
	wrq.u.data.pointer = (caddr_t) pAppInfo;
	wrq.u.data.length = 0;	//sizeof(DEVICE_CONFIGURATION);//0;
	wrq.u.data.flags = GET_SUPPORT_INFO;
	return ioctl(fd, SIOCDEVPRIVATE, &wrq);
}

int Get_Stats(PSTATISTICS pStats, int fd, char *cname)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, cname);
	wrq.u.data.pointer = (caddr_t) pStats;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_STATISTICS;
	return ioctl(fd, SIOCDEVPRIVATE, &wrq);
}

int Get_Ver(PVERSION_INFO pVersionInfo, int fd, char *cname)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, cname);

	wrq.u.data.pointer = (caddr_t) pVersionInfo;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_VERSION_INFO;
	return ioctl(fd, SIOCDEVPRIVATE, &wrq);
}

void Print_Stats(WINDOW * conf_win, PDEVICE_CONFIGURATION pAppInfo,
		 PWEP_INFO pWepInfo, PSTATISTICS pStatistics)
{
	int i;
	char ch = ' ';
	wattron(conf_win, COLOR_PAIR(2));
	mvwprintw(conf_win, 1, 23, "Current Statistics");
	wattroff(conf_win, COLOR_PAIR(2));
	mvwhline(conf_win, 2, 1, ACS_HLINE, 68);
	mvwprintw(conf_win, 3, 1,
		  "Successfull Transmit Packets\t: %d      ",
		  pStatistics->TxDataPacketsOk);
	mvwprintw(conf_win, 4, 1, "Error Transmit Packets\t\t: %d    ",
		  pStatistics->TxDataPacketsError);
	mvwprintw(conf_win, 5, 1,
		  "Successfully Received Packets\t: %d      ",
		  pStatistics->RxDataPacketsOk);
	mvwprintw(conf_win, 6, 1, "Error Received Packets \t: %d         ",
		  pStatistics->RxDataPacketsError);

	DisplayDriverState(conf_win, pAppInfo->StationState,
			   pAppInfo->OperatingMode, pAppInfo->MgmtErrorCode);

	if ((pAppInfo->StationState == 0x05)
	    && (pAppInfo->OperatingMode == 1)) {
		mvwprintw(conf_win, 9, 34, "BSSID : ");
		for (i = 0; i < 6; i++)
			mvwprintw(conf_win, 9, 42 + (i * 3), "%02X-",
				  pAppInfo->BSSID[i]);
		mvwprintw(conf_win, 9, 60, "\b ");
	}
	mvwprintw(conf_win, 10, 1, "Channel \t\t\t: %d",
		  pAppInfo->Channel);
	mvwprintw(conf_win, 11, 1, "SSID	\t\t\t: ");
	for (i = 0; i < pAppInfo->SSIDlength; i++)
		mvwprintw(conf_win, 11, 34 + i, "%c", pAppInfo->SSID[i]);
	for (i = pAppInfo->SSIDlength; i < 32; i++)
		mvwprintw(conf_win, 11, 34 + i, "%c", ch);

	switch (pAppInfo->TxRate) {
	case 0:
		mvwprintw(conf_win, 12, 1,
			  "Transmit rate	\t\t: 1Mbps");
		break;
	case 1:
		mvwprintw(conf_win, 12, 1,
			  "Transmit rate	\t\t: 2Mbps");
		break;
	case 2:
		mvwprintw(conf_win, 12, 1,
			  "Transmit rate	\t\t: 5.5Mbps");
		break;
	case 3:
		mvwprintw(conf_win, 12, 1,
			  "Transmit rate	\t\t: 11Mbps");
		break;
	case 4:
		mvwprintw(conf_win, 12, 1,
			  "Transmit rate	\t\t: Auto");
		break;
	}
	switch (pAppInfo->OperatingMode) {
	case 0:
		mvwprintw(conf_win, 13, 1, "Operating Mode\t\t\t: Ad-Hoc");
		break;
	case 1:
		mvwprintw(conf_win, 13, 1,
			  "Operating Mode\t\t\t: Infrastructure");
		break;
	case 3:
		mvwprintw(conf_win, 13, 1,
			  "Operating Mode\t\t\t: Access Point Mode");
		break;
	default:
		mvwprintw(conf_win, 13, 1,
			  "Operating Mode\t\t: Auto or Unspecified....");
		break;
	}
	switch (pAppInfo->RadioIsOn) {
	case 0:
		mvwprintw(conf_win, 14, 1,
			  "Radio \t\t\t\t: Off");
		break;
	case 1:
		mvwprintw(conf_win, 14, 1,
			  "Radio \t\t\t\t: On");
		break;
        }
	switch (pAppInfo->PowerMgmtMode) {
	case 0:
		mvwprintw(conf_win, 15, 1,
			  "Power Mode\t\t\t: Active");
		break;
	case 1:
		mvwprintw(conf_win, 15, 1,
			  "Power Mode\t\t\t: Power Save");
		break;
	}
	switch (pAppInfo->InternationalRoaming) {
	case 0:
		mvwprintw(conf_win, 16, 1,
			  "International Roaming \t\t: Disable");
		break;
	case 1:
		mvwprintw(conf_win, 16, 1,
			  "International Roaming \t\t: Enable");
		break;
	}
}

void Print_Wep_Stats(WINDOW * wep_win, PWEP_INFO pWepInfo, PDEVICE_CONFIGURATION pAppInfo,
		     PSTATISTICS pStatistics)
{
	int i;
	wep_win = create_newwin(18, 70, 6, 0);
	wattron(wep_win, A_BOLD);
	mvwhline(wep_win, 2, 1, ACS_HLINE, 68);
	wattron(wep_win, COLOR_PAIR(2));
	mvwprintw(wep_win, 1, 5, "Wep Key Information (");
	wrefresh(wep_win);
	if (pWepInfo->EncryptionLevel) {
		mvwprintw(wep_win, 1, 26, "Enabled - Encryption Level %s)",
			  (pWepInfo->EncryptionLevel ==
			   1) ? "64-bit" : "128-bit");
		wattroff(wep_win, COLOR_PAIR(2));
		mvwprintw(wep_win, 4, 1, "Wep Key Used\t\t: ");
		wrefresh(wep_win);
		switch (pWepInfo->WepKeyToUse) {
		case 0:
			mvwprintw(wep_win, 4, 26, "One");
			wrefresh(wep_win);
			break;
		case 1:
			mvwprintw(wep_win, 4, 26, "Two");
			wrefresh(wep_win);
			break;
		case 2:
			mvwprintw(wep_win, 4, 26, "Three");
			wrefresh(wep_win);
			break;
		case 3:
			mvwprintw(wep_win, 4, 26, "Four");
			wrefresh(wep_win);
			break;
		case 4:
			mvwprintw(wep_win, 4, 26, "None");
			wrefresh(wep_win);
			break;
		}
	} else {
		init_pair(9, COLOR_RED, COLOR_BLACK);
		wattron(wep_win, COLOR_PAIR(9));
		mvwprintw(wep_win, 1, 35, "Disabled");
		wattroff(wep_win, COLOR_PAIR(9));
		wattron(wep_win, COLOR_PAIR(2));
		mvwprintw(wep_win, 1, 52, ")");
		wattroff(wep_win, COLOR_PAIR(2));
		wrefresh(wep_win);
	}
	if (pWepInfo->EncryptionLevel != 0) {
		UCHAR size_used =
		    (pWepInfo->EncryptionLevel == 1) ? 5 : 13;
		switch (pWepInfo->WepKeyToUse) {
		case 0:
			mvwprintw(wep_win, 5, 1, "Wep Key One\t\t: %02x",
				  pWepInfo->WepKey1[0]);
			for (i = 1; i < size_used; i++)
				mvwprintw(wep_win, 5, 25 + (i * 3),
					  ":%02X", pWepInfo->WepKey1[i]);
			mvwprintw(wep_win, 5, 41, "\b");
			wrefresh(wep_win);
			break;
		case 1:
			mvwprintw(wep_win, 5, 1, "Wep Key Two \t\t: %02x",
				  pWepInfo->WepKey2[0]);
			for (i = 1; i < size_used; i++)
				mvwprintw(wep_win, 5, 25 + (i * 3),
					  ":%02X", pWepInfo->WepKey2[i]);
			mvwprintw(wep_win, 5, 41, "\b");
			wrefresh(wep_win);
			break;
		case 2:
			mvwprintw(wep_win, 5, 1, "Wep Key Three\t\t: %02x",
				  pWepInfo->WepKey3[0]);
			for (i = 1; i < size_used; i++)
				mvwprintw(wep_win, 5, 25 + (i * 3),
					  ":%02X", pWepInfo->WepKey3[i]);
			mvwprintw(wep_win, 5, 41, "\b");
			wrefresh(wep_win);
			break;
		case 3:
			mvwprintw(wep_win, 5, 1,
				  "\tWep Key Four\t\t: %02x",
				  pWepInfo->WepKey4[0]);
			for (i = 1; i < size_used; i++)
				mvwprintw(wep_win, 5, 25 + (i * 3),
					  ":%02X", pWepInfo->WepKey4[i]);
			mvwprintw(wep_win, 5, 41, "\b");
			wrefresh(wep_win);
			break;
		}
		switch (pWepInfo->WepMode) {
		case 0:
			mvwprintw(wep_win, 6, 1,
				  "Wep Mode\t\t: Optional");
			wrefresh(wep_win);
			break;
		case 1:
			mvwprintw(wep_win, 6, 1, "Wep Mode\t\t: Mandatory");
			wrefresh(wep_win);
			break;
		}
		switch (pWepInfo->AuthenticationType) {
		case 0x0000:
			mvwprintw(wep_win, 7, 1,
				  "Authentication Type\t: Open System");
			wrefresh(wep_win);
			break;
		case 0x0001:
			mvwprintw(wep_win, 7, 1,
				  "Authentication Type\t: Shared Key");
			wrefresh(wep_win);
			break;
		}
		wattroff(wep_win, A_BOLD);
	}
	init_pair(33, COLOR_RED, COLOR_BLACK);
	wattron(wep_win, A_BOLD);
	mvwhline(wep_win, 9, 1, ACS_HLINE, 68);
	wattron(wep_win, COLOR_PAIR(33));
	mvwprintw(wep_win, 10, 24, "Advanced Settings");
	wrefresh(wep_win);
	wattroff(wep_win, COLOR_PAIR(33));
	mvwhline(wep_win, 11, 1, ACS_HLINE, 68);
	wrefresh(wep_win);
	switch (pAppInfo->PreambleType) {
	case 0:
		mvwprintw(wep_win, 13, 1, "Preamble Type\t\t\t: Long");
	        wrefresh(wep_win);
		break;
	case 1:
		mvwprintw(wep_win, 13, 1, "Preamble Type\t\t\t: Short");
	wrefresh(wep_win);
		break;
	}
	init_pair(4, COLOR_RED, COLOR_BLACK);
	if (pAppInfo->RtsCtsThreshold == 2347) {
		wattron(wep_win, COLOR_PAIR(4));
		mvwprintw(wep_win, 14, 44, "(Disabled)");
	wrefresh(wep_win);
		wattroff(wep_win, COLOR_PAIR(4));
	}
	mvwprintw(wep_win, 14, 1, "RtsCts Threshold \t\t: %i",
		  pAppInfo->RtsCtsThreshold);
	wrefresh(wep_win);
	if (pAppInfo->FragmentationThreshold == 2346) {
		wattron(wep_win, COLOR_PAIR(4));
		mvwprintw(wep_win, 15, 44, "(Disabled)");
	wrefresh(wep_win);
		wattroff(wep_win, COLOR_PAIR(4));
	}
	mvwprintw(wep_win, 15, 1, "Fragmentation Threshold\t: %i",
		  pAppInfo->FragmentationThreshold);
	wrefresh(wep_win);

}
void DisplayDriverState(WINDOW * conf_win, ULONG StatusCode, int mode, ULONG Mgmt)
{
	if ((StatusCode == 0x05) && (mode == 1)) {
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Associated ");
		return;
	}

	switch (StatusCode) {
	case 0x00:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Initializing");
		break;
	case 0x01:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: Scanning ");
		break;
	case 0x02:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: Joining ");
		break;
	case 0x03:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Authenticating");
		break;
	case 0x04:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Associating");
		break;
	case 0x05:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: Ready");
		break;
	case 0x06:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Station Out of Range");
		break;
	case 0x07:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Disassociating");
		break;
	case 0x08:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Disauthenticating");
		break;
	case 0x09:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Reassociating");
		break;
	case 0x0a:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Forced Joining");
		break;
	case 0x0b:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: ReConfiguring");
		break;
	case 0x0c:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: FW_Upgrade");
		break;
	case 0x0d:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Force Joining Failure");
		break;
	case 0x0e:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: Resetting");
		break;
	case 0x0f:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Reset Pending");
		break;
	case 0x13:
		mvwprintw(conf_win, 7, 1,
			  "Driver State	\t\t: Radio Off");
		break;
	case 0xf0:
		mvwprintw(conf_win, 7, 1,
			  "Driver State    \t\t: No card Present");
		break;
	case 0xf1:
                if(Mgmt == 0xa0){
		mvwprintw(conf_win, 7, 1, "Driver State\t\t\t: Enable Encryption to join this BSS");
                }else if(Mgmt == 0xa1){
		mvwprintw(conf_win, 7, 1, "Driver State:\t\t\t: Disable Encryption to join this BSS");
                }else{
                    mvwprintw(conf_win, 7, 1, "Driver State	\t\t: ");
                    DisplayErrorMsg(conf_win, StatusCode);
                }
		break;
	default:
		mvwprintw(conf_win, 7, 1, "Driver State	\t\t: ");
		mvwprintw(conf_win, 7, 34, "Not Known yet......		");

	}
}
void DisplayErrorMsg(WINDOW * conf_win, ULONG StatusCode)
{
	switch (StatusCode) {
	case 1:		//C80211_MGMT_SC_Unspecified:
		mvwprintw(conf_win, 7, 1,
			  "Unspecified error in Management Frame...\n");
		break;
	case 10:		//C80211_MGMT_SC_SupportCapabilities:
		mvwprintw(conf_win, 7, 1,
			  "Support Capabilities error in Association Request...");
		break;
	case 11:		//C80211_MGMT_SC_ReassDenied:
		mvwprintw(conf_win, 7, 1, "Re-Association Denied... \n");
		break;
	case 12:		//C80211_MGMT_SC_AssDenied:
		mvwprintw(conf_win, 7, 1, "Association Denied... \n");
		break;
	case 13:		//C80211_MGMT_SC_AuthAlgNotSupported:
		mvwprintw(conf_win, 7, 1,
			  "Authentication Algorithm not supported...");
		break;
	case 14:		//C80211_MGMT_SC_AuthTransSeqNumError:
		mvwprintw(conf_win, 7, 1,
			  "Bad Authentication transaction sequence number...");
		break;
	case 15:		//C80211_MGMT_SC_AuthRejectChallenge:
		mvwprintw(conf_win, 7, 1,
			  "Authentication challenge text rejection...");
		break;
	case 16:		//C80211_MGMT_SC_AuthRejectTimeout:
		mvwprintw(conf_win, 7, 1, "Authentication Timeout...");
		break;
	case 17:		//C80211_MGMT_SC_AssDeniedHandleAP:
		mvwprintw(conf_win, 7, 1,
			  "Access Point can not handle any more stations...");
		break;
	case 18:		//C80211_MGMT_SC_AssDeniedBSSRate:
		mvwprintw(conf_win, 7, 1,
			  "Association Denied (Supported Rates mismatch)...");
		break;
	default:
		mvwprintw(conf_win, 7, 1,
			  "Failed to co-operate with the selected Access Point");
	}
}
int open_sock(void)
{
	int inet_sock = -1;
	int ipx_sock = -1;
	int ax25_sock = -1;
	int ddp_sock = -1;

	inet_sock = socket(AF_INET, SOCK_STREAM, 0);
	ipx_sock = socket(AF_IPX, SOCK_STREAM, 0);
	ax25_sock = socket(AF_AX25, SOCK_STREAM, 0);
	ddp_sock = socket(AF_APPLETALK, SOCK_STREAM, 0);

	if (inet_sock != -1)
		return inet_sock;
	if (ipx_sock != -1)
		return ipx_sock;
	if (ax25_sock != -1)
		return ax25_sock;
	return ddp_sock;
}

void key_press(int ch)
{
	KB_SETTINGS new_set;

	tcgetattr(0, &Stored_Settings);

	new_set = Stored_Settings;

	/* Disable canonical mode, and set buffer size to 1 byte */
	new_set.c_lflag &= (~ICANON);
	new_set.c_cc[VTIME] = 0;
	new_set.c_cc[VMIN] = 1;
	if (ch == 1)
		new_set.c_lflag &= (~ECHO);
	tcsetattr(0, TCSANOW, &new_set);
}

void reset_keypress(void)
{
	tcsetattr(0, TCSANOW, &Stored_Settings);
}

#define PCMCIA  0
#define USB	1
#define WIDTH 70
#define HEIGHT 3

int startx = 0;
int starty = 0;

char *choices[] = {
	"View Configuration",
	"Advanced",
	"Configure Wep",
	"Configure Card",
	"Exit",
};
int total;
int n_choices = sizeof(choices) / sizeof(char *);
static void finish(int sig);

//WINDOW *create_newwin(int height, int width, int starty, int startx);

//void destroy_win(WINDOW *local_win);

//void print_menu(WINDOW *menu_win, int highlight);

int main(int args, char *argv[])
{
	WINDOW *menu_win;
	int highlight = 1;
	int choice = 0;
	int d, sttruth = 0;
	int k;

	int ch, fd, i, cmd, res;
	char *c, conv;
	char com1[12], com2[12];
	DEVICE_CONFIGURATION pAppInfo;
	WEP_INFO pWepInfo;
	VERSION_INFO pVersionInfo;
	STATISTICS Stats;
	struct iwreq wrq;
	unsigned char BoardFound = 0;
	unsigned char CardRequested;
	STR_LIST str_list;

	initscr();
	clear();
	noecho();
	cbreak();

	memset(&wrq, 0, sizeof(struct iwreq));
	signal(SIGINT, no_quit);
	no_card_win = newwin(6, 50, 10, 15);
	box(no_card_win, 0, 0);
	for (i = 0; i < n_choices; ++i) {
		total += strlen(choices[i]);
	}
	total = (WIDTH - total) / n_choices;

	if (args > 1) {
		if ((strncmp(argv[1], "f", 1) == 0)
		    || (strncmp(argv[1], "-f", 2) == 0)) {
			read_conf(&str_list);
		} else if (strncmp(argv[1], "u", 1) == 0) {
			CardRequested = USB;
		} else if (strncmp(argv[1], "u", 1) == 0) {
			CardRequested = PCMCIA;
		} else {
			return -1;
		}
		return 0;
	}

	fd = open_sock();
	if (fd < 0) {
		start_color();
		init_pair(1, COLOR_RED, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
		mvwprintw(no_card_win, 2, 2, "No card found !!!", fd);
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		exit(EXIT_FAILURE);
	}


	for (i = 0; i < 8; i++) {
		sprintf(ifname, "eth%d", i);
		strcpy(wrq.ifr_name, ifname);

		res = ioctl(fd, SIOCGIWNAME, &wrq);
		if (res < 0)
			continue;

		if ((strncmp(wrq.u.name, "ATMEL USB503A", 13) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL INTERSIL", 14) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL RFMD503A", 14) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL RFMD505", 13) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL RFMD", 10) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL REVD", 10) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL REVE", 10) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL 504", 9) != 0) &&
		    (strncmp(wrq.u.name, "ATMEL PCI", 10) != 0)
		    )
			continue;
		BoardFound |= (1 << i);
		break;
	}

	if (!BoardFound) {
		start_color();
		init_pair(1, COLOR_BLUE, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
#ifdef ATMEL
		mvwprintw(no_card_win, 2, 13, "%s - Card not found",
			  CompanyName);
#elif defined(SMARTBRIDGES)
		mvwprintw(no_card_win, 2, 10, "%s - Card not found",
			  CompanyName);
#endif
		mvwprintw(no_card_win, 3, 12, "Please Insert your Card!");
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		return -ENODEV;
	}

	if (Get_Config(&pAppInfo, fd, wrq.ifr_name) != 0) {
		start_color();
		init_pair(1, COLOR_RED, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
		mvwprintw(no_card_win, 2, 2,
			  "Get Configuration failed...");
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		return -ENODEV;
	}
	if (Get_Stats(&Stats, fd, wrq.ifr_name)) {
		start_color();
		init_pair(1, COLOR_RED, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
		mvwprintw(no_card_win, 2, 2, "Get Statistics failed...");
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		return -ENODEV;
	}
	if (Get_Wep(&pWepInfo, fd, wrq.ifr_name)) {
		start_color();
		init_pair(1, COLOR_RED, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
		mvwprintw(no_card_win, 2, 2, "Get Wep Info failed...");
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		return -ENODEV;
	}
	if (Get_Ver(&pVersionInfo, fd, wrq.ifr_name)) {
		start_color();
		init_pair(1, COLOR_RED, COLOR_BLACK);
		wattron(no_card_win, A_BOLD);
		wattron(no_card_win, COLOR_PAIR(1));
		mvwprintw(no_card_win, 2, 2, "Get Version failed...");
		wattroff(no_card_win, COLOR_PAIR(1));
		wattroff(no_card_win, A_BOLD);
		wrefresh(no_card_win);
		clear();
		endwin();
		return -ENODEV;
	}
	startx = (70 - WIDTH) / 2;
	starty = (9 - HEIGHT) / 2;

	menu_win = newwin(HEIGHT, WIDTH, starty, startx);

	keypad(menu_win, TRUE);
	keypad(stdscr, TRUE);
	start_color();
	init_pair(2, COLOR_BLUE, COLOR_BLACK);
	attron(A_BOLD);
	attron(COLOR_PAIR(2));
	mvprintw(0, 2,
		 "%s Wireless Card Monitor Utility for interface %s - Card Type %s\n",
		 CompanyName, ifname, &wrq.u.name[6]);
	mvprintw(1, 9, "Driver Version :");
	init_pair(8, COLOR_YELLOW, COLOR_BLACK);
	attron(COLOR_PAIR(8));
	mvprintw(1, 26, "%d.%d.%d.%d ", pVersionInfo.DriverMajorVersion,
		 pVersionInfo.DriverMinorVersion,
		 pVersionInfo.DriverSubVersion, pVersionInfo.DriverBuild);
	attroff(COLOR_PAIR(8));
	attron(COLOR_PAIR(2));
	mvprintw(1, 38, "Firmware Version :");
	attroff(COLOR_PAIR(2));
	attron(COLOR_PAIR(8));
	mvprintw(1, 57, "%d.%d.%d.%d", pVersionInfo.FwMajorVersion,
		 pVersionInfo.FwMinorVersion, pVersionInfo.FwSubVersion,
		 pVersionInfo.FwBuild);
	attroff(COLOR_PAIR(8));
	attroff(COLOR_PAIR(2));
	init_pair(1, COLOR_RED, COLOR_BLACK);
	attron(COLOR_PAIR(2));
	mvprintw(2, 0,
		 "Use arrow keys to go left and right.Press enter to select a choice");
	printw(" <F1:Exit>");
	attroff(COLOR_PAIR(2));
	attroff(A_BOLD);
	refresh();
	print_menu(menu_win, highlight);

	while (1) {
		d = wgetch(menu_win);
		sttruth = 0;
		switch (d) {
		case KEY_LEFT:
			if (highlight == 1)
				highlight = n_choices;
			else
				--highlight;
			break;
		case KEY_RIGHT:
			if (highlight == n_choices)
				highlight = 1;
			else
				++highlight;
			break;
		case 10:
			choice = highlight;
			sttruth = 1;
			break;
		default:
			refresh();
			break;
		}
		print_menu(menu_win, highlight);
		if ((choice == 5) || (d == KEY_F(1))) {	/* User did a choice come out of the infinite loop */
			clear();
			refresh();
			exit_win = newwin(6, 50, 10, 15);
			box(exit_win, 0, 0);
			wattron(exit_win, A_BOLD);
			wattron(exit_win, COLOR_PAIR(2));
			mvwprintw(exit_win, 1, 14, "You Exited Normally");
			mvwprintw(exit_win, 2, 22, "FROM");
			mvwprintw(exit_win, 3, 9,
				  "ATMEL's Card Configuration tool");
			wattroff(exit_win, COLOR_PAIR(2));
			wattroff(exit_win, A_BOLD);
			wrefresh(exit_win);
			refresh();
			break;
		}
		if (sttruth == 1) {
			if (choice == 5) {
				sttruth = 0;
				break;
			}

			switch (choice) {
			case 1:

				set_win = create_newwin(18, 70, 6, 0);
				wattron(set_win, A_BOLD);
				Get_Stats(&Stats, fd, wrq.ifr_name);
				Get_Config(&pAppInfo, fd, wrq.ifr_name);
				Print_Stats(set_win, &pAppInfo, &pWepInfo,
					    &Stats);
				wattroff(set_win, A_BOLD);
				wrefresh(set_win);
				refresh();
				break;
			case 2:
				attron(A_BOLD);
				Get_Stats(&Stats, fd, wrq.ifr_name);
				Get_Config(&pAppInfo, fd, wrq.ifr_name);
				Print_Wep_Stats(wep_win, &pWepInfo, &pAppInfo,
						&Stats);
				attroff(A_BOLD);
				refresh();
				break;
			case 3:
				WepDlg(&pAppInfo, wrq.ifr_name, fd,
				       &pWepInfo);
				refresh();
				break;
			case 4:
				read_ioctls_wlan(&pAppInfo, &pWepInfo, fd,
						 wrq.ifr_name);
				refresh();
				break;
			default:
				refresh();
				break;
			}
			sttruth = 0;
		}
	}
	signal(SIGINT, no_quit);

	clrtoeol();
	refresh();
	endwin();
	return 0;
}


void print_menu(WINDOW * menu_win, int highlight)
{
	int x, y, i;
	x = 2;
	y = 2;
	box(menu_win, 0, 0);
	noecho();
	for (i = 0; i < n_choices; ++i) {
		if (highlight == i + 1) {	/* High light the present choice */
			wattron(menu_win, A_REVERSE | A_BOLD);
			mvwprintw(menu_win, 1, x, "%s", choices[i]);
			wattroff(menu_win, A_REVERSE | A_BOLD);
		} else
			mvwprintw(menu_win, 1, x, "%s", choices[i]);
		x += (strlen(choices[i]) + total);
	}
	wrefresh(menu_win);
}

WINDOW *create_newwin(int height, int width, int starty, int startx)
{
	WINDOW *local_win;

	local_win = newwin(height, width, starty, startx);
	box(local_win, 0, 0);
	/* 0, 0 gives default characters
	 * for the vertical and horizontal
	 * lines            */
	wrefresh(local_win);	/* Show that box */

	return local_win;
}

WINDOW *create_inputwin(int height, int width, int starty, int startx)
{
	WINDOW *local_win;

	local_win = newwin(height, width, starty, startx);
//	box(local_win, 0, 0);
	/* 0, 0 gives default characters
	 * for the vertical and horizontal
	 * lines            */
	wrefresh(local_win);	/* Show that box */

	return local_win;
}

void destroy_win(WINDOW * local_win)
{
	wborder(local_win, ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ');
	wrefresh(local_win);
	delwin(local_win);
}
void print_my_menu(WINDOW * my_win, int reverse)
{
	int x, y, i;
	x = 4;
	y = 3;
	box(my_win, 0, 0);
	wattron(my_win, A_BOLD);
	wattron(my_win, COLOR_PAIR(2));
	mvwprintw(my_win, 1, 21, "Card Configuration Menu");
	wattroff(my_win, COLOR_PAIR(2));
	mvwhline(my_win, 2, 1, ACS_HLINE, 68);
	wattroff(my_win, A_BOLD);
	for (i = 0; i < config_choices; i++) {
		if (reverse == i + 1) {	/* High reverse the present choice */
			wattron(my_win, A_BOLD);
			wattron(my_win, A_REVERSE);
			mvwprintw(my_win, y, x, "%s", conf_choices[i]);
			wattroff(my_win, A_REVERSE);
			wattroff(my_win, A_BOLD);
		} else
			mvwprintw(my_win, y, x, "%s", conf_choices[i]);
		y++;
	}
	wrefresh(my_win);
}


void no_quit(int signum)
{
	signal(SIGINT, no_quit);
	signal(SIGINT, SIG_IGN);
}
