/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
/***********************************************************
    Set FUNCTIONS......	
***********************************************************/
int Set_ESSID(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_Channel(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_TxRate(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_Radio(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_InternationalRoaming(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_OpMode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_Preamble(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_PowerMgmtMode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_FragT(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd);
int Set_Enc_Wep(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pwep_info);
int Set_Wep_Value(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pwep_info);
int Set_Key_Val(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pwep_info);
int Set_Auth_Wep(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pwep_info);
int Set_Wep_Mode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pwep_info);

void ssid_signal(int);
void channel_signal(int);
void power_signal(int);



/***********************************************************
    Get FUNCTIONS......	
***********************************************************/
int Get_Wep(PWEP_INFO pWepInfo, int fd, char *cname);
int Get_Config(PDEVICE_CONFIGURATION pAppInfo,int fd, char *cname);
int Get_Stats(PSTATISTICS pStats, int fd, char *cname);
int Get_Ver(PVERSION_INFO pVersionInfo, int fd, char *cname);

/***********************************************************
    Dialog FUNCTIONS......	
***********************************************************/
int WepDlg(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo);
void read_ioctl_wlan(PDEVICE_CONFIGURATION pAppInfo, PWEP_INFO pWepInfo, int fd, char *cname);
void Print_Stats(WINDOW * conf_win, PDEVICE_CONFIGURATION pAppInfo, PWEP_INFO pWepInfo, PSTATISTICS pStatistics);
void Print_Wep_Stats(WINDOW *wep_win, PWEP_INFO pWepInfo, PDEVICE_CONFIGURATION pAppInfo, PSTATISTICS pStatistics);
void DisplayDriverState(WINDOW *conf_win, ULONG StatusCode,int mode, ULONG Mgmt);
void DisplayErrorMsg(WINDOW *conf_win, ULONG StatusCode);

/***********************************************************
    Convertion FUNCTIONS......	
***********************************************************/
UCHAR AsciiToByte(UCHAR Ascii1, UCHAR Ascii2);
int WEP_KEY_CONV(int value,PUCHAR W_KEY);

//misc
void no_quit(int signum);
void key_press(int ch);
void reset_keypress(void);
static int open_sock(void);
void destroy_win(WINDOW *local_win);
void print_menu(WINDOW *menu_win, int highlight);
void print_my_menu(WINDOW *my_win, int reverse);
WINDOW *create_newwin(int height, int width, int starty, int startx);
WINDOW *create_inputwin(int height, int width, int starty, int startx);
void print_wep_menu(WINDOW *wep_win, int wep_reverse);


 



int read_conf(PSTR_LIST str_list);
