/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/


#ifndef __Vnet_Linux_h_OK__
#define __Vnet_Linux_h_OK__

#include <linux/config.h>
#include <linux/version.h>

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#endif

#ifndef HAS_WIRELESS_EXTENSIONS
#define HAS_WIRELESS_EXTENSIONS
#endif

#ifdef __IN_PCMCIA_PACKAGE__
#include <pcmcia/config.h>
#include <pcmcia/k_compat.h>
#endif

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/ptrace.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <asm/io.h>
#include <asm/system.h>

#include <asm/uaccess.h>
#ifdef PCI
#include <linux/pci.h>
#include <linux/init.h>
#else
#include <pcmcia/version.h>
#include <pcmcia/cs_types.h>
#include <pcmcia/cs.h>
#include <pcmcia/cistpl.h>
#include <pcmcia/cisreg.h>
#include <pcmcia/ds.h>
#endif //PCI

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/if_arp.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>

#ifdef HAS_WIRELESS_EXTENSIONS
#include <linux/wireless.h>
#if WIRELESS_EXT < 5
#error "Wireless extension v5 or newer required"
#endif
#endif

#if defined(PCMCIA_DEBUG)||defined(PCI_DEBUG)
#define DBG     1
extern int pc_debug;
#define IF_VNetDEBUG(f) if (pc_debug & (f))
#endif

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#endif


typedef char				CHAR;
typedef unsigned char   	UCHAR;
typedef unsigned short  	USHORT;
typedef unsigned long   	ULONG;
typedef unsigned int    	UINT;

typedef char* 				PCHAR;
typedef unsigned char* 		PUCHAR;
typedef unsigned short*		PUSHORT;
typedef unsigned long* 		PULONG;
//#ifdef RFMD_3COM
//typedef int	 		BOOLEAN;
//#else
typedef char	 		BOOLEAN;
//#endif
typedef void			VOID;
typedef void*			PVOID;

#define TRUE	1
#define FALSE	0

#define VNET_IO_LENGTH 0x20
#define MGMT_JIFFIES (256 * HZ / 100)

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,43))
#define netif_stop_queue(dev)	set_bit(0, (void *)&(dev)->tbusy)
#define netif_start_queue(dev)	clear_bit(0, (void *)&(dev)->tbusy)
#define netif_wake_queue(dev) \
    do { netif_start_queue(dev); mark_bh(NET_BH); } while (0)
#define netif_device_attach(dev) \
    do { (dev)->start = 1; netif_start_queue(dev); } while (0)
#define netif_device_detach(dev) \
    do { (dev)->start = 0; netif_stop_queue(dev); } while (0)
#define netif_device_present(dev) ((dev)->start)
#define netif_running(dev)	((dev)->start)
#define netif_mark_up(dev)	do { (dev)->start = 1; } while (0)
#define netif_mark_down(dev)	do { (dev)->start = 0; } while (0)
#define netif_carrier_on(dev)	do { dev->flags |= IFF_RUNNING; } while (0)
#define netif_carrier_off(dev)	do { dev->flags &= ~IFF_RUNNING; } while (0)
#define netif_queue_stopped(dev) ((dev)->tbusy)
#define tx_timeout_check(dev, tx_timeout) \
    do { if (test_and_set_bit(0, (void *)&(dev)->tbusy) != 0) { \
	if (jiffies - (dev)->trans_start < TX_TIMEOUT) return 1; \
	tx_timeout(dev); \
    } } while (0)
#define dev_kfree_skb_irq(skb)	DEV_KFREE_SKB(skb)
#else
#define netif_mark_up(dev)	do { } while (0)
#define netif_mark_down(dev)	do { } while (0)
#define tx_timeout_check(d,h)	netif_stop_queue(d)
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,99))
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0))
/* A nasty hack: we only need to set up dev->init on 2.0.* kernels,
   and this is a convenient place to bury it */
#define init_dev_name(dev, node) \
  do { static int __dummy(struct net_device *dev) { return 0; } \
    dev->init = &__dummy; (dev)->name = (node).dev_name; \
  } while (0)
#else
#define init_dev_name(dev, node) (dev)->name = (node).dev_name
#endif
#define copy_dev_name(node, dev) do { } while (0)
#else
#define init_dev_name(dev, node) do { } while (0)
#define copy_dev_name(node, dev) strcpy((node).dev_name, (dev)->name)
#endif

#ifndef VERSION
#define VERSION(v,p,s) (((v)<<16)+(p<<8)+s)
#endif
#endif // __Vnet_Linux_h_OK__
