/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#ifndef __command_h_OK__
#define	__command_h_OK__
//
//	Vendor Requests
//

#define	DEVICE_VENDOR_REQUEST_OUT				0x40
#define	DEVICE_VENDOR_REQUEST_IN				0xC0
#define	INTERFACE_VENDOR_REQUEST_OUT			0x41
#define	INTERFACE_VENDOR_REQUEST_IN				0xC1
#define	CLASS_REQUEST_OUT						0x21
#define	CLASS_REQUEST_IN						0xA1


#define	CMD_STATUS_IDLE							0x00
#define	CMD_STATUS_COMPLETE						0x01
#define	CMD_STATUS_UNKNOWN						0x02
#define	CMD_STATUS_INVALID_PARAMETER			0x03
#define	CMD_STATUS_FUNCTION_NOT_SUPPORTED		0x04
#define	CMD_STATUS_TIME_OUT						0x07
#define	CMD_STATUS_IN_PROGRESS					0x08
#define	CMD_STATUS_HOST_FAILURE					0xff
#define CMD_Scan_Failed							0xf0

#define CMD_SetMib      					0x01
#define CMD_GetMib							0x02
#define	CMD_Scan							0x03
#define CMD_Join							0x04
#define CMD_StartIBSS						0x05
#define CMD_CmdStatus   					0x06
#define CMD_GetOpMode						0x07
#define CMD_GetHWCfg						0x08
#define	CMD_Startup							0x0B
#define CMD_FWInternal						0x09
#define CMD_FWExternal						0x0A
#define CMD_DFUState						0x0C
#define CMD_DFUStatus						0x0D
#define CMD_REMAP						0x0F
#define CMD_DFUdetach						0x10

#define CMD_SetPreamble						0x11
#define CMD_SetFrag						0x12
#define CMD_SetRTS						0x13
#define CMD_SetARFB						0x14
#define CMD_WEP_SET						0x15
#define CMD_WEP_CHANGED						0x16

#define CMD_NewBSS						0x20
#define CMD_NewBSS_NewBSSID					0x21

#define CMD_SetNewBSS_OK					0x22
#define CMD_GetOpRates						0x23
#define CMD_GetRegDomain					0x24
#define CMD_SetMac						0x25
#define CMD_SetRadioOn                                          0x26
#define CMD_SetRadioOff                                         0x27
#define CMD_GetChannelList                                      0x28
#define CMD_SetIRoaming						0x29

typedef struct __SCAN {
	UCHAR	BSSID[6];
	UCHAR	SSID[32];
	UCHAR	ScanType;
	UCHAR	Channel;
	USHORT	ProbeDelay;
	USHORT	MinChannelTime;
	USHORT	MaxChannelTime;
	UCHAR	SSIDSize;
	UCHAR	InternationalScan;
}SCAN;

typedef struct __JOIN {
 	UCHAR	BSSID[6];
 	UCHAR	SSID[32];
 	UCHAR	BSSType;
 	UCHAR	Channel;
 	USHORT	JoinFailureTimeout;
 	UCHAR	SSIDSize;
 	UCHAR	Reserved;
}JOIN;

typedef struct __START_BSS {
	UCHAR	BSSID[6];
	UCHAR	SSID[32];
	UCHAR	BSSType;
	UCHAR	Channel;
	UCHAR	SSIDSize;
	UCHAR	Reserved[3];
}START_BSS;

typedef struct __USB_CARD_CONFIG{
	UCHAR		ExcludeUnencrypted;
	UCHAR		PromiscuousMode;
	UCHAR		ShortRetryLimit;
	UCHAR		EncryptionType;
	USHORT		RtsThreshold;
	USHORT		FragmentationThreshold;		// 256..2346
	UCHAR		BasicRateSet[4];
	BOOLEAN		AutoRateFallBack;			//0,1
	UCHAR		Channel;
	BOOLEAN		PrivacyInvoked;
	UCHAR		WEPDefaultKeyID;			// 0..3
	UCHAR		CurrentSSID[32];
	UCHAR		WEPDefaultKeyValue[4][WEP_KEY_SIZE];
	UCHAR		SSIDLen;
	UCHAR		ShortPreamble;
	USHORT		BeaconPeriod;
}USB_CARD_CONFIG, *PUSB_CARD_CONFIG;


// DFU Procedure defines.
#define STATE_appIDLE  					0
#define STATE_appDETACH 				1
#define STATE_dfuIDLE   				2
#define STATE_dfuDNLOAD_SYNC			3
#define STATE_dfuDNBUSY 				4
#define STATE_dfuDNLOAD_IDLE    		5
#define STATE_dfuMANIFEST_SYNC			6
#define STATE_dfuMANIFEST   			7
#define STATE_dfuMANIFEST_WAIT_RESET	8
#define STATE_dfuUPLOAD_IDLE			9
#define STATE_dfuERROR      			10

#endif //__command_h_OK__


