/****************************************************************
**
** Attal : Lords of Doom
**
** campaignEditor.cpp
** main file for the campaign editor
**
** Version : $Id: campaignEditor.cpp,v 1.8 2005/11/21 21:16:11 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 20/08/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/



#include <iostream>
using namespace std;
// include files for QT
#include <QApplication>
#include <QDir>
#include <QString>
#include <QTextCodec>
#include <QTranslator>

// application specific includes
#include "conf.h"

#include "libCommon/attalCommon.h"
#include "libCommon/log.h"

#include "libClient/gui.h"

#include "campaignEditor/campaignInterface.h"

extern QString IMAGE_PATH;
extern QString MUSIC_PATH;
extern QString SOUND_PATH;
extern QString DATA_PATH;
extern QString CAMPAIGN_PATH;
extern QString SCENARIO_PATH;
extern QString THEME;

#ifdef WITH_SOUND
extern bool ATT_SOUND;
#endif

int main( int argc, char **argv )
{
	QDir trfolder;
	trfolder = translationsDir(); 

	QApplication app( argc, argv );
	QTranslator translator( 0 );
	translator.load( QString("scenario_editor_") + QTextCodec::locale(), trfolder.absPath() );

	app.installTranslator( &translator );
	
	#ifdef WITH_SOUND
	ATT_SOUND = false;
	#endif

	for( int i = 1; i < argc; i++ ) {
		if ( strcmp( argv[i], "-theme" ) == 0 ) {
			i++;
			if( i < argc ) {
				THEME = QString( argv[i] );
			}
		} else if( ( strcmp( argv[i], "-v" ) == 0 )  ) {	
			int level;
			level = atoi(argv[i+1]) ;
			setLogLevel((LogLevel) level ) ;
		} else if( ( strcmp( argv[i], "-help" ) == 0 ) || ( strcmp( argv[i], "--help" ) == 0 ) ) {
			cout << "Usage: campaignEditor [OPTION]"  << endl;
			cout << "Start campaignEditor "  << endl;
			cout << endl;
			cout << "  -theme  --theme [NAME]      Load a particular theme (Medieval by default)"  << endl;
			cout << "  -v [LEVEL]                  Level of error messages (0-4) (default 4)"  << endl;
			cout << "  --help                      This screen"  << endl;
			return 1;
		}	
	}
	useTheme();
	
	CampaignInterface edit;
	app.setMainWidget( &edit );
        edit.show();

	return app.exec();	
}
