/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalCell.cpp
** this class draws an animated cell
**
** Version : $Id: graphicalCell.cpp,v 1.8 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier - Sardi Carlo
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalCell.h"

// generic include files
// include files for QT
#include <QApplication>
#include <Q3Canvas>
#include <QColor>
#include <Q3PointArray>
// application specific include
#include "libClient/cell.h"
#include "libClient/imageTheme.h"

#include "libCommon/dataTheme.h"
#include "libCommon/genericDecoration.h"
#include "libCommon/log.h"

#include "conf.h"

/** size in pixel of a cell */
const int GraphicalCell::_size = 30 ;

/** rtti number for GraphicalCell class */
const int GraphicalCell::RTTI = 2345;

extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;
extern DataTheme DataTheme;


//
// ----- GraphicalCell -----
//

/** create an animated cell from pixmaps at position row,col */
GraphicalCell::GraphicalCell( int row, int col , Q3Canvas *canvas)
	: Q3CanvasSprite( ImageTheme.cells[0], canvas )
{
	canvas->setBackgroundColor( QColor(255,255,255) );

	_diversGr = 0;
	collisions( true );
	setFrame( 0 );
	move( _size*col, _size*row );
	setZ( CAN_GROUND );
	show();
}

GraphicalCell::~GraphicalCell()
{

}

void GraphicalCell::setType( int type )
{
	setSequence( ImageTheme.cells[type] );
	setFrame( 0 );
}

void GraphicalCell::setDiversification( uint divers )
{
	_diversGr = divers;
	setFrame( 2 * divers );
}

/** return if a point is on the cell */
bool GraphicalCell::hit( const QPoint &p ) const
{
	return boundingRect().contains( p );
}

void GraphicalCell::activateGrid( bool activate )
{
	if(activate) {
		setFrame( 2 * _diversGr + 1);
	} else {
		setFrame( 2 * _diversGr);
	}
	canvas()->update();
	update();
}


//
// ----- Transition -----
//

Transition::Transition( Cell * parent, Q3Canvas *canvas)
	: GraphicalCell( parent->getRow(), parent->getCol(), canvas )
{
	_parent = parent;
}

void Transition::setTransition( int transition, int type )
{
	setZ( CAN_TRANS );

	// XXX: Ugly
	if( type == 0) {
		type = 1;
	}
	_tranGr = transition;

	setSequence( ImageTheme.transition[type-1] );
	
	setFrame( 2 * (transition - 1) );	
}

void Transition::activateGrid( bool activate )
{
	if(activate) {
		setFrame( 2 * ( _tranGr - 1 )  + 1);
	} else {
		setFrame( 2 * ( _tranGr - 1) );
	}
	canvas()->update();
	update();
}


//
// ----- Decoration -----
//

Decoration::Decoration( Cell * parent, Q3Canvas *canvas)
	: GraphicalCell( parent->getRow(), parent->getCol(), canvas )
{
	_parent = parent;
	setZ( CAN_DECO );
	setFrame( 0 );
}

void Decoration::setDecoration( uint group, uint item )
{
	setSequence( ImageTheme.decoration[ group-1 ] );
	setFrame( item );

	DecorationGroup * decoGroup = DataTheme.decorations.at( group );
	
	GenericDecoration * decor = decoGroup->at( item );
	if( ( decor->getWidth() > 1 ) || ( decor->getHeight() > 1 ) ) {
		int offsetRow = decor->getHeight() - ( 1 + decor->getDoorRow() );
		int offsetCol = 0 - decor->getDoorCol();

		QRect rect = _parent->boundingRect();
		move( rect.x() + ( offsetCol * rect.width() ),
		rect.y() + rect.height() - boundingRect().height() + ( offsetRow * rect.height() ) );

		canvas()->update();
	}
}
