/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.cpp
** draw a hero on the map
**
** Version : $Id: graphicalLord.cpp,v 1.13 2006/01/25 20:08:59 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalLord.h"

 
// generic include files

// include files for QT
#include <QColor>
#include <Q3PtrList>
#include <QRect>
//Added by qt3to4:
#include <QPixmap>
// application specific include
#include "conf.h"

#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"



/** rtti number for GraphicalLord class */
const int GraphicalLord::RTTI = 1234;

extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;

GraphicalLord::GraphicalLord( Q3Canvas * canvas )
	: Q3CanvasSprite( ImageTheme.lords, canvas ) 
{
 	collisions( true );
 	setFrame( 0 );
	setZ( CAN_LORD );
	Q3PtrList<QPixmap> listPixmapLord;	
	listPixmapLord.setAutoDelete( true );
	listPixmapLord.append( new QPixmap( IMAGE_PATH + "units/lord.png" ) );
	Q3PtrList<QPoint> listPointLord;
	listPointLord.setAutoDelete( true );
	listPointLord.append( new QPoint(0,0) );
	Q3CanvasPixmapArray * tryi = new Q3CanvasPixmapArray( listPixmapLord, listPointLord );
	setSequence( tryi );
	
	_flag = new Flag( canvas );
	
	show();
}

GraphicalLord::~GraphicalLord()
{
	if( _flag ) {
		delete _flag;
	}
}

/** set the hero on the cell */
void GraphicalLord::setPosition( Cell *cell )
{
	QRect rect = cell->boundingRect();
	move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
	if( _flag ) {
		_flag->move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
		_flag->setVisible( true );
		_flag->setZ( CAN_LORD + cell->getRow() + 1 );
	}
	
	setZ( CAN_LORD + cell->getRow() );
	setVisible( true );
	canvas()->update();
}

void GraphicalLord::setVisible( bool state )
{
	Q3CanvasSprite::setVisible( state );
	if( _flag ) {
		_flag->setVisible( state );
	}
}

void GraphicalLord::goTo( GenericCell *cell )
{
	QRect rect = ( (Cell *)cell )->boundingRect();
	move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
	if( _flag ) {
		_flag->move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
		_flag->setZ( CAN_LORD + cell->getRow() + 1 );
	}

	canvas()->update();
	update();
	setZ( CAN_LORD + cell->getRow() );
}

void GraphicalLord::advance( int /*stage*/ )
{
	/// XXX: TODO
	//logEE( "not yet implemented" );
}

void GraphicalLord::setOwner( GenericPlayer * player )
{
	_flag->setOwner( player );
	_imabk = image()->toImage();
}

void GraphicalLord::highlight( bool state)
{

	if(state) {
		QImage ima = image()->toImage();
		ima.convertDepth( 32 );

		int w = ima.width();
		int h = ima.height();

		QImage img( w, h, 32 );
		img.setAlphaBuffer( TRUE );

		for ( int x = 0; x < w; x++ ) {/*
			for ( int y = 0; y < h/2; y++ ) {
				QRgb pixel = (x<w&y<h) ? ima.pixel( x, y ) : 0;
				img.setPixel( x, y, colorH( pixel ) );
			}
			for ( int y = h/2; y < h; y++ ) {
				QRgb pixel = (x<w&y<h) ? ima.pixel( x, y ) : 0;
				img.setPixel( x, y, pixel  );
			}*/
			for ( int y = 0; y < h; y++ ) {
				QRgb pixel = ima.pixel( x, y );
				img.setPixel( x, y, colorH( pixel ) );
			}
		}

		image()->convertFromImage( img );
	} else {
		image()->convertFromImage( _imabk );
	}
	canvas()->update();
	update();
}

/*
void GraphicalLord::setColor( QColor color )
{
	QImage ima = image()->toImage();
	uint *p;
	for( int i = 0; i < 8; i++ ) 
		for( int j = 0; j < 8; j++ ) {
			p = (uint *)ima.scanLine(i) + j;
			*p = color.rgb();
		}
	image()->convertFromImage( ima );
}*/

Q3CanvasPixmap* GraphicalLord::imageAdvanced() const
{
	return image();
}

QRgb GraphicalLord::colorH( QRgb v )
{
	int ach = qAlpha(v);
	if ( ach == 255 )
		return v;

	int r = ( qRed(v) + 255 ) / 2;
	int g = ( qGreen(v) + 255 ) / 2;
	int b = ( qBlue(v) + 255 ) / 2;
	return qRgba(r,g,b,ach);
	//return qRgba(255,255,255,ach);
}

