/****************************************************************
**
** Attal : Lords of Doom
**
** imageTheme.h
** manage images in theme
**
** Version : $Id: imageTheme.h,v 1.21 2005/12/30 19:59:52 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 10/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef IMAGETHEME_H
#define IMAGETHEME_H
 

// generic include files
// include files for QT
#include <Q3Canvas>
#include <Q3PointArray>
#include <Q3ValueList>
//Added by qt3to4:
#include <QPixmap>
#include <Q3PtrList>
// application specific include files
#include "libClient/attalSound.h"

class GenericFightUnit;
class GenericMapCreature;


#define NB_TRANSITION 16

/**              ------------------------------
 *                          ImageTheme
 **              ------------------------------ */

class CreaturePixmap
{
public:
	/** Constrictor */
	//obsolete, remove it?
	//CreaturePixmap( Q3PtrList<QPixmap> pix, Q3PtrList<QPoint> hotspots );
	
	/** Constructor */
	CreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots );

	CreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots , const Q3ValueList<QPixmap> & newpix);
	
	/** destructor */
	virtual ~CreaturePixmap();
	
	Q3CanvasPixmapArray * operator[] ( uint i );

private:

	Q3CanvasPixmapArray * _pixmaps[2];
};

class MapCreaturePixmap
{
public:
	/** Constructor */
	MapCreaturePixmap( Q3PtrList<QPixmap> pix, Q3PtrList<QPoint> hotspots );
	
	/** Constructor */
	MapCreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots );
	
	/** Destructor */
	virtual ~MapCreaturePixmap();
	
	Q3CanvasPixmapArray * operator[] ( uint i );

private:

	Q3CanvasPixmapArray * _pixmaps[2];
};

/** comment for the class */
class ImageTheme
{
public:
	/** Constructor */
	ImageTheme();

	/** Destructor */
	~ImageTheme();

	/** Initializes the images of the theme */
	bool init();

	/** Saves the images of the theme */
	void save();

	/** Clears the images of the theme */
	void clear();

	QString getPhotoCreature( GenericFightUnit * );

	/** \return Returns the pixmap of inside the base 'num' */
	QPixmap * getInsideBase( uint num );

	/** \return Returns the icon of the artefcat 'num' */
	QPixmap * getArtefactIcon( uint num );

	/** \return Returns the flag of the team 'num' */
	QPixmap * getFlag( uint num );

	QPixmap * getResourceIcon( uint num );

	QPixmap * getResourceSmallIcom( uint num );

	Q3CanvasPixmapArray ** cells;
	Q3CanvasPixmapArray * pathCells;
	Q3CanvasPixmapArray * lords;
	Q3CanvasPixmapArray ** buildings;
	Q3CanvasPixmapArray * bases;
	Q3CanvasPixmapArray ** insideBuildings;
	Q3CanvasPixmapArray * skills;
	//QCanvasPixmapArray ** creatures[2];
	CreaturePixmap ** creatures;
	Q3CanvasPixmapArray * deadCreature;
	Q3CanvasPixmapArray ** transition;
	Q3CanvasPixmapArray ** decoration;
	Q3CanvasPixmapArray * artefacts;
	Q3CanvasPixmapArray ** bonus;
	Q3CanvasPixmapArray * chest;
	MapCreaturePixmap *** mapCreatures;
	Q3CanvasPixmapArray ** events;

	/** Return pixmap of a lord */
	QPixmap * getLordPixmap( uint num );

	/** Return small pixmap of a lord */
	QPixmap * getLordSmallPixmap( uint num );

	/** Return small pixmap of a base */
	QPixmap * getBaseSmallPixmap( uint num );

	QPixmap * getMapCreature( uint race, uint level, bool rightLooking = false );

	QPixmap * getMapCreature( GenericMapCreature * creature, bool rightLooking = false );
	
	Q3CanvasPixmapArray * getMapFlag( uint type, uint teamId );

	CreaturePixmap * getCreature ( uint race, uint level );
	
	QPixmap gridCell(QPixmap pixmap, int r, int g, int b);

	void playMusicMap();

	void playMusicBase( uint race );

	void playMusicFight();
	
	void playSound( AttalSound::SoundType snd );

	void endMusic();

	bool isLoaded() {
		return _isLoaded;
	}

	QPixmap * getOkPixmap();

	QPixmap * getCancelPixmap();

private:
	bool initTeams();
	bool initSkills();
	bool initCells();
	bool initCreatures();
	bool initLords();
	bool initBases();
	bool initBuildings();
	bool initArtefacts();
	bool initResources();
	bool initBonus();
	bool initChest();
	bool initTransitions();
	bool initDecorations();
	bool initEvents();
	bool initMapCreatures();
	bool initSound();

	QPixmap ** _insideBase;
	QPixmap ** _artefactIcon;
	QPixmap ** _resourceIcon;
	QPixmap ** _resourceSmallIcon;
	QPixmap ** _flags;

	QPixmap ** _lordPixmap;
	QPixmap ** _lordSmallPixmap;
	QPixmap ** _baseSmallPixmap;

	QPixmap * _okPixmap;
	QPixmap * _cancelPixmap;
	
	Q3CanvasPixmapArray *** _mapFlags;

	AttalSound * _sound;

	bool _isLoaded;
};

#endif // IMAGETHEME_H
