/****************************************************************
**
** Attal : Lords of Doom
**
** map.cpp
** Manage the global view
**
** Version : $Id: map.cpp,v 1.11 2005/12/26 16:34:15 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier - Sardi Carlo
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "map.h"

 
// generic include files
#include <stdlib.h>
// include files for QT
#include <Q3Canvas>
#include <QFile>
#include <QString>
#include <QTextStream>
// application specific includes
#include "libCommon/log.h"
#include "libCommon/pathFinder.h"

#include "libClient/cell.h"
//#include "libClient/lord.h"

//
// ----- Map -----
//

Map::Map( QObject * parent , const char * name )
  : GraphicalMap( parent , name ),
    GenericMap()
{
	_isGrid = false;
}

Map::~Map()
{
	if(_path) {
		delete _path;
		_path = 0;
	}

	if( _theCells != 0 ) {
		for( uint i = 0 ; i < _height ; i++ ) {
			for( uint j = 0; j < _width; j++ ) {
				delete (Cell*)_theCells[i][j];
			}
			delete [] _theCells[i];
		}
		delete [] _theCells;	
	}
	_theCells = 0;
}

void Map::clear()
{
	if( _theCells != 0 ) {
		for( uint i = 0 ; i < _height ; i++ ) {
			for( uint j = 0; j < _width; j++ ) {
				delete (Cell*)_theCells[i][j];
			}
			delete [] _theCells[i];
		}
		delete [] _theCells;	
	}
	_theCells = 0;
	
	_height = 0;
	_width = 0;
	if(_path) {
		_path->clear();
	}
	_isGrid = false;
}

void Map::newMap( int h, int w )
{
	clear();
	_height = h;
	_width = w;
	_theCells = new GenericCell **[_height];
	uint i;

	for( i = 0; i < _height; i++ ) {
		_theCells[i] = new GenericCell *[_width];
	}
	for( i = 0; i < _height; i++ ) {
		for( uint j = 0; j < _width; j++ ) {
			Cell * tempo;
			tempo = new Cell( i, j, this );
			tempo->show();
			// XXX: bof
			tempo->setType( 0 );
			_theCells[i][j] = (GenericCell *)tempo;
		}
	}
	_path->newMap( _height, _width, (GenericMap*)this );
	autoSize();
}

void Map::newUnknownMap( int h, int w )
{
	clear();
	_height = h;
	_width = w;
	_theCells = new GenericCell **[_height];
	uint i;

	for( i = 0; i < _height; i++ ) {
		_theCells[i] = new GenericCell *[_width];
	}
	for( i = 0; i < _height; i++ ) {
		for( uint j = 0; j < _width; j++ ) {
			Cell * tempo;
			tempo = new Cell( i, j, this );
			tempo->show();
			tempo->setType( 0 );
			_theCells[i][j] = (GenericCell *)tempo;
		}
	}

	_path->newMap( _height, _width, (GenericMap*)this );
	autoSize();
}

void Map::changeCell( int i,
		      int j,
		      int typ,
		      int transition,
		      int typtra,
		      uint decorationGroup, 
		      uint decorationItem )
{
	GenericMap::changeCell( i, j, typ, transition, typtra, decorationGroup, decorationItem );

	if( _theCells[i][j]->getType() == 0 ) {
		/*((Cell*)_theCells[i][j])->setType( typ );
		((Cell*)_theCells[i][j])->setTransition( transition );
		((Cell*)_theCells[i][j])->setTransitionCellType( typtra );
		((Cell*)_theCells[i][j])->setDecoration( decoration );*/
		((Cell*)_theCells[i][j])->show();
	}/* else {
		logEE( "Cell type should be unknown" );
	}*/

}

bool Map::load( QTextStream * ts, int width, int heigth )
{
	_width = width;
	_height = heigth;
	uint i, j;
	
	_theCells = (GenericCell ***) ( new Cell **[_height] );

	for( i = 0; i < _height; i++ ) {
		_theCells[i] = (GenericCell**) ( new Cell *[_width] );
	}
	int val;
	uint item;
	
	// Loading base cell
	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			if( ! ts->atEnd() ) {
				Cell * tempo;
				tempo = new Cell( i, j, this );
				tempo->show();
				*ts >> val;
				tempo->setType( val );
				_theCells[i][j] = (GenericCell*)tempo;
			} else {
				logEE("Stream too short");
				return false;
			}
		}
	}

	// Loading diversification cell
	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			if( ! ts->atEnd() ) {
				*ts >> val;
				_theCells[i][j]->setDiversification( val );
			} else {
				logEE("Stream too short");
				return false;
			}
		}
	}
	
	// Loading transition type
	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			if( ! ts->atEnd() ) {
				*ts >> val;
				_theCells[i][j]->setTransition( val );
			} else {
				logEE("Stream too short");
				return false;
			}
		}
	}	
	
	// Loading transition cell
	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			if( ! ts->atEnd() ) {
				*ts >> val;
				_theCells[i][j]->setTransitionCellType( val );
			} else {
				logEE("Stream too short");
				return false;
			}
		}
	}	
	
	// Loading decoration of the ground
	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			if( ! ts->atEnd() ) {
				*ts >> val;
				if( val ) {
					*ts >> item;	
					_theCells[i][j]->setDecoration( val, item );
				}
			} else {
				logEE("Stream too short");
				return false;
			}
		}
	}	
	
	
	_path = new PathFinder( _width, _height, this );
	autoSize();
	return true;	
}

void Map::activateGrid()
{
	uint i,j;

	for( i = 0; i < _height; i++ ) {
		for( j = 0; j < _width; j++ ) {
			((Cell *) _theCells[i][j])->activateGrid(!_isGrid);
		}
	}
	_isGrid = !_isGrid;

}
