/****************************************************************
**
** Attal : Lords of Doom
**
** mapView.cpp
** subclass of QCanvasSprite that handles mouse event ...
**
** Version : $Id: mapView.cpp,v 1.6 2005/12/26 18:27:43 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier
**
** Date : 08/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "mapView.h"

 
// generic include files
// include files for QT
// application specific includes
#include "libCommon/log.h"
#include "libClient/cell.h"
//Added by qt3to4:
#include <QMouseEvent>
//#include "libClient/lord.h"


/** subclass of QCanvasSprite that handles mouse event ... */
MapView::MapView( Map * map, QWidget * parent, const char * name, Qt::WFlags f )
	: Q3CanvasView( map, parent, name, f ) 
{
	viewport()->setMouseTracking( true ) ;
	_press = false;
}


/** handles mouse event */
void MapView::contentsMouseMoveEvent( QMouseEvent * event )
{
	Q3CanvasItemList list = canvas()->collisions( event->pos() );
	
	uint nbItems = (uint) list.count();
	for( unsigned int i = 0; i < nbItems; i++ ) {	
		if( list[i]->rtti() == Cell::RTTI ) {
			Cell * cell = (Cell *) list[i];
			if( cell->hit( event->pos() ) ) { 
				//emit sig_mouseMoved( (Cell*) (_map->at( cell->getRow(), cell->getCol() ) ) );
				emit sig_mouseMoved( cell->getParent() );
			}
		}
	}
}

void MapView::contentsMousePressEvent( QMouseEvent * event )
{
	Q3CanvasItemList list = canvas()->collisions( event->pos() );
	
	uint nbItems = (uint) list.count();
	for( unsigned int i = 0; i < nbItems; i++ ) {	
		if( list[i]->rtti() == Cell::RTTI ) {
			Cell * cell = (Cell *) list[i];
			if( ( cell->hit( event->pos() ) ) && ( cell->getParent() == cell ) ) {
				if( event->button() == Qt::RightButton ) {
					emit sig_mouseRightPressed( cell );
				} else {
					emit sig_mouseLeftPressed( cell );
				}
			}
		}
	}
	_press = true;
}

void MapView::contentsMouseReleaseEvent( QMouseEvent * )
{
	_press = false;
	emit sig_mouseReleased();
}

void MapView::contentsMouseDoubleClickEvent( QMouseEvent * event )
{
	contentsMousePressEvent( event );
	contentsMouseReleaseEvent( event );
}

void MapView::goToPosition(Cell * cell)
{
	if(cell){
		this->center((int) cell->x(),(int) cell->y());
	}
}

void MapView::resizeEvent( QResizeEvent * event )
{
	Q3CanvasView::resizeEvent( event );
	emit sig_viewportChanged( contentsX(), contentsY(), visibleWidth(), visibleHeight() );
}
