/****************************************************************
**
** Attal : Lords of Doom
**
** ressourceWin.cpp
** show ressources of the player (gold, ...)
**
** Version : $Id: ressourceWin.cpp,v 1.7 2006/05/21 14:47:56 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo Sardi
**
** Date : 06/09/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "ressourceWin.h"

 
// generic include files
// include files for QT
#include <QGridLayout>
#include <QLabel>
#include <QLayout>
#include <QString>

// application specific includes
#include "libClient/gui.h"
#include "libCommon/dataTheme.h"
#include "libClient/imageTheme.h"

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;

/** add comments here */
	RessourceWin::RessourceWin( QWidget * parent, const char * name , WinResType type)
:QWidget( parent, name )
{
	_player = 0;
	int k = 1;

	QGridLayout * lay = new QGridLayout( this );

	lay->setRowStretch(0,1);
	for( int i = 0; i < DataTheme.resources.count(); i++ ) {
		_labIcon[i] = new QLabel( this );
		_labRessource[i] = new QLabel( this );
		if(type == RS_GRID) {
			if((i%2) == 0){
				k=i/2+1;
				lay->addWidget( _labIcon[i] , k, 0);
				lay->addWidget( _labRessource[i] , k, 1);
			} else {
				lay->addWidget( _labIcon[i] , k, 2);
				lay->addWidget( _labRessource[i] , k, 3);
			}
		} else if (type == RS_VERT) {
			lay->addWidget( _labIcon[i] , i, 0);
			lay->addWidget( _labRessource[i] , i, 1);
		}
	}

	lay->activate();
}

void RessourceWin::setPlayer( GenericPlayer * p )
{
	_player = p;
	reinit();
}

void RessourceWin::reinit()
{
	if( _player != 0 ) {
		QString s;
		
		for( int i = 0; i < DataTheme.resources.count(); i++ ) {
			//s.sprintf( "%s : %d", DataTheme.resources.getRessource( i ).toLatin1(), _player->getResource( i ) );
			s.sprintf( " %d",  _player->getResource( i ) );
			QPixmap pix = ImageTheme.getResourceSmallIcom( i )->copy(ImageTheme.getResourceSmallIcom( i )->rect());
			_labIcon[i]->setPixmap( pix  );
			_labRessource[i]->setText( s );
			FIXEDSIZE( _labRessource[i] );
		}
	}
}

