/****************************************************************
**
** Attal : Lords of Doom
**
** fightUnit.h
** Manage Units
**
** Version : $Id: fightUnit.h,v 1.17 2006/01/16 21:55:41 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 28/12/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef FIGHTUNIT_H
#define FIGHTUNIT_H


// generic include files
// include files for QT
#include <Q3Canvas>
#include <q3ptrqueue.h>
#include <QImage>
// application specific include files
#include "libCommon/attalSocket.h"
#include "libCommon/unit.h"
#include "libCommon/creature.h"

class FightCell;
class GraphicalFightCell;

/*              ------------------------------
 *                         FightUnit
 *              ------------------------------ */


/** comment for the class */
class FightUnit : public Q3CanvasSprite, public GenericFightUnit
{

public:
	/** Constructor */
	FightUnit( Q3Canvas * canvas );

	FightUnit( Q3Canvas * canvas, GenericFightUnit * unit, bool mirror );

	virtual ~FightUnit();

	/** Hit unit by 'nb' hitpoints */
	int hit( int nb );

	/** unit go to cell */
	void goTo( FightCell * cell );

	void setPosition( FightCell * cell );

	virtual void draw( QPainter& painter );

	/** Advance animation */
	void advance( int stage );

	/** Highlight (or not) the unit if active (or not) */
	void setActive( bool state );
	
	void setSocket( AttalSocket * sock ) {
		_socket = sock;
	}

	QRgb colorH( QRgb v );

	/** Draw destroyed unit (or not) if destroyed (or not) */
	void setDestroyed( bool state );

	void animate (CreatureAnimationType current);
	
	bool isAnimated () { return getCreature()->isAnimated(); }
	
	bool isMoving () { return _isMoving; }
	
	bool haveToStop () { return _haveToStop; }
	
	void setHaveToStop (bool stop) {  _haveToStop = stop; }
	
	CreatureAnimationType getTypeAnimation() { return _currentAnimationType; }
    	
	bool hit( const QPoint & ) const;

	/** Return RTTI */
	int rtti() const { return RTTI; };

	static const int RTTI;

protected:
	void initCreatureForMove( GraphicalFightCell * cell );

	Q3CanvasPixmap* imageAdvanced() const;
	AttalSocket * _socket;
	uint _cpt;
	FightCell * _moving;
	Q3PtrQueue<FightCell> _fifo;
	bool _destroyed, _isMoving, _haveToStop;

	CreatureAnimationType _currentAnimationType;
};

#endif // FIGHTUNIT_H
