/****************************************************************
**
** Attal : Lords of Doom
**
** sectionRessource.cpp
** section specifying ressources
**
** Version : $Id: sectionRessource.cpp,v 1.9 2006/02/28 14:20:01 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 03/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "sectionRessource.h"
 
// generic include files
// include files for QT
#include <QInputDialog>
#include <QLayout>
#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>

// application specific include files
#include "libClient/gui.h"
#include "libCommon/dataTheme.h"
#include "libCommon/log.h"

extern DataTheme DataTheme;
extern QString IMAGE_PATH;

SectionRessource::SectionRessource( QWidget * parent, const char * name )
	: GenericSection( parent, name )
{
	_num = 0;
	setTitle( tr( "Ressource" ) );

	QVBoxLayout * layout = new QVBoxLayout( _mainWidget );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );

	_name = new AskString( tr( "Name: " ), _mainWidget );
	layout->addWidget( _name );

	_icon = new AskPixmap( true, "", tr( "Icon: " ), _mainWidget );
	layout->addWidget( _icon );

	_smallIcon = new AskPixmap( true, "", tr( "Small icon: " ), _mainWidget );
	layout->addWidget( _smallIcon );

	layout->addStretch( 1 );
	layout->activate();

	init();
}

void SectionRessource::clear()
{
	_name->setValue( "" );
	_icon->setValue( "" );
	_smallIcon->setValue( "" );
}

void SectionRessource::save()
{
	if( DataTheme.resources.count() > _num ) {
		DataTheme.resources.update( _num, _name->getValue() );
		_icon->save();
		_smallIcon->save();
	}
}

void SectionRessource::init()
{
	if( DataTheme.resources.count() > _num ) {
		QString es = DataTheme.resources.getRessource( _num );
		_name->setValue( es );
		QString dest;
		dest.sprintf( "%sressources/ress_%02d.png", IMAGE_PATH.toLatin1().constData(), _num + 1 );
		_icon->setDestination( dest );
		dest.sprintf( "%sressources/smallResource_%02d.png", IMAGE_PATH.toLatin1().constData(), _num + 1 );
		_smallIcon->setDestination( dest );

	}
}

void SectionRessource::selectFirst()
{
	save();
	_num = 0;
	init();
}

void SectionRessource::selectPrevious()
{
	save();
	_num = std::max( 0, _num - 1 );
	init();
}

void SectionRessource::selectNext()
{
	save();
	_num = std::min( DataTheme.resources.count() - 1, _num + 1 );
	init();
}

void SectionRessource::selectLast()
{
	save();
	_num = DataTheme.resources.count() - 1;
	init();
}

void SectionRessource::selectNew()
{
	save();
	QString ressource;
	_num = DataTheme.resources.count();
	DataTheme.resources.append( ressource );
	clear();
}

void SectionRessource::selectDel()
{
	if( DataTheme.resources.count() > 0 ) {
		delete DataTheme.resources.takeAt( _num );
		_num = std::min( _num, DataTheme.resources.count() - 1 );
		init();
	}
}




