/****************************************************************
**
** Attal : Lords of Doom
**
** attalSound.h
** Manage sound and music (or not) for attal client
**
** Version : $Id: attalSound.h,v 1.4 2003/10/05 17:37:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 22/09/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef ATTALSOUND_H
#define ATTALSOUND_H

#ifdef WITH_SOUND
// generic include files
// include files for QT
// application specific include files


#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

/*              ------------------------------
 *                         AttalSound
 *              ------------------------------ */

class AttalSound
{

public:
	/** Constructor */
	AttalSound();

	~AttalSound();

	void init();

	void clear();

	void enableSound();

	void disableSound();

	bool isSoundEnabled();

	void playMusicMap();

	void playMusicBase( unsigned int race );

	void playMusicFight();

protected:
	Mix_Music * _music;
	bool _enabled;

};

#else // No Sound!!

class AttalSound
{

public:
	/** Constructor */
	AttalSound() {}

	~AttalSound() {}

	void init() {}

	void clear() {}

	void enableSound() {}

	void disableSound() {}

	bool isSoundEnabled() { return false; }

	void playMusicMap() {}

	void playMusicBase( unsigned int ) {}

	void playMusicFight() {}
};

#endif

#endif // ATTALSOUND_H
