/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalFightUnit.cpp
** draw a unit on the fight map
**
** Version : $Id: graphicalFightUnit.cpp,v 1.9 2004/04/06 20:39:17 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalFightUnit.h"


// generic include files
#include <math.h>
// include files for QT
#include <qrect.h>
#include <qbrush.h>
// application specific include
#include "libCommon/attalSettings.h"
#include "libCommon/creature.h"
#include "libCommon/dataTheme.h"
#include "libCommon/log.h"

#include "libFight/fightUnit.h"

#include "libClient/imageTheme.h"

#include "conf.h"

extern DataTheme DataTheme;

/** rtti number for GraphicalFightUnit class */
const int GraphicalFightUnit::RTTI = 2234;

extern ImageTheme ImageTheme;

/** add comments here */
GraphicalFightUnit::GraphicalFightUnit( QCanvas * canvas )
	: QCanvasSprite( (*ImageTheme.creatures[0])[0], canvas )
{
	_cpt = 0;
	_fifo.setAutoDelete( false );
 	collisions( true );
 	setFrame( 0 );
	setZ( CAN_LORD );
	show();

	/*QBrush brush( yellow );
	_numBox = new QCanvasRectangle( canvas );
	_numBox->setBrush( brush );
	_numBox->collisions( true );
	_numBox->setZ( CAN_ARROW );
	_numBox->setSize( 50, 25 );
	_numBox->show();*/
}

/** set the hero on the cell */
void GraphicalFightUnit::setPosition( GraphicalFightCell *cell )
{
	FightUnit* unit = ( FightUnit* ) this; /// XXX: hum !!
	Creature* creature = unit->getCreature ();
	QRect rect = cell->boundingRect();

	//move( rect.x() + creature->getXOffset (), rect.y() + creature->getYOffset () );

        move( rect.x() + creature->getXOffset() - boundingRect().width() + 2 * rect.width(), rect.y() + ( rect.height() ) - boundingRect().height() + creature->getYOffset() );

        canvas()->update();
}

void GraphicalFightUnit::initCreatureForMove( GraphicalFightCell *cell )
{
	FightUnit* unit = ( FightUnit* ) this; /// XXX: hum !!
	Creature* creature = unit->getCreature ();
	uint race = creature->getRace ();
	uint level = creature->getLevel ();
	bool bLookingToRight = unit->isLookingToRight ();
	QCanvasPixmapArray frameArray;

	CreaturePixmap* basePixs = ImageTheme.getCreature ( race , level );
	setSequence ( (*basePixs)[ bLookingToRight?0:1 ] );

	setFrame ( creature->getFirstMovingFrame () );

	QRect endRect = cell->boundingRect ();

	QRect startRect = endRect;

	if( _moving ) {
		startRect = _moving->boundingRect();
		double dx = double ( endRect.x() - startRect.x() ) / 10.0;
		double dy = double ( endRect.y() - startRect.y() ) / 10.0;
		setVelocity( dx, dy );
	} else {
		//setX( endRect.x () );
		//setY( endRect.y () );
		_cpt = 10;
		setVelocity( 0, 0 );
	}


}

void GraphicalFightUnit::goTo( GraphicalFightCell *cell )
{
	FightSettings fsettings = AttalSettings::getFightSettings ();
	FightUnit* unit = ( FightUnit* ) this; /// XXX: hum !!
	Creature* creature = unit->getCreature ();
	uint race = creature->getRace ();
	uint level = creature->getLevel ();

	if( fsettings.IsAnimationEnabled ) {
		if( DataTheme.creatures.at( race , level )->isAnimated() ) {
			canvas()->setAdvancePeriod ( 100 );

			if( creature->getNumFrames() > 0 ) {

				_cpt = 0;
				setAnimated ( true );
				if( _fifo.count() == 0 ) {
					_moving = (FightCell*)unit->getCell();

				}
				_fifo.enqueue( cell );
			}
		} else {
			setPosition( cell );
		}
	} else {
		setPosition( cell );
	}

}

void GraphicalFightUnit::advance( int stage )
{
	FightUnit* unit = ( FightUnit* ) this; /// XXX: hum !!
	Creature* creature = unit->getCreature ();
	uint race = creature->getRace ();
	uint level = creature->getLevel ();
	if( DataTheme.creatures.at( race , level )->isAnimated() ) {
		if( stage == 1 ) {
			setFrame ( frame() + 1 );

			FightUnit* unit = ( FightUnit* ) this;
			Creature* creature = unit->getCreature ();

			if( frame () >= creature->getLastMovingFrame () ) {
				setFrame ( creature->getFirstMovingFrame() );
			}
			_cpt++;
			if( _cpt > 10 ) {
				_cpt = 0;
				if( _fifo.count() > 0 ) {
					GraphicalFightCell * temp = _fifo.dequeue();
					initCreatureForMove( temp );
					_moving = temp;
				} else {
					setFrame( creature->getFirstMovingFrame() );
					if( _moving ) {
						setPosition( _moving );
					}
					setVelocity( 0, 0 );
					_moving = 0;
					setAnimated( false );
				}
			}
		} else {

		}

		QCanvasSprite::advance ( stage );
	} else {
		logDD( "advance not animated %d %d", race, level );
	}
}

QCanvasPixmap* GraphicalFightUnit::imageAdvanced() const
{
	return image();
}

void GraphicalFightUnit::setDestroyed( bool state )
{
	if( state ) {
		setSequence( ImageTheme.deadCreature );
		setFrame( 0 );
	}
}


/*! Destroys the object and frees any allocated resources.

*/

GraphicalFightUnit::~GraphicalFightUnit()
{
	logDD("delete GraphicalFightUnit");
}
