/****************************************************************
**
** Attal : Lords of Doom
**
** sectionSelector.cpp
** main widget, allows modif in diff theme sections
**
** Version : $Id: sectionSelector.cpp,v 1.4 2004/05/08 22:07:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "sectionSelector.h"

// generic include files
// include files for QT
#include <qscrollview.h>
// application specific include files
#include "sectionArtefact.h"
#include "sectionBuilding.h"
#include "sectionBase.h"
#include "sectionCreature.h"
#include "sectionDecoration.h"
#include "sectionExperience.h"
#include "sectionGeneral.h"
#include "sectionGround.h"
#include "sectionLord.h"
#include "sectionLordCategory.h"
#include "sectionMachine.h"
#include "sectionRessource.h"
#include "sectionTeam.h"

class AttalScrollView : public QScrollView
{
public:
	/** Constructor */
	AttalScrollView( QWidget * parent = 0, const char * name = 0 );

	void setSection( Section * section );

	Section * getSection() {
		return _section;
	}

protected:
	Section * _section;
};

AttalScrollView::AttalScrollView( QWidget * parent, const char * name )
: QScrollView( parent, name )
{
	_section = 0;
}

void AttalScrollView::setSection( Section * section )
{
	_section = section;
	addChild( section );
}

//
// ----- SectionSelector
//

SectionSelector::SectionSelector( QWidget * parent, const char * name )
	: QTabWidget( parent, name )
{
	AttalScrollView * viewGeneral = new AttalScrollView( this, "scrollview general" );
	SectionGeneral * general = new SectionGeneral( viewGeneral->viewport(), "general" );
	viewGeneral->setSection( general );
	addTab( viewGeneral, tr( "General" ) );

	AttalScrollView * viewArtefact = new AttalScrollView( this, "scrollview artefacts" );
	SectionArtefact * artefact = new SectionArtefact( viewArtefact->viewport(), "artefact" );
	viewArtefact->setSection( artefact );
	addTab( viewArtefact, tr( "Artefacts" ) );

	AttalScrollView * viewTeam = new AttalScrollView( this, "scrollview teams" );
	SectionTeam * team = new SectionTeam( viewTeam, "team" );
	viewTeam->setSection( team );
	addTab( viewTeam, tr( "Teams" ) );

	AttalScrollView * viewBase = new AttalScrollView( this, "scrollview bases" );
	_base = new SectionBase( viewBase->viewport(), "base" );
	viewBase->setSection( _base );
	addTab( viewBase, tr( "Bases" ) );

	AttalScrollView * viewBuilding = new AttalScrollView( this, "scrollview buildings" );
	SectionBuilding * building = new SectionBuilding( viewBuilding->viewport(), "building" );
	viewBuilding->setSection( building );
	addTab( viewBuilding, tr( "Buildings" ) );

	AttalScrollView * viewCreature = new AttalScrollView( this, "scrollview creatures" );
	SectionCreature * creature = new SectionCreature( viewCreature->viewport(), "creatures" );
	viewCreature->setSection( creature );
	addTab( viewCreature, tr( "Creatures" ) );

	AttalScrollView * viewDecoration = new AttalScrollView( this, "scrollview decorations" );
	SectionDecoration * decoration = new SectionDecoration( viewDecoration->viewport(), "decoration" );
	viewDecoration->setSection( decoration );
	addTab( viewDecoration, tr( "Decorations" ) );

	AttalScrollView * viewGround = new AttalScrollView( this, "scrollview grounds" );
	SectionGround * ground = new SectionGround( viewGround->viewport(), "ground" );
	viewGround->setSection( ground );
	addTab( viewGround, tr( "Grounds" ) );

	AttalScrollView * viewLordCategory = new AttalScrollView( this, "scrollview lord categories" );
	_lordCategories = new SectionLordCategory( viewLordCategory->viewport(), "lord categories" );
	viewLordCategory->setSection( _lordCategories );
	addTab( viewLordCategory, tr( "Lord Categories" ) );

	AttalScrollView * viewLord = new AttalScrollView( this, "scrollview lords" );
	_lord = new SectionLord( viewLord->viewport(), "lords" );
	viewLord->setSection( _lord );
	addTab( viewLord, tr( "Lords" ) );

	AttalScrollView * viewExperience = new AttalScrollView( this, "scrollview levels" );
	SectionExperience * experience = new SectionExperience( viewExperience->viewport(), "experience" );
	viewExperience->setSection( experience );
	addTab( viewExperience, tr( "Levels" ) );

	AttalScrollView * viewResource = new AttalScrollView( this, "scrollview resources" );
	SectionRessource * resource = new SectionRessource( viewResource->viewport(), "resources" );
	viewResource->setSection( resource );
	addTab( viewResource, tr( "Resources" ) );

	AttalScrollView * viewMachine = new AttalScrollView( this, "scrollview machine" );
	SectionMachine * machine = new SectionMachine( viewMachine->viewport(), "machines" );
	viewMachine->setSection( machine );
	addTab( viewMachine, tr( "War Machines" ) );

	connect( this, SIGNAL( currentChanged( QWidget * ) ), SLOT( slot_changed( QWidget * ) ) );
	connect( creature, SIGNAL( sig_changed() ), SLOT( slot_creaturesChanged() ) );
	connect( _lordCategories, SIGNAL( sig_changed() ), SLOT( slot_lordCategoryChanged() ) );
	connect( general, SIGNAL( sig_changed() ), SLOT( slot_generalChanged() ) );

	_current = general;
}

void SectionSelector::save()
{
	_current->save();
}

void SectionSelector::slot_changed( QWidget * widget )
{
	_current->save();
	_current = ((AttalScrollView *)widget)->getSection();
}

void SectionSelector::slot_creaturesChanged()
{
	_lordCategories->updateData();
	_lord->updateData();
}

void SectionSelector::slot_generalChanged()
{
	_base->updateData();
}

void SectionSelector::slot_lordCategoryChanged()
{
	_lord->updateData();
}
