/****************************************************************
**
** Attal : Lords of Doom
**
** displayLord.h
** show infos about Lord
**
** Version : $Id: displayLord.h,v 1.14 2005/12/12 10:36:33 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 24/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef DISPLAYLORD_H
#define DISPLAYLORD_H
 
 
// generic include files
// include files for QT
#include <QDialog>
#include <QFrame>
#include <QLabel>
#include <QList>
#include <QPushButton>
#include <QVector>

// application specific includes
#include "libCommon/define.h"
#include "libCommon/genericLord.h"

#include "libClient/displayArtefacts.h"
#include "libClient/widget.h"

class QSignalMapper;
class QTabWidget;

class AttalButton;
class AttalSocket;
class DisplayUnit;
class DisplayGeneral;
class DisplayListPanel;
class DisplayListLord;
class DisplayLordTabGeneral;
class DisplayLordTabUnits;
class DisplayLordTabTechnics;
class InfoWidget;
class Lord;
class Player;
class UnitExchange;



/*              ------------------------------
 *                         DisplayLord
 *              ------------------------------ */

 

/** Display info about lord */
class DisplayLord : public QDialog
{
	Q_OBJECT
public:
	/** Construtor */
	DisplayLord( Player * player, QWidget * parent = 0, char * name = 0 );

	/** Destructor */
	~DisplayLord();

	/** Reinit and show dialog */
	void show();

	/** Reinit info displayed */
	void reinit();

	/** Update info displayed */
	void reupdate();

	void initSocket( AttalSocket * socket );

public slots:
	/** Slot if lord clicked */
	void slot_lord( int num );

private:
	InfoLabelSkill * _infoSkills;
	Player * _player;
	DisplayUnit * _dispUnit;
	DisplayGeneral * _dispGeneral;
	DisplayArtefacts * _dispArtefact;
	DisplayListPanel * _dispList;
	AttalSocket * _socket;
};

/** General information about lord */
class DisplayGeneral : public QFrame
{
public:
	/** Construtor */
	DisplayGeneral( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();

	/** Update info displayed */
	void reupdate() { reinit(); }

private:
	Player * _player;
	QLabel * _title, * _labAttack, * _labDefense, * _labPower, * _labKnowledge;
	InfoLabel * _specialty, * _experience, * _spellPoints;
	Icon * _photo;
};


/** Display units of the lord */
class DisplayUnit : public QFrame
{
	Q_OBJECT
public:
	/** Construtor */
	DisplayUnit( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();
	
	/** Update info displayed */
	void reupdate() { reinit(); }

	/** Quit exchange mode */
	void quitExchange();

	/** Select unit 'num' */
	void selectUnit( int num );

	/** Deselect unit */
	void deselectUnit();
	
	void initSocket( AttalSocket * socket ) {
		_socket = socket;
	}

public slots:
	/** Slot for 'Exchange' button */
	void slot_exchange();

	/** Slot for units clicked */
	void slot_unitClicked( int num );

	void slot_technic();

private:
	void exchangeUnit( int num );

	Player * _player;
	Icon * _buttonUnit[ MAX_UNIT ];
	QLabel * _numUnit[ MAX_UNIT ];
	AttalButton * _dispo[ 4 ], * _butExchange;
	UnitExchange * _unitExchange;
	AttalSocket * _socket;
	int _unit;
	bool _exch;
};

/** Panel for displaying list of other lords and 'quit' button */
class DisplayListPanel : public QFrame
{
	Q_OBJECT
public:
	/** Construtor */
	DisplayListPanel( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();

	/** Update info displayed */
	void reupdate();

signals:
	/** Signal for quitting */
	void sig_quit();

	/** Signal for changing lord */
	void sig_lord( int );

private:
	DisplayListLord * _listLord;
	Player * _player;

};

/** Display list of lords */
class DisplayListLord : public QWidget
{
	Q_OBJECT
public:
	/** Construtor */
	DisplayListLord( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Destructor */
	virtual ~DisplayListLord();

	/** Reinit info displayed */
	void reinit();

	/** Update info displayed */
	void reupdate();
signals:
	/** Signal for changing lord */
	void sig_lord( int );

private:
	Player * _player;
	QList<AttalButton *> _listBut;
	QSignalMapper * _sigmap;
};


class DisplayLordTab : public QDialog
{
	Q_OBJECT
public:
	/** Construtor */
	DisplayLordTab( Player * player, AttalSocket * socket, QWidget * parent = 0, char * name = 0 );

	/** Destructor 
	virtual ~DisplayLordTab(); */

	/** Reinit and show dialog */
	virtual void exec();

	/** Reinit info displayed */
	void reinit();

	/** Reupdate info displayed */
	void reupdate();

public slots:
	/** Slot if lord clicked */
	void slot_lord( int num );

private:
	Player * _player;
	AttalSocket * _socket;
	DisplayListPanel * _listPanel;
	QTabWidget * _tabs;
	DisplayLordTabGeneral * _tabGeneral;
	DisplayLordTabUnits * _tabUnits;
	DisplayLordTabArtefacts * _tabArtefacts;
	DisplayLordTabTechnics * _tabTechnics;
	Icon * _photo;
	QLabel * _title;
};

class DisplayLordTabGeneral : public QWidget
{
public:
	/** Constructor */
	DisplayLordTabGeneral( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();

protected:
	QString textCharac( GenericLord * lord, LordCharac charac );

	Player * _player;
	InfoWidget * _specialty, * _experience;
	InfoWidget * _luck, * _morale;
	InfoWidget * _attack, * _defense;
	InfoWidget * _charisma, * _knowledge;
	InfoWidget * _power, * _mana;
	InfoWidget * _move, * _vision;
};

class DisplayLordTabUnits : public QWidget
{
	Q_OBJECT
public:
	/** Constructor */
	DisplayLordTabUnits( Player * player, AttalSocket * socket, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();

public slots:
	/** Slot for 'Exchange' button */
	void slot_exchange();

	/** Slot for units clicked */
	void slot_unitClicked( int num );

protected:
	void quitExchange();

	void selectUnit( int num );

	void deselectUnit();

	void exchangeUnit( int num );

	Player * _player;
	AttalSocket * _socket;
	QList<InfoWidget *> _units;
	AttalButton * _butExchange;
	UnitExchange * _unitExchange;
	int _select;
	bool _exchange;
};

class DisplayLordTabTechnics : public QWidget
{
	Q_OBJECT
public:
	/** Constructor */
	DisplayLordTabTechnics( Player * player, QWidget * parent = 0, const char * name = 0 );

	/** Reinit info displayed */
	void reinit();

protected:
	Player * _player;
};

class InfoWidget : public QFrame
{
	Q_OBJECT
public:
	/** Constructor */
	InfoWidget( QWidget * parent = 0, const char * name = 0 );

	void clear();

	void setIcon( const QPixmap & pixmap );

	void setText( const QString & text );

	void setPopup( const QString & text );

	void setUnit( GenericFightUnit * unit );

signals:
	void sig_clicked();

protected:
	Icon * _photo;
	Label * _label;
};


#endif // DISPLAYLORD_H
