/****************************************************************
**
** Attal : Lords of Doom
**
** mapView.cpp
** subclass of QCanvasSprite that handles mouse event ...
**
** Version : $Id: mapView.cpp,v 1.17 2007/07/09 22:28:39 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier
**
** Date : 08/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "mapView.h"

 
// generic include files
// include files for QT
#include <QMouseEvent>
// application specific includes
#include "libCommon/log.h"
#include "libCommon/genericCell.h"

//#include "libClient/lord.h"


/** subclass of QCanvasSprite that handles mouse event ... */
MapView::MapView( Map * map, QWidget * parent, const char * /* name */, Qt::WFlags /* f */ )
	: QGraphicsView( map, parent ) 
{
	viewport()->setMouseTracking( true ) ;
	_press = false;
	_map = map;
}


/** handles mouse event */
void MapView::mouseMoveEvent( QMouseEvent * event )
{	
	QPointF pos = mapToScene(event->pos());	
	if (scene()->sceneRect().contains( pos )) { // possibly unnecessary, but for safety...
		uint row = (uint)pos.y() / DataTheme.tiles.getHeight();
		uint col = (uint)pos.x() / DataTheme.tiles.getWidth() ;
		if( ((Map*)scene())->inMap( row, col )) {
			GenericCell * cell = ((Map*)scene())->at( row, col );
			emit sig_mouseMoved( cell );
		}
	}
	
	//logDD(" pos x %d, y %d", (int) pos.x(),(int) pos.y());
	//logDD(" view pos x %d, y %d", (int) event->pos().x(),(int) event->pos().y());
}

void MapView::mousePressEvent( QMouseEvent * event )
{
	QPointF pos = mapToScene(event->pos());
	if (scene()->sceneRect().contains( pos )) { // possibly unnecessary, but for safety...
		uint row = (uint)pos.y() / DataTheme.tiles.getHeight();
		uint col = (uint)pos.x() / DataTheme.tiles.getWidth() ;
		if( ((Map*)scene())->inMap( row, col )) {
			GenericCell * cell = ((Map*)scene())->at( row, col );
			if( event->button() == Qt::RightButton ) {
				emit sig_mouseRightPressed( cell );
			} else {
				emit sig_mouseLeftPressed( cell );
			}
			_press = true;
		}
	}
	updateMap();
}

void MapView::mouseReleaseEvent( QMouseEvent * )
{
	_press = false;
	emit sig_mouseReleased();
	updateMap();
}

void MapView::mouseDoubleClickEvent( QMouseEvent * event )
{
	mousePressEvent( event );
	mouseReleaseEvent( event );
}

void MapView::slot_Center( int row, int col) 
{
	if( _map->inMap( row, col )) {
		this->centerOn( col * DataTheme.tiles.getWidth(), row * DataTheme.tiles.getHeight() );
	}
}

void MapView::slot_Center(double x, double y) {
	centerOn(_map->width() * x, _map->height() * y);
}

void MapView::resizeEvent( QResizeEvent * event )
{
	QGraphicsView::resizeEvent( event );
	//emit sig_viewportResized( viewport()->width() / sceneRect().width(), viewport()->height() / sceneRect().height() ); // NOTE correct way of doing it
	emit sig_viewportResized( width() / sceneRect().width(), height() / sceneRect().height() ); // HACK to workaround a stupid Qt 4.2 bug... They released it too early...
}

void MapView::scrollContentsBy(int dx, int dy)
{
	QGraphicsView::scrollContentsBy( dx, dy );
	
	emit sig_viewportScrolled(
	std::max(0.0, (double)mapToScene(rect()).boundingRect().x() / (double)sceneRect().width()),
	std::max(0.0, (double)mapToScene(rect()).boundingRect().y() / (double)sceneRect().height()));
	
	updateMap();
}

void MapView::updateMap()
{
	TRACE("MapView::updateMap");
	updateMapRect(sceneRect());
}

void MapView::updateMapRect( QRectF rect )
{
	TRACE("MapView::updateMapRect");
	QList<QRectF> rectlist;
	rectlist.append( rect );
	_map->updateMapRect(sceneRect());
}
