/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "internal.h"
#include "prefs.h"
#include "notify.h"
#include "util.h"

#include "gtkgaim.h"
#include "gtkutils.h"

struct component {
  char *id;
  char *description;
  char format_char;
  char *(*generate)();
  void (*init_pref)();
  void (*load)();
  void (*unload)();
  GtkWidget *(*pref_menu)();
};

GList *get_components ();

extern struct component logstats;
extern struct component rss;
extern struct component count;
extern struct component quote;
extern struct component fortune;
extern struct component text;
extern struct component executable;
extern struct component timestamp;
extern struct component uptime;
extern struct component http;

