/*
 * autotrust.h -library for automated updates of DNSSEC Trust Anchors (RFC5011).
 * Copyright (c) 2008, NLnet Labs. All rights reserved.
 * This software is open source.
 * For license see doc/LICENSE.
 */

#ifndef AUTOTRUST_H
#define AUTOTRUST_H

#include <config.h>

#include "lib/log.h"
#include "lib/options.h"
#include "lib/resolver.h"
#include "lib/trust_anchors.h"

/** Structure holding global settings for the autotrust program */
typedef struct autotrust_struct autotrust_t;
struct autotrust_struct {
	/* name of environment */
	const char*	env_name;
	/* configuration file */
	const char*	configfile;
	/* all the configuration options */
	options_t*	options;
	/* our set of trust points */
	tp_set_t*	trustpoints;
	/* flag to be set if trust anchors have become valid/invalid */
	uint8_t changed;
};

#endif /* AUTOTRUST_H */
