/*
 * resolver.h - resolving stuff
 * Copyright (c) 2008, NLnet Labs. All rights reserved.
 * This software is open source.
 * For license see doc/LICENSE.
 */

#ifndef RESOLVER_H
#define RESOLVER_H

#include <config.h>

#include "options.h"
#include "trust_anchors.h"

#define MIN_PENDINGCOUNT 2

/* Set the options that relate to resolving:
 * @param options: autotrust options.
 * @param trust_point: configured trust anchors.
 * @param ctx: unbound context.
 * @return: status code.
 */
int set_resolver_options(options_t* options, tp_t* trust_point,
	struct ub_ctx* ctx);

/* Query DNSKEYs:
 * @param ctx: unbound context.
 * @param trust_point: trust point storage.
 * @return: status code.
 */
int query_dnskeys(struct ub_ctx* ctx, tp_t* trust_point);

/* Update trust anchors:
 * @param trust_point: trust point storage.
 * @param options: autotrust options.
 * @return: status code.
 */
int do_statetable(tp_t* trust_point, options_t* options);

/* Signal the resolver:
 * @param pidfile: the file that stores resolver process id.
 */
void signal_resolver(char* pidfile);

#endif /* RESOLVER_H */
