#ifndef foocachehfoo
#define foocachehfoo

/* $Id: cache.h 308 2005-08-13 21:25:09Z lennart $ */

/***
  This file is part of avahi.
 
  avahi is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.
 
  avahi is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General
  Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with avahi; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.
***/

typedef struct AvahiCache AvahiCache;

#include <avahi-common/llist.h>
#include "prioq.h"
#include "server.h"
#include "timeeventq.h"
#include "hashmap.h"

typedef enum {
    AVAHI_CACHE_VALID,
    AVAHI_CACHE_EXPIRY1,
    AVAHI_CACHE_EXPIRY2,
    AVAHI_CACHE_EXPIRY3,
    AVAHI_CACHE_FINAL
} AvahiCacheEntryState;

typedef struct AvahiCacheEntry AvahiCacheEntry;

struct AvahiCacheEntry {
    AvahiCache *cache;
    AvahiRecord *record;
    struct timeval timestamp;
    struct timeval expiry;
    int cache_flush;
    
    AvahiAddress origin;

    AvahiCacheEntryState state;
    AvahiTimeEvent *time_event;

    AVAHI_LLIST_FIELDS(AvahiCacheEntry, by_key);
    AVAHI_LLIST_FIELDS(AvahiCacheEntry, entry);
};

struct AvahiCache {
    AvahiServer *server;
    
    AvahiInterface *interface;
    
    AvahiHashmap *hashmap;

    AVAHI_LLIST_HEAD(AvahiCacheEntry, entries);

    unsigned n_entries;
};

AvahiCache *avahi_cache_new(AvahiServer *server, AvahiInterface *interface);
void avahi_cache_free(AvahiCache *c);

AvahiCacheEntry *avahi_cache_lookup_key(AvahiCache *c, AvahiKey *k);
AvahiCacheEntry *avahi_cache_lookup_record(AvahiCache *c, AvahiRecord *r);

void avahi_cache_update(AvahiCache *c, AvahiRecord *r, int cache_flush, const AvahiAddress *a);

int avahi_cache_dump(AvahiCache *c, AvahiDumpCallback callback, void* userdata);

typedef void* AvahiCacheWalkCallback(AvahiCache *c, AvahiKey *pattern, AvahiCacheEntry *e, void* userdata);
void* avahi_cache_walk(AvahiCache *c, AvahiKey *pattern, AvahiCacheWalkCallback cb, void* userdata);

int avahi_cache_entry_half_ttl(AvahiCache *c, AvahiCacheEntry *e);

void avahi_cache_flush(AvahiCache *c);

#endif
