#ifndef AUDIOFPHQRESAMPLER_H
#define AUDIOFPHQRESAMPLER_H

#include "IAudioResampler.h"

#define PRECTYPE double
//#define PRECTYPE float

#define PREC (15)		// use 14bits for floating point part
#define PRECSIZE  (1L<<PREC)
#define PRECINT  (-1L<<PREC)

// implementation of the AudioResampler Interface
// floating point high quality version

AVM_BEGIN_NAMESPACE;

template <class T> class AudioFpHQResamplerStereo : public IAudioResampler
{
public:
    virtual uint_t getBitsPerSample() const;
    virtual void resample(void* out, const void* in, uint_t out_count, uint_t int_count);
};

template <class T> class AudioFpHQResamplerMono : public IAudioResampler
{
public:
    virtual uint_t getBitsPerSample() const;
    virtual void resample(void* out, const void* in, uint_t out_count, uint_t in_count);
};

// to be used for 8 & 16 bit samples

template <class T> class AudioIntHQResamplerStereo : public IAudioResampler
{
public:
    virtual uint_t getBitsPerSample() const;
    virtual void resample(void* out, const void* in, uint_t out_count, uint_t int_count);
};

template <class T> class AudioIntHQResamplerMono : public  IAudioResampler
{
public:
    virtual uint_t getBitsPerSample() const;
    virtual void resample(void* out, const void* in, uint_t out_count, uint_t in_count);
};

IAudioResampler* CreateHQResampler(uint_t channels, uint_t bitsPerSample);

AVM_END_NAMESPACE;

#endif // AUDIOFPHQRESAMPLER_H
