#ifndef RENDLOCK_H
#define RENDLOCK_H

#include "avm_locker.h"
#include "avm_cpuinfo.h"
#include "renderer.h"
#include "playerwidget.h"
#include "utils.h"

AVM_BEGIN_NAMESPACE;

// use our internal class for our renderers;
class VideoRendererWithLock : public IVideoRenderer
{
public:
    VideoRendererWithLock(int width, int height, bool _subtitles = false)
	:m_w(width), m_h(height), pic_w(width), pic_h(height),
	m_sub(0), fm_height(0), m_lLastDrawStamp(0), m_pPw(0),
	m_lMouseTime(0), m_lMouseLast(0), m_iMouseX(0), m_iMouseY(0),
	m_iMouseOff(0), m_iAuto(1),
        m_bQuit(false), m_bSubtitles(_subtitles),
	m_bFullscreen(false)
    {}
    virtual int Lock() const { return m_Mutex.Lock(); }
    virtual int TryLock() const { return m_Mutex.TryLock(); }
    virtual int Unlock() const { return m_Mutex.Unlock(); }
    virtual const avm::vector<VideoMode>& GetVideoModes() const { return modes; }
    virtual int GetSize(int& width, int& height) const
    {
	width = pic_w;
	height = pic_h;
	return 0;
    }
    virtual void MouseOff() = 0;
    virtual void MouseOn() = 0;
    virtual int processEvent()
    {
	if (m_lMouseTime)
	{
	    if (to_float(longcount(), m_lMouseTime) > 1.0)
		MouseOff();
	    else if (m_lMouseTime != m_lMouseLast && --m_iMouseOff == 0)
		MouseOn();
	    m_lMouseLast = m_lMouseTime;
	}
        return 0;
    }
protected:
    static void* eventThread(void *arg);

    mutable PthreadMutex m_Mutex;
    int m_w, m_h;
    int pic_w, pic_h;
    int m_sub;
    int fm_height;
    PthreadMutex emutex;
    PthreadCond econd;
    int64_t m_lLastDrawStamp;
    avm::vector<VideoMode> modes;
    PlayerWidget* m_pPw;
    int64_t m_lMouseTime;
    int64_t m_lMouseLast; // keep time of last mouse event
    int m_iMouseX, m_iMouseY;
    int m_iMouseOff;
    int m_iAuto; // keyboard  autorepeat

    bool m_bQuit;
    bool m_bSubtitles;
    bool m_bFullscreen;
};

AVM_END_NAMESPACE;

#endif
