#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* *incomplete* #define PROG_LANGUAGE_GERMAN	4 */
/* *incomplete* #define PROG_LANGUAGE_ITALIAN	5 */
/* *incomplete* #define PROG_LANGUAGE_DUTCH	6 */
/* *incomplete* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* *incomplete* #define PROG_LANGUAGE_PORTUGUESE	8 */


/*
 *      Program name and version:
 */
#define PROG_NAME		"AVScan"
#define PROG_NAME_FULL		"AntiVirus Scanner"

#define PROG_VERSION		"0.8.3"

#define PROG_VERSION_MAJOR	0
#define PROG_VERSION_MINOR	8
#define PROG_VERSION_RELEASE	3

/*
 *	Program URL:
 */
#define PROG_URL	"http://wolfpack.twu.net/Endeavour2/"

/*
 *      Copyright message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_COPYRIGHT	"\
El derecho de autor (C) 1997-2006 WolfPack Entertainment.\n\
Este programa es protegido por leyes internacionales de derecho de autor\n\
y tratados, la distribucin y/o la modificacin de este software en la\n\
infraccin de la Licencia del Pblico de GNU se prohiben estrictamente.\n\
Violators ser procesado a la extensin ms repleta de la ley.\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_COPYRIGHT  "\
Dposer (C) 1997-2006 WolfPack Entertainment.\n\
Ce programme est protg par international dpose lois et traits, \n\
distribution et/ou de ce logiciel dans violation du GNU Public Permis\n\
strictement est interdit. Violators sera poursuivi  l'tendue plus pleine\n\
de la loi.\n"
#elif defined(PROG_LANGUAGE_GERMAN)
#define PROG_COPYRIGHT  "\
Urheberrecht (C) 1997-2006 WolfPack Entertainment.\n\
Dieses Programm wird von internationalem Urheberrecht Gesetzen und\n\
Vertrgen, Austeilung bzw. nderung dieser Software in bertretung\n\
DER GNU ffentlichkeit Erlaubnis streng verboten wird geschtzt.\n\
Verletzer werden zum vollsten Umfang des Gesetzes strafrechtlich\n\
verfolgt werden.\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
#define PROG_COPYRIGHT  "\
Il copyright (C) 1997-2006 WolfPack Entertainment.\n\
Questo programma  protetto dalle leggi di copyright internazionali e\n\
dai trattati, la distribuzione e/o la modifica di questo software nella\n\
violazione dello GNU la Licenza Pubblica  strettamente proibita. Il\n\
Violators sar perseguito all'estensione la pi piena della legge.\n"
#elif defined(PROG_LANGUAGE_DUTCH)
#define PROG_COPYRIGHT  "\
Auteursrecht (C) 1997-2006 WolfPack Entertainment.\n\
Deze programma wordt door internationale auteursrecht wetten en\n\
verdragen, verdeling en/of wijziging van deze software in overtreding\n\
van de GNU Publiek Vergunning strikt verboden wordt beschermd.\n\
Overtreders zullen te de volste omvang van de wet geprocedeerd worden.\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
#define PROG_COPYRIGHT  "\
Os direitos autorais (C) 1997-2006 WolfPack Entertainment.\n\
Este programa  protegido por direitos internacionais leis autorais e\n\
tratados, modificao de e/ou de distribuio deste software em infrao\n\
do GNU Licena Pblica precisamente  proibida. O Violators ser\n\
processado  plena extenso da lei.\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2006 WolfPack Entertainment.\n\
Dette programet beskytter av internasjonal copyrightlover og traktater,\n\
distribusjon og/eller modifikasjon av denne programvaren i overtredelse\n\
av GNU Public License er streng forbudt. Violators tiltalt til den\n\
fulleste omfang av loven.\n"
#else
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2006 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"
#endif


/*
 *	Prefix Directory:
 */
#ifndef PREFIX
# define PREFIX		"/usr"
#endif


/*
 *	Usage message:
 */
#define PROG_USAGE_MESG  "\
Usage: avscan [paths...] [options]\n\
       avscan --scan <paths...> [options]\n\
\n\
    [path(s)...] specifies the file(s) or directory(ies) to scan at\n\
    startup.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recursive             Recurse into subdirectories.\n\
        -r                      Same as --recursive.\n\
        --executables-only      Scan executable files only.\n\
        -x                      Same as --executables-only.\n\
	--ignore-links		Do not scan link destinations.\n\
	-l			Same as --ignore-links.\n\
        --database <path>       Set the virus database to <path> (this\n\
                                may be a file or directory).\n\
        -db <path>              Same as --database.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    <path(s)...> specifies the file(s) and/or directory(ies) to scan\n\
    in text mode (used with --scan only).\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       Virus detected or general error.\n\
        2       Bad value.\n\
        3       Systems error.\n\
        4       User aborted.\n\
        5       An identical operation is already in progress.\n\
        8       Segmentation fault.\n\
\n"


/*
 *	Configuration File Characters:
 */
#define CFG_COMMENT_CHAR		'#'
#define CFG_DELIMINATOR_CHAR		'='

/*
 *	Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER		"BROWSER"
#define ENV_VAR_NAME_HELPBROWSER	"HELPBROWSER"
#define ENV_VAR_NAME_TMPDIR		"TMPDIR"

/*
 *	DND Infos:
 */
#define DND_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define DND_INFO_TEXT_URI_LIST		1	/* "text/uri-list" */
#define DND_INFO_STRING			2	/* "STRING" */


/*
 *	List Defaults:
 */
#define WIN_LIST_ROW_SPACING		20	/* In pixels */
#define WIN_LIST_PIXMAP_TEXT_SPACING	2	/* In pixels */


/*
 *	Configuration Files:
 */
#define AVSCAN_CFG_FILE			"avscan.ini"
#define AVSCAN_SCAN_LIST_FILE		"avscan_scan_list.ini"
#if defined(DEBIAN)
# define AVSCAN_DB_LOCATION		"/var/lib/clamav"
#else
# define AVSCAN_DB_LOCATION		PREFIX "/share/clamav"
#endif


#endif	/* CONFIG_H */
