/* digital-clock.c generated by valac 0.9.7, the Vala compiler
 * generated from digital-clock.vala, do not modify */

/*
 * Digital-clock applet for Awn (based on applet by Ryan Rushton)
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/config.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <config.h>


#define TYPE_DIGITAL_CLOCK (digital_clock_get_type ())
#define DIGITAL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGITAL_CLOCK, DigitalClock))
#define DIGITAL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGITAL_CLOCK, DigitalClockClass))
#define IS_DIGITAL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGITAL_CLOCK))
#define IS_DIGITAL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGITAL_CLOCK))
#define DIGITAL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGITAL_CLOCK, DigitalClockClass))

typedef struct _DigitalClock DigitalClock;
typedef struct _DigitalClockClass DigitalClockClass;
typedef struct _DigitalClockPrivate DigitalClockPrivate;

#define TYPE_DIGITAL_CLOCK_PREFS (digital_clock_prefs_get_type ())
#define DIGITAL_CLOCK_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefs))
#define DIGITAL_CLOCK_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefsClass))
#define IS_DIGITAL_CLOCK_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGITAL_CLOCK_PREFS))
#define IS_DIGITAL_CLOCK_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGITAL_CLOCK_PREFS))
#define DIGITAL_CLOCK_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefsClass))

typedef struct _DigitalClockPrefs DigitalClockPrefs;
typedef struct _DigitalClockPrefsClass DigitalClockPrefsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DigitalClock {
	AwnAppletSimple parent_instance;
	DigitalClockPrivate * priv;
};

struct _DigitalClockClass {
	AwnAppletSimpleClass parent_class;
};

struct _DigitalClockPrivate {
	GtkMenu* _menu;
	AwnDialog* dialog;
	AwnOverlayText* time_overlay;
	AwnOverlayText* am_pm_overlay;
	AwnOverlayText* day_overlay;
	AwnOverlayText* date_overlay;
	DesktopAgnosticConfigClient* client;
	char** current_time;
	gint current_time_length1;
	gint _current_time_size_;
	DigitalClockPrefs* prefs;
	gboolean _is_12_hour;
	gboolean _show_date;
	gboolean _date_before_time;
	char* _calendar_command;
	char* _datetime_command;
};


static gpointer digital_clock_parent_class = NULL;

GType digital_clock_get_type (void) G_GNUC_CONST;
GType digital_clock_prefs_get_type (void) G_GNUC_CONST;
#define DIGITAL_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIGITAL_CLOCK, DigitalClockPrivate))
enum  {
	DIGITAL_CLOCK_DUMMY_PROPERTY,
	DIGITAL_CLOCK_IS_12_HOUR,
	DIGITAL_CLOCK_SHOW_DATE,
	DIGITAL_CLOCK_DATE_BEFORE_TIME,
	DIGITAL_CLOCK_CALENDAR_COMMAND,
	DIGITAL_CLOCK_DATETIME_COMMAND
};
#define DIGITAL_CLOCK_EVOLUTION_COMMAND "evolution calendar:///?startdate=%(year)02d%(month)02d%(day)02dT120000"
#define DIGITAL_CLOCK_TIME_ADMIN_COMMAND "gksudo time-admin"
DigitalClock* digital_clock_new (const char* canonical_name, const char* uid, gint panel_id);
DigitalClock* digital_clock_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void digital_clock_on_clicked (DigitalClock* self);
static void _digital_clock_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self);
static void digital_clock_on_context_menu_popup (DigitalClock* self, GdkEventButton* event);
static void _digital_clock_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self);
static void digital_clock_refresh_overlays (DigitalClock* self);
static void _digital_clock_refresh_overlays_awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self);
static void _digital_clock_refresh_overlays_awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self);
static void digital_clock_force_refresh (DigitalClock* self);
static void _digital_clock_force_refresh_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void digital_clock_update_clock (DigitalClock* self);
static gboolean _lambda7_ (DigitalClock* self);
static gboolean __lambda7__gsource_func (gpointer self);
static void digital_clock_init_calendar (DigitalClock* self);
static void digital_clock_start_external_calendar (DigitalClock* self, GtkCalendar* calendar);
static void _digital_clock_start_external_calendar_gtk_calendar_day_selected_double_click (GtkCalendar* _sender, gpointer self);
const char* digital_clock_get_calendar_command (DigitalClock* self);
gboolean digital_clock_get_show_date (DigitalClock* self);
gboolean digital_clock_get_date_before_time (DigitalClock* self);
gboolean digital_clock_get_is_12_hour (DigitalClock* self);
static gboolean digital_clock_time_string_changed (DigitalClock* self);
static char** digital_clock_get_time_string (DigitalClock* self, int* result_length1);
static char** _vala_array_dup1 (char** self, int length);
static char** _vala_array_dup2 (char** self, int length);
static char* digital_clock_format_current_time (const char* format);
static void _lambda3_ (GtkMenuItem* w, DigitalClock* self);
static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda4_ (GtkMenuItem* w, DigitalClock* self);
static void __lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda5_ (GtkMenuItem* w, DigitalClock* self);
const char* digital_clock_get_datetime_command (DigitalClock* self);
static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda6_ (GtkMenuItem* w, DigitalClock* self);
DigitalClockPrefs* digital_clock_prefs_new (AwnApplet* applet);
DigitalClockPrefs* digital_clock_prefs_construct (GType object_type, AwnApplet* applet);
GtkDialog* digital_clock_prefs_get_dialog (DigitalClockPrefs* self);
static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void digital_clock_set_is_12_hour (DigitalClock* self, gboolean value);
void digital_clock_set_show_date (DigitalClock* self, gboolean value);
void digital_clock_set_date_before_time (DigitalClock* self, gboolean value);
void digital_clock_set_calendar_command (DigitalClock* self, const char* value);
void digital_clock_set_datetime_command (DigitalClock* self, const char* value);
static void digital_clock_finalize (GObject* obj);
static void digital_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void digital_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* DIGITAL_CLOCK_authors[1] = {"Michal Hruby <michal.mhr@gmail.com>"};


static void _digital_clock_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self) {
	digital_clock_on_clicked (self);
}


static void _digital_clock_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self) {
	digital_clock_on_context_menu_popup (self, event);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _digital_clock_refresh_overlays_awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self) {
	digital_clock_refresh_overlays (self);
}


static void _digital_clock_refresh_overlays_awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self) {
	digital_clock_refresh_overlays (self);
}


static void _digital_clock_force_refresh_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	digital_clock_force_refresh (self);
}


static gboolean _lambda7_ (DigitalClock* self) {
	gboolean result = FALSE;
	digital_clock_update_clock (self);
	result = TRUE;
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


DigitalClock* digital_clock_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	DigitalClock * self;
	DesktopAgnosticConfigClient* _tmp0_;
	DesktopAgnosticConfigClient* _tmp1_;
	AwnOverlayText* _tmp2_;
	AwnOverlayText* _tmp3_;
	AwnOverlayText* _tmp4_;
	AwnOverlayText* _tmp5_;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	self = (DigitalClock*) g_object_new (object_type, "canonical-name", canonical_name, "uid", uid, "panel-id", panel_id, NULL);
	g_object_set ((AwnApplet*) self, "display-name", _ ("Digital Clock"), NULL);
	g_signal_connect_object ((AwnAppletSimple*) self, "clicked", (GCallback) _digital_clock_on_clicked_awn_applet_simple_clicked, self, 0);
	g_signal_connect_object ((AwnAppletSimple*) self, "context-menu-popup", (GCallback) _digital_clock_on_context_menu_popup_awn_applet_simple_context_menu_popup, self, 0);
	_tmp0_ = awn_config_get_default_for_applet ((AwnApplet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->client = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (self->priv->client), _tmp1_);
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "hour12", (GObject*) self, "is_12_hour", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "show_date", (GObject*) self, "show_date", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "dbt", (GObject*) self, "date_before_time", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, "commands", "calendar", (GObject*) self, "calendar_command", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, "commands", "adjust_datetime", (GObject*) self, "datetime_command", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->time_overlay = (_tmp2_ = g_object_ref_sink (awn_overlay_text_new ()), _g_object_unref0 (self->priv->time_overlay), _tmp2_);
	awn_overlay_set_apply_effects ((AwnOverlay*) self->priv->time_overlay, TRUE);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, (AwnOverlay*) self->priv->time_overlay);
	self->priv->am_pm_overlay = (_tmp3_ = g_object_ref_sink (awn_overlay_text_new ()), _g_object_unref0 (self->priv->am_pm_overlay), _tmp3_);
	awn_overlay_set_apply_effects ((AwnOverlay*) self->priv->am_pm_overlay, TRUE);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, (AwnOverlay*) self->priv->am_pm_overlay);
	self->priv->day_overlay = (_tmp4_ = g_object_ref_sink (awn_overlay_text_new ()), _g_object_unref0 (self->priv->day_overlay), _tmp4_);
	awn_overlay_set_apply_effects ((AwnOverlay*) self->priv->day_overlay, TRUE);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, (AwnOverlay*) self->priv->day_overlay);
	self->priv->date_overlay = (_tmp5_ = g_object_ref_sink (awn_overlay_text_new ()), _g_object_unref0 (self->priv->date_overlay), _tmp5_);
	awn_overlay_set_apply_effects ((AwnOverlay*) self->priv->date_overlay, TRUE);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, (AwnOverlay*) self->priv->date_overlay);
	pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
	gdk_pixbuf_fill (pixbuf, (guint32) 0);
	awn_applet_simple_set_icon_pixbuf ((AwnAppletSimple*) self, pixbuf);
	g_signal_connect_object ((AwnApplet*) self, "position-changed", (GCallback) _digital_clock_refresh_overlays_awn_applet_position_changed, self, 0);
	g_signal_connect_object ((AwnApplet*) self, "size-changed", (GCallback) _digital_clock_refresh_overlays_awn_applet_size_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _digital_clock_force_refresh_g_object_notify, self, 0);
	digital_clock_refresh_overlays (self);
	digital_clock_update_clock (self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda7__gsource_func, g_object_ref (self), g_object_unref);
	digital_clock_init_calendar (self);
	_g_object_unref0 (pixbuf);
	return self;
}


DigitalClock* digital_clock_new (const char* canonical_name, const char* uid, gint panel_id) {
	return digital_clock_construct (TYPE_DIGITAL_CLOCK, canonical_name, uid, panel_id);
}


static void _digital_clock_start_external_calendar_gtk_calendar_day_selected_double_click (GtkCalendar* _sender, gpointer self) {
	digital_clock_start_external_calendar (self, _sender);
}


static void digital_clock_init_calendar (DigitalClock* self) {
	AwnDialog* _tmp0_;
	GtkCalendar* calendar;
	g_return_if_fail (self != NULL);
	self->priv->dialog = (_tmp0_ = g_object_ref_sink ((AwnDialog*) awn_dialog_new_for_widget ((GtkWidget*) self)), _g_object_unref0 (self->priv->dialog), _tmp0_);
	g_object_set (self->priv->dialog, "hide-on-unfocus", TRUE, NULL);
	calendar = g_object_ref_sink ((GtkCalendar*) gtk_calendar_new ());
	gtk_calendar_set_display_options (calendar, (GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES) | GTK_CALENDAR_SHOW_WEEK_NUMBERS);
	g_signal_connect_object (calendar, "day-selected-double-click", (GCallback) _digital_clock_start_external_calendar_gtk_calendar_day_selected_double_click, self, 0);
	gtk_window_set_title ((GtkWindow*) self->priv->dialog, _ ("Calendar"));
	gtk_container_add ((GtkContainer*) self->priv->dialog, (GtkWidget*) calendar);
	_g_object_unref0 (calendar);
}


static void digital_clock_start_external_calendar (DigitalClock* self, GtkCalendar* calendar) {
	guint year = 0U;
	guint month = 0U;
	guint day = 0U;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* python_cmd;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (calendar != NULL);
	gtk_calendar_get_date (calendar, &year, &month, &day);
	month++;
	python_cmd = (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat ("python -c \"" "import subprocess;", _tmp0_ = g_strdup_printf ("data = {'year': %u, 'month': %u, 'day': %u};", year, month, day), NULL), _tmp2_ = g_strdup_printf ("command = '%s';", self->priv->_calendar_command), NULL), "subprocess.Popen(command % data, shell=True);", NULL), "\"", NULL), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp5_);
	g_spawn_command_line_async (python_cmd, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (python_cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (python_cmd);
}


static void digital_clock_force_refresh (DigitalClock* self) {
	char** _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->current_time = (_tmp0_ = NULL, self->priv->current_time = (_vala_array_free (self->priv->current_time, self->priv->current_time_length1, (GDestroyNotify) g_free), NULL), self->priv->current_time_length1 = 0, self->priv->_current_time_size_ = self->priv->current_time_length1, _tmp0_);
	digital_clock_refresh_overlays (self);
	digital_clock_update_clock (self);
}


static void digital_clock_refresh_overlays (DigitalClock* self) {
	GtkPositionType position;
	gint size;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	position = awn_applet_get_pos_type ((AwnApplet*) self);
	size = awn_applet_get_size ((AwnApplet*) self);
	g_object_set ((AwnOverlay*) self->priv->am_pm_overlay, "active", FALSE, NULL);
	g_object_set ((AwnOverlay*) self->priv->day_overlay, "active", self->priv->_show_date, NULL);
	g_object_set ((AwnOverlay*) self->priv->date_overlay, "active", self->priv->_show_date, NULL);
	if (position == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == GTK_POS_BOTTOM;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_date_before_time) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = !self->priv->_show_date;
		}
		if (_tmp1_) {
			gint _tmp2_ = 0;
			gint width;
			gint _tmp3_ = 0;
			GdkGravity _tmp4_ = 0;
			gboolean _tmp5_ = FALSE;
			if (self->priv->_show_date) {
				_tmp2_ = (size * 11) / 5;
			} else {
				_tmp2_ = (size * 3) / 2;
			}
			width = _tmp2_;
			awn_icon_set_custom_paint (awn_applet_simple_get_icon ((AwnAppletSimple*) self), width, size);
			if (self->priv->_show_date) {
				_tmp3_ = 22;
			} else {
				_tmp3_ = 25;
			}
			g_object_set (self->priv->time_overlay, "font-sizing", (double) _tmp3_, NULL);
			if (self->priv->_show_date) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = self->priv->_is_12_hour;
			}
			if (_tmp5_) {
				_tmp4_ = GDK_GRAVITY_NORTH_EAST;
			} else {
				_tmp4_ = GDK_GRAVITY_CENTER;
			}
			g_object_set ((AwnOverlay*) self->priv->time_overlay, "gravity", _tmp4_, NULL);
			g_object_set (self->priv->day_overlay, "font-sizing", (double) 14, NULL);
			g_object_set ((AwnOverlay*) self->priv->day_overlay, "gravity", GDK_GRAVITY_WEST, NULL);
			g_object_set ((AwnOverlay*) self->priv->day_overlay, "y-adj", (double) 0, NULL);
			g_object_set (self->priv->date_overlay, "font-sizing", (double) 14, NULL);
			g_object_set ((AwnOverlay*) self->priv->date_overlay, "gravity", GDK_GRAVITY_SOUTH_WEST, NULL);
			if (self->priv->_is_12_hour) {
				g_object_set ((AwnOverlay*) self->priv->am_pm_overlay, "active", TRUE, NULL);
				g_object_set (self->priv->am_pm_overlay, "font-sizing", (double) 14, NULL);
				g_object_set ((AwnOverlay*) self->priv->am_pm_overlay, "gravity", GDK_GRAVITY_SOUTH_EAST, NULL);
			}
		} else {
			gint _tmp6_ = 0;
			gint width;
			gint _tmp7_ = 0;
			if (self->priv->_is_12_hour) {
				_tmp6_ = (size * 17) / 10;
			} else {
				_tmp6_ = (size * 6) / 5;
			}
			width = _tmp6_;
			awn_icon_set_custom_paint (awn_applet_simple_get_icon ((AwnAppletSimple*) self), width, size);
			if (self->priv->_is_12_hour) {
				_tmp7_ = 17;
			} else {
				_tmp7_ = 18;
			}
			g_object_set (self->priv->time_overlay, "font-sizing", (double) _tmp7_, NULL);
			g_object_set ((AwnOverlay*) self->priv->time_overlay, "gravity", GDK_GRAVITY_NORTH, NULL);
			g_object_set (self->priv->day_overlay, "font-sizing", (double) 14, NULL);
			g_object_set ((AwnOverlay*) self->priv->day_overlay, "gravity", GDK_GRAVITY_CENTER, NULL);
			g_object_set ((AwnOverlay*) self->priv->day_overlay, "y-adj", 0.05, NULL);
			g_object_set (self->priv->date_overlay, "font-sizing", (double) 14, NULL);
			g_object_set ((AwnOverlay*) self->priv->date_overlay, "gravity", GDK_GRAVITY_SOUTH, NULL);
		}
	} else {
		gint height = 0;
		gint _tmp8_ = 0;
		GdkGravity _tmp10_ = 0;
		if (self->priv->_show_date) {
			height = size;
		} else {
			height = size / 2;
		}
		awn_icon_set_custom_paint (awn_applet_simple_get_icon ((AwnAppletSimple*) self), size, height);
		if (self->priv->_is_12_hour) {
			_tmp8_ = 10;
		} else {
			_tmp8_ = 15;
		}
		g_object_set (self->priv->time_overlay, "font-sizing", (double) _tmp8_, NULL);
		if (!self->priv->_show_date) {
			double _tmp9_;
			g_object_set (self->priv->time_overlay, "font-sizing", (g_object_get (self->priv->time_overlay, "font-sizing", &_tmp9_, NULL), _tmp9_) * ((double) 2), NULL);
		}
		if (self->priv->_show_date) {
			_tmp10_ = GDK_GRAVITY_NORTH;
		} else {
			_tmp10_ = GDK_GRAVITY_CENTER;
		}
		g_object_set ((AwnOverlay*) self->priv->time_overlay, "gravity", _tmp10_, NULL);
		g_object_set (self->priv->day_overlay, "font-sizing", (double) 12, NULL);
		g_object_set ((AwnOverlay*) self->priv->day_overlay, "gravity", GDK_GRAVITY_CENTER, NULL);
		g_object_set ((AwnOverlay*) self->priv->day_overlay, "y-adj", 0.05, NULL);
		g_object_set (self->priv->date_overlay, "font-sizing", (double) 12, NULL);
		g_object_set ((AwnOverlay*) self->priv->date_overlay, "gravity", GDK_GRAVITY_SOUTH, NULL);
	}
}


static void digital_clock_update_clock (DigitalClock* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!digital_clock_time_string_changed (self)) {
		return;
	}
	if (!self->priv->_is_12_hour) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp0_ = (g_object_get ((AwnOverlay*) self->priv->am_pm_overlay, "active", &_tmp1_, NULL), _tmp1_);
	}
	if (_tmp0_) {
		g_object_set (self->priv->time_overlay, "text", self->priv->current_time[0], NULL);
		g_object_set (self->priv->am_pm_overlay, "text", self->priv->current_time[1], NULL);
	} else {
		char* _tmp2_;
		g_object_set (self->priv->time_overlay, "text", _tmp2_ = g_strdup_printf ("%s %s", self->priv->current_time[0], self->priv->current_time[1]), NULL);
		_g_free0 (_tmp2_);
	}
	g_object_set (self->priv->day_overlay, "text", self->priv->current_time[2], NULL);
	g_object_set (self->priv->date_overlay, "text", self->priv->current_time[3], NULL);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean digital_clock_time_string_changed (DigitalClock* self) {
	gboolean result = FALSE;
	gint cur_time_length1;
	gint _cur_time_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** cur_time;
	g_return_val_if_fail (self != NULL, FALSE);
	cur_time = (_tmp1_ = digital_clock_get_time_string (self, &_tmp0_), cur_time_length1 = _tmp0_, _cur_time_size_ = cur_time_length1, _tmp1_);
	if (self->priv->current_time == NULL) {
		char** _tmp2_;
		char** _tmp3_;
		self->priv->current_time = (_tmp3_ = (_tmp2_ = cur_time, (_tmp2_ == NULL) ? ((gpointer) _tmp2_) : _vala_array_dup1 (_tmp2_, cur_time_length1)), self->priv->current_time = (_vala_array_free (self->priv->current_time, self->priv->current_time_length1, (GDestroyNotify) g_free), NULL), self->priv->current_time_length1 = cur_time_length1, self->priv->_current_time_size_ = self->priv->current_time_length1, _tmp3_);
		result = TRUE;
		cur_time = (_vala_array_free (cur_time, cur_time_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < self->priv->current_time_length1)) {
					break;
				}
				if (_vala_strcmp0 (self->priv->current_time[i], cur_time[i]) != 0) {
					char** _tmp5_;
					char** _tmp6_;
					self->priv->current_time = (_tmp6_ = (_tmp5_ = cur_time, (_tmp5_ == NULL) ? ((gpointer) _tmp5_) : _vala_array_dup2 (_tmp5_, cur_time_length1)), self->priv->current_time = (_vala_array_free (self->priv->current_time, self->priv->current_time_length1, (GDestroyNotify) g_free), NULL), self->priv->current_time_length1 = cur_time_length1, self->priv->_current_time_size_ = self->priv->current_time_length1, _tmp6_);
					result = TRUE;
					cur_time = (_vala_array_free (cur_time, cur_time_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = FALSE;
	cur_time = (_vala_array_free (cur_time, cur_time_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


static char* g_time_format (struct tm *self, const char* format) {
	char* result = NULL;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp0_;
	gchar* buffer;
	g_return_val_if_fail (format != NULL, NULL);
	buffer = (_tmp0_ = g_new0 (gchar, 64), buffer_length1 = 64, _buffer_size_ = buffer_length1, _tmp0_);
	strftime (buffer, buffer_length1, format, &(*self));
	result = g_strdup ((const char*) buffer);
	buffer = (g_free (buffer), NULL);
	return result;
}


static char* digital_clock_format_current_time (const char* format) {
	char* result = NULL;
	time_t cur_time_t;
	struct tm _tmp0_ = {0};
	struct tm cur_time;
	g_return_val_if_fail (format != NULL, NULL);
	cur_time_t = time (NULL);
	cur_time = (g_time_local (cur_time_t, &_tmp0_), _tmp0_);
	result = g_time_format (&cur_time, format);
	return result;
}


static char** digital_clock_get_time_string (DigitalClock* self, int* result_length1) {
	char** result = NULL;
	gint full_date_length1;
	gint _full_date_size_;
	char** _tmp0_;
	char** full_date;
	time_t cur_time_t;
	struct tm _tmp1_ = {0};
	struct tm cur_time;
	char* _tmp6_;
	char* _tmp7_;
	char** _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	full_date = (_tmp0_ = g_new0 (char*, 4 + 1), full_date_length1 = 4, _full_date_size_ = full_date_length1, _tmp0_);
	cur_time_t = time (NULL);
	cur_time = (g_time_local (cur_time_t, &_tmp1_), _tmp1_);
	if (self->priv->_is_12_hour) {
		char* _tmp2_;
		char* _tmp3_;
		full_date[0] = (_tmp2_ = g_time_format (&cur_time, "%I:%M"), _g_free0 (full_date[0]), _tmp2_);
		full_date[1] = (_tmp3_ = g_time_format (&cur_time, "%p"), _g_free0 (full_date[1]), _tmp3_);
	} else {
		char* _tmp4_;
		char* _tmp5_;
		full_date[0] = (_tmp4_ = g_time_format (&cur_time, "%H:%M"), _g_free0 (full_date[0]), _tmp4_);
		full_date[1] = (_tmp5_ = g_strdup (""), _g_free0 (full_date[1]), _tmp5_);
	}
	full_date[2] = (_tmp6_ = g_time_format (&cur_time, "%a"), _g_free0 (full_date[2]), _tmp6_);
	full_date[3] = (_tmp7_ = g_time_format (&cur_time, "%b %d"), _g_free0 (full_date[3]), _tmp7_);
	result = (_tmp8_ = full_date, *result_length1 = full_date_length1, _tmp8_);
	return result;
	full_date = (_vala_array_free (full_date, full_date_length1, (GDestroyNotify) g_free), NULL);
}


static void digital_clock_on_clicked (DigitalClock* self) {
	GtkWidgetFlags flags;
	g_return_if_fail (self != NULL);
	flags = GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->dialog) & GTK_VISIBLE;
	if (flags != GTK_VISIBLE) {
		gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	}
}


static void _lambda3_ (GtkMenuItem* w, DigitalClock* self) {
	GtkClipboard* cb;
	g_return_if_fail (w != NULL);
	cb = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	if (self->priv->_is_12_hour) {
		char* _tmp0_;
		gtk_clipboard_set_text (cb, _tmp0_ = digital_clock_format_current_time ("%I:%M %p"), -1);
		_g_free0 (_tmp0_);
	} else {
		char* _tmp1_;
		gtk_clipboard_set_text (cb, _tmp1_ = digital_clock_format_current_time ("%H:%M"), -1);
		_g_free0 (_tmp1_);
	}
}


static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkMenuItem* w, DigitalClock* self) {
	GtkClipboard* cb;
	char* _tmp0_;
	g_return_if_fail (w != NULL);
	cb = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_text (cb, _tmp0_ = digital_clock_format_current_time ("%A, %B %d %Y"), -1);
	_g_free0 (_tmp0_);
}


static void __lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void _lambda5_ (GtkMenuItem* w, DigitalClock* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (w != NULL);
	if (string_get_length (self->priv->_datetime_command) > 0) {
		g_spawn_command_line_async (self->priv->_datetime_command, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkMenuItem* w, DigitalClock* self) {
	g_return_if_fail (w != NULL);
	if (self->priv->prefs == NULL) {
		DigitalClockPrefs* _tmp0_;
		DigitalClockPrefs* _tmp1_;
		self->priv->prefs = (_tmp0_ = digital_clock_prefs_new ((AwnApplet*) self), _g_object_unref0 (self->priv->prefs), _tmp0_);
		gtk_dialog_run (digital_clock_prefs_get_dialog (self->priv->prefs));
		gtk_object_destroy ((GtkObject*) digital_clock_prefs_get_dialog (self->priv->prefs));
		self->priv->prefs = (_tmp1_ = NULL, _g_object_unref0 (self->priv->prefs), _tmp1_);
	} else {
		GtkDialog* dialog;
		dialog = _g_object_ref0 (digital_clock_prefs_get_dialog (self->priv->prefs));
		gtk_window_present_with_time ((GtkWindow*) dialog, gtk_get_current_event_time ());
		_g_object_unref0 (dialog);
	}
}


static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void digital_clock_on_context_menu_popup (DigitalClock* self, GdkEventButton* event) {
	g_return_if_fail (self != NULL);
	if (self->priv->_menu == NULL) {
		GtkImageMenuItem* image_item;
		GtkMenuItem* menu_item;
		GtkWidget* about_item;
		GtkWidget* _tmp0_;
		GtkMenu* _tmp1_;
		GtkImageMenuItem* _tmp2_;
		GtkImage* _tmp3_;
		GtkImageMenuItem* _tmp4_;
		GtkImage* _tmp5_;
		GtkImageMenuItem* _tmp6_;
		GtkImage* _tmp7_;
		GtkMenuItem* _tmp8_;
		GtkImageMenuItem* _tmp9_;
		GtkMenuItem* separator;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		image_item = NULL;
		menu_item = NULL;
		about_item = NULL;
		self->priv->_menu = (_tmp1_ = _g_object_ref0 ((_tmp0_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->_menu), _tmp1_);
		image_item = (_tmp2_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Copy Time"))), _g_object_unref0 (image_item), _tmp2_);
		gtk_image_menu_item_set_image (image_item, (GtkWidget*) (_tmp3_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_COPY, GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp3_);
		g_signal_connect_object ((GtkMenuItem*) image_item, "activate", (GCallback) __lambda3__gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) image_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) ((GtkMenuItem*) image_item));
		image_item = (_tmp4_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Copy Date"))), _g_object_unref0 (image_item), _tmp4_);
		gtk_image_menu_item_set_image (image_item, (GtkWidget*) (_tmp5_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_COPY, GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp5_);
		g_signal_connect_object ((GtkMenuItem*) image_item, "activate", (GCallback) __lambda4__gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) image_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) ((GtkMenuItem*) image_item));
		image_item = (_tmp6_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Adjust Date & Time"))), _g_object_unref0 (image_item), _tmp6_);
		gtk_image_menu_item_set_image (image_item, (GtkWidget*) (_tmp7_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp7_);
		g_signal_connect_object ((GtkMenuItem*) image_item, "activate", (GCallback) __lambda5__gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) image_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) ((GtkMenuItem*) image_item));
		menu_item = (_tmp8_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (menu_item), _tmp8_);
		gtk_widget_show ((GtkWidget*) menu_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) menu_item);
		image_item = (_tmp9_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL)), _g_object_unref0 (image_item), _tmp9_);
		g_signal_connect_object ((GtkMenuItem*) image_item, "activate", (GCallback) __lambda6__gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) image_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) ((GtkMenuItem*) image_item));
		separator = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ());
		gtk_widget_show ((GtkWidget*) separator);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) separator);
		about_item = (_tmp10_ = _g_object_ref0 (awn_applet_create_about_item ((AwnApplet*) self, "Copyright © 2010 Michal Hruby", AWN_APPLET_LICENSE_GPLV2, VERSION, _ ("Displays digital clock."), NULL, NULL, "awn-applet-digital-clock", NULL, DIGITAL_CLOCK_authors, NULL, NULL)), _g_object_unref0 (about_item), _tmp10_);
		gtk_widget_show (about_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) (_tmp11_ = about_item, GTK_IS_MENU_ITEM (_tmp11_) ? ((GtkMenuItem*) _tmp11_) : NULL));
		_g_object_unref0 (separator);
		_g_object_unref0 (about_item);
		_g_object_unref0 (menu_item);
		_g_object_unref0 (image_item);
	}
	gtk_menu_set_screen (self->priv->_menu, NULL);
	gtk_menu_popup (self->priv->_menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
}


gboolean digital_clock_get_is_12_hour (DigitalClock* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_12_hour;
	return result;
}


void digital_clock_set_is_12_hour (DigitalClock* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_12_hour = value;
	g_object_notify ((GObject *) self, "is-12-hour");
}


gboolean digital_clock_get_show_date (DigitalClock* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_date;
	return result;
}


void digital_clock_set_show_date (DigitalClock* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_date = value;
	g_object_notify ((GObject *) self, "show-date");
}


gboolean digital_clock_get_date_before_time (DigitalClock* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_date_before_time;
	return result;
}


void digital_clock_set_date_before_time (DigitalClock* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_date_before_time = value;
	g_object_notify ((GObject *) self, "date-before-time");
}


const char* digital_clock_get_calendar_command (DigitalClock* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_calendar_command;
	return result;
}


void digital_clock_set_calendar_command (DigitalClock* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_calendar_command = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_calendar_command), _tmp0_);
	g_object_notify ((GObject *) self, "calendar-command");
}


const char* digital_clock_get_datetime_command (DigitalClock* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_datetime_command;
	return result;
}


void digital_clock_set_datetime_command (DigitalClock* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_datetime_command = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_datetime_command), _tmp0_);
	g_object_notify ((GObject *) self, "datetime-command");
}


static void digital_clock_class_init (DigitalClockClass * klass) {
	digital_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DigitalClockPrivate));
	G_OBJECT_CLASS (klass)->get_property = digital_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = digital_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = digital_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_IS_12_HOUR, g_param_spec_boolean ("is-12-hour", "is-12-hour", "is-12-hour", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_SHOW_DATE, g_param_spec_boolean ("show-date", "show-date", "show-date", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_DATE_BEFORE_TIME, g_param_spec_boolean ("date-before-time", "date-before-time", "date-before-time", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_CALENDAR_COMMAND, g_param_spec_string ("calendar-command", "calendar-command", "calendar-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_DATETIME_COMMAND, g_param_spec_string ("datetime-command", "datetime-command", "datetime-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void digital_clock_instance_init (DigitalClock * self) {
	self->priv = DIGITAL_CLOCK_GET_PRIVATE (self);
	self->priv->current_time = NULL;
	self->priv->prefs = NULL;
	self->priv->_show_date = TRUE;
	self->priv->_calendar_command = g_strdup (DIGITAL_CLOCK_EVOLUTION_COMMAND);
	self->priv->_datetime_command = g_strdup (DIGITAL_CLOCK_TIME_ADMIN_COMMAND);
}


static void digital_clock_finalize (GObject* obj) {
	DigitalClock * self;
	self = DIGITAL_CLOCK (obj);
	_g_object_unref0 (self->priv->_menu);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->time_overlay);
	_g_object_unref0 (self->priv->am_pm_overlay);
	_g_object_unref0 (self->priv->day_overlay);
	_g_object_unref0 (self->priv->date_overlay);
	_g_object_unref0 (self->priv->client);
	self->priv->current_time = (_vala_array_free (self->priv->current_time, self->priv->current_time_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->prefs);
	_g_free0 (self->priv->_calendar_command);
	_g_free0 (self->priv->_datetime_command);
	G_OBJECT_CLASS (digital_clock_parent_class)->finalize (obj);
}


GType digital_clock_get_type (void) {
	static volatile gsize digital_clock_type_id__volatile = 0;
	if (g_once_init_enter (&digital_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DigitalClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) digital_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DigitalClock), 0, (GInstanceInitFunc) digital_clock_instance_init, NULL };
		GType digital_clock_type_id;
		digital_clock_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "DigitalClock", &g_define_type_info, 0);
		g_once_init_leave (&digital_clock_type_id__volatile, digital_clock_type_id);
	}
	return digital_clock_type_id__volatile;
}


static void digital_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DigitalClock * self;
	self = DIGITAL_CLOCK (object);
	switch (property_id) {
		case DIGITAL_CLOCK_IS_12_HOUR:
		g_value_set_boolean (value, digital_clock_get_is_12_hour (self));
		break;
		case DIGITAL_CLOCK_SHOW_DATE:
		g_value_set_boolean (value, digital_clock_get_show_date (self));
		break;
		case DIGITAL_CLOCK_DATE_BEFORE_TIME:
		g_value_set_boolean (value, digital_clock_get_date_before_time (self));
		break;
		case DIGITAL_CLOCK_CALENDAR_COMMAND:
		g_value_set_string (value, digital_clock_get_calendar_command (self));
		break;
		case DIGITAL_CLOCK_DATETIME_COMMAND:
		g_value_set_string (value, digital_clock_get_datetime_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void digital_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DigitalClock * self;
	self = DIGITAL_CLOCK (object);
	switch (property_id) {
		case DIGITAL_CLOCK_IS_12_HOUR:
		digital_clock_set_is_12_hour (self, g_value_get_boolean (value));
		break;
		case DIGITAL_CLOCK_SHOW_DATE:
		digital_clock_set_show_date (self, g_value_get_boolean (value));
		break;
		case DIGITAL_CLOCK_DATE_BEFORE_TIME:
		digital_clock_set_date_before_time (self, g_value_get_boolean (value));
		break;
		case DIGITAL_CLOCK_CALENDAR_COMMAND:
		digital_clock_set_calendar_command (self, g_value_get_string (value));
		break;
		case DIGITAL_CLOCK_DATETIME_COMMAND:
		digital_clock_set_datetime_command (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	textdomain (GETTEXT_PACKAGE);
	result = (AwnApplet*) g_object_ref_sink (digital_clock_new (canonical_name, uid, panel_id));
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




