(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

open Gdk
open Gtk
open GObj

(* image viewer widget *)

let sync () = while Glib.Main.iteration false do () done;;

(* screen *)

let screen_width = Gdk.Screen.width ()
let screen_height = Gdk.Screen.height ()

(* progress bar *)

class new_progress_bar obj = object
  inherit GRange.progress_bar obj as super
  val mutable previous = 0.0
  method set_percentage x =
    let x = floor (x *. 10.0) /. 10.0 in
    if x = previous then ()
    else begin super#set_percentage x; sync () end
end;;

let new_progress_bar ?adjustment ?bar_style ?discrete_blocks
    ?activity_step ?activity_blocks ?value ?percentage ?activity_mode
    ?show_text ?format_string ?text_xalign ?text_yalign
    ?packing ?show () =
  let w =
    match adjustment with None -> GtkRange.ProgressBar.create ()
    | Some adj ->
	GtkRange.ProgressBar.create_with_adjustment (GData.as_adjustment adj)
  in
  GtkRange.ProgressBar.set w ?bar_style ?discrete_blocks
    ?activity_step ?activity_blocks;
  GtkRange.Progress.set w ?value ?percentage ?activity_mode
    ?show_text ?format_string ?text_xalign ?text_yalign;
  GObj.pack_return (new new_progress_bar w) ~packing ~show;;

(* the viewer *)

class viewer ?border_width ?width ?height ?packing ?show () =
  let fixed = GPack.fixed ?border_width ?width ?height ?packing ?show () in
  let prog = new_progress_bar ~packing: (fixed#put ~x:0 ~y:0)
      ~format_string: "" ~show_text: true () in
  let visual = prog#misc#visual
  in
  object
    inherit GPack.fixed (Obj.magic fixed#as_widget : Gtk.fixed obj)

    val colormap = Gdk.Color.get_system_colormap ()
    val color_create = Truecolor.color_creator visual
    val color_parser = Truecolor.color_parser visual

    val mutable previous_size = (-1,-1)

    method progress = prog

    method display (ximage : OXimage.ximage) =
      let pixmap =
	let win = fixed#misc#window in
	let pix = Gdk.Pixmap.create ~window: win
            ~depth: (Gdk.Visual.depth visual) 
            ~width: ximage#width
            ~height: ximage#height ()
	in
	let pixmap = new GDraw.drawable pix in
	pixmap#put_image ~x:0 ~y:0 
          ~width: ximage#width ~height: ximage#height
          ~xsrc:0 ~ysrc:0 
          ximage#data;
	pix
      in
      previous_size <- (ximage#width,ximage#height);
      fixed#misc#set_geometry ~width: ximage#width ~height: ximage#height ();
      Gdk.Window.set_back_pixmap fixed#misc#window (`PIXMAP pixmap);
      sync ()
end

let viewer ?border_width ?width ?height ?packing ?show () =
  new viewer ?border_width ?width ?height ?packing ?show ()
;;

