(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Franois Pessaux, projet Cristal, INRIA Rocquencourt     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* Interface of images from this library to images of the Caml
   [Graphics] library. *)

open Image;;

val draw_image : Image.t -> int -> int -> unit;;
 (* Draw an [Image.t] value into the graphic window. *)

val get_image : int -> int -> int -> int -> Rgb24.t
 (* Capture the contents of a rectangle of the graphic window
    with lower left corner at [x,y], width [w] and height [h] *)
 
(* lower interface *)

val array_of_image : Image.t -> Graphics.color array array;;
 (* Convert an [Image.t] value to an array of colors. *)

val of_image : Image.t -> Graphics.image;;
 (* Convert an [Image.t] value to a graphic image. *)

val image_of : Graphics.image -> Rgb24.t
 (* Convert an [Graphics.image] value to *our* image *)
