---------------------------- sal_lstruc.as ----------------------------------
--
-- This file defines linear structures
--
-- Copyright (c) Manuel Bronstein 1998
-- Copyright (c) INRIA 1998, Version 29-10-98
-- Logiciel Salli INRIA 1998, dans sa version du 29/10/1998
-----------------------------------------------------------------------------

#include "aldor"

macro Z == MachineInteger;

#if ALDOC
\thistype{LinearStructureType}
\History{Manuel Bronstein}{28/9/98}{created}
\Usage{\this~T: Category}
\Params{{\em T} & Type & the type of the entries\\}
\Descr{\this~is the category of linear structures whose entries are
of type T.}
\begin{exports}
\category{\altype{DataStructureType}}\\
\alexp{[]}: & \altype{Generator} T $\to$ \% & construction of a structure\\
\alexp{apply}:
& (\%, \altype{MachineInteger}) $\to$ T & extraction of an entry\\
\alexp{firstIndex}: & \altype{MachineInteger} & index of first element\\
\alexp{set!}:
& (\%, \altype{MachineInteger}, T) $\to$ T & modification of an entry\\
\end{exports}
\begin{exports}[if $T$ has \altype{PrimitiveType} then]
\alexp{equal?}:
& (\%, \%, \altype{MachineInteger}) $\to$ \altype{Boolean} &
compare the first $n$ elements\\
\end{exports}
#endif

define LinearStructureType(T:Type): Category == DataStructureType with {
	bracket: Generator T -> %;
#if ALDOC
\aspage{[]}
\Usage{[t for t in g]}
\Signature{\altype{Generator} T}{\%}
\Params{
{\em g} & \altype{Generator} T & an iterator producing elements of T\\
}
\Retval{Returns the structure
composed of all the elements generated by g in
the order in which they are generated.}
#endif
	apply: (%, Z) -> T;
#if ALDOC
\aspage{apply}
\Usage{\name(a, n)\\ a.n}
\Signature{(\%, \altype{MachineInteger})}{T}
\Params{
{\em a} & \% & a linear structure\\
{\em n} & \altype{MachineInteger} & an index\\
}
\Retval{Returns the element of $a$ with index $n$. The position
of that element depends on the indexing scheme of each actual type,
for example if it is $0$-indexed, then $a.n$ returns the ${(n+1)}^{{\rm st}}$
element of $a$, while if it is $1$-indexed, then $a.n$ returns the
$\sth{n}$ element of $a$.}
\Remarks{Bound checking depends on the actual type, some perform it and
some do not.}
#endif
	firstIndex: Z;
#if ALDOC
\aspage{firstIndex}
\Usage{\name}
\alconstant{\altype{MachineInteger}}
\Retval{Returns the index of the first element of a structure.}
#endif
	set!: (%, Z, T) -> T;
#if ALDOC
\aspage{set!}
\Usage{\name(a, n, x)\\ a.n := x; }
\Signature{(\%, \altype{MachineInteger}, T)}{T}
\Params{
{\em a} & \% & a linear structure\\
{\em n} & \altype{MachineInteger} & an index\\
{\em x} & T & an entry\\
}
\Descr{Sets the element of $a$ with index $n$ to $x$ and returns $x$.
The position of that element depends on the indexing scheme of each actual
type, for example if it is $0$-indexed, then $a.n := x$ sets the
${(n+1)}^{{\rm st}}$
element of $a$, while if it is $1$-indexed, then $a.n := x$ sets the
$\sth{n}$ element of $a$.}
\Remarks{Bound checking depends on the actual type, some perform it and
some do not.}
#endif
	if T has PrimitiveType then {
		equal?: (%, %, Z) -> Boolean;
#if ALDOC
\aspage{equal?}
\Usage{\name(a, b, n)}
\Signature{(\%, \%, \altype{MachineInteger})}{\altype{Boolean}}
\Params{
{\em a, b} & \% & linear structures\\
{\em n} & \altype{MachineInteger} & a nonnegative integer\\
}
\Retval{Returns~\true if the first $n$ elements of $a$ and $b$ are
all equal, \false otherwise.}
\Remarks{$a$ and $b$ must both have at least $n$ elements.}
#endif
	}
}

