/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst;

// Taken from Effective Java
// Ordinal-based typesafe enum - Page 106, serializable as per Page 107

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Enumeration for all Transmission commands
 *
 * @author Adrian Pronk
 * @version 1
 */

public class ELog implements Comparable, Serializable
{
  // Unique SerialVersionUID (should NEVER change)
  static final long serialVersionUID = 0L;

  private final int level;
  private final transient String[] names;

  // Ordinal of next type to be created
  private static int nextOrdinal = 0;

  // Assign an ordinal to this type
  private final int ordinal = nextOrdinal++;

  public static final ELog DEBUG   = new ELog(7,"DEBUG");
  public static final ELog INFO    = new ELog(6,"INFO INFORMATION");
  public static final ELog NOTICE  = new ELog(5,"NOTICE");
  public static final ELog WARNING = new ELog(4,"WARNING");
  public static final ELog ERROR   = new ELog(3,"ERROR");
  public static final ELog CRITICAL= new ELog(2,"CRITICAL");
  public static final ELog ALERT   = new ELog(1,"ALERT");
  public static final ELog FATAL   = new ELog(0,"FATAL EMERGENCY");

  // Exporting constants - Page 106
  private static final ELog[] PRIVATE_VALUES =
      { DEBUG, INFO, NOTICE, WARNING, ERROR, CRITICAL, ALERT, FATAL };

  public static final List VALUES =
      Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

  public static final Map BY_NAME = new HashMap();
  static
  {
    for (int i = 0; i < PRIVATE_VALUES.length; ++i)
    {
      ELog elog = PRIVATE_VALUES[i];

      for (int j = 0; j < elog.names.length; ++j)
        BY_NAME.put(elog.names[j].toUpperCase(), elog);
    }
  }

  private ELog(int level, String name)
  {
    this.level = level;
    this.names = Util.split(name);
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer("ELog[" + names[0]);
    for (int i = 1; i < names.length; ++i)
      sb.append("/" + names[i]);
    sb.append(']');
    return sb.toString();
  }

  public int compareTo(Object o)
  {
    return ordinal - ((ELog)o).ordinal;
  }

  public boolean lessThan(Object o)
  {
    return compareTo(o) < 0;
  }

  public boolean greaterThan(Object o)
  {
    return compareTo(o) > 0;
  }

  private Object readResolve() throws ObjectStreamException {
      return PRIVATE_VALUES[ordinal]; // Canonicalize
  }

  public String getName()
  {
    return names[0];
  }

  public static ELog getByName(String name)
  {
    return (ELog) BY_NAME.get(name.toUpperCase());
  }
}
