/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;


/**
 *
 * @author  hamish
 */
public class SequentialControl_single_rin {
    
    public static long startTime       = 0L;
    
    public static int  timeToRun         = 2; //in seconds
    public static int  thread_count      = 2;
    public static int  errorCount        = 0;
    public static boolean run            = true;
    public static int  requestsCompleted = 0;
    
    public static int  threadsRunning  = thread_count;
    public static long threadTime      = 0L;
    
    public static String [] queries = {
            // ~0 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: (Name:pepper  ^1) OR (Teaser:pepper) OR (Details:pepper) AND (Cancelled:N)\nLimit: 5\nEND",
            // ~ 100 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",  
            // ~ 100 results (WITH SORT)
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nSort: Name\nLimit: 5\nEND",  
            // ~ 1000 results  
            "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nLimit: 5\nEND",
            // ~ 1000 results  (WITH SORT)
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nSort: Name\nLimit: 5\nEND",
            // ~ 10000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-06-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // ~ 20000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // all results
            //"QUERY\nApplication: sos\nQuery: \nQuery: Domain:sos\nLimit: 5\nEND"
    };
    
    
    /** Creates a new instance of SocketTest */
    public SequentialControl_single_rin() {
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        SequentialControl sc = new SequentialControl();
        sc.go();
    }
        
    public void go() {
        
      for (int timespan = 1; timespan < 11; timespan++) {
        
        timeToRun         = timespan; //in seconds
        errorCount        = 0;
        run            = true;
        requestsCompleted = 0;
        threadsRunning  = thread_count;
        threadTime      = 0L;

          
        System.out.println("============= Sequential Stress Test ==============");
        System.out.println(" Time to run test over: " + timeToRun + " second(s)");
        System.out.println(" Threads To Spawn:      " + thread_count);
        System.out.println("===================================================");
      
        startTime = System.currentTimeMillis();

        java.util.Random r = new java.util.Random();
         
        for (int i = 0; i < thread_count; i++) {
            int query_number = r.nextInt(queries.length);
            Thread t = new Thread(new SequentialClient(("T"+i), query_number, 0));
            t.start();
        }
        
        synchronized (this) {
                        try {
                this.wait(1000 * timeToRun);
                        } catch (Exception e) { /*do nothing */ }
        }

        run = false;
       
        while (threadsRunning > 0) {
            synchronized (this) {
                            try {
                    this.wait(500);
                            } catch (Exception e) { /*do nothing */ }
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
       
        System.out.println("============= STATISTICS ==============");
        System.out.println(" Time to run test over: " + timeToRun + " second(s).");
        System.out.println(" Actual Time Test ran:  " + totalTime);
        System.out.println(" Threads Spawned:       " + thread_count);
        System.out.println(" Requests Completed:    " + requestsCompleted);
        System.out.println(" ");
        System.out.println("Total Time:             " + threadTime + "   (should be approx TimeToRun * Threads)");
        System.out.println("Average time:           " + (threadTime / requestsCompleted));
        System.out.println("Throughput:             " + (double) ((requestsCompleted) / (totalTime/1000d)) + " (requests per second)");
        System.out.println("Error Count:             " + errorCount);
        System.out.println("============= STATISTICS ==============");
    
      }
    }
}
