#!/bin/bash

# Sanity check..
if [ ! -d debian ] ; then
  echo "you are not in a debian packaging directory!"
  exit 1
fi

# Allow user override
if [ "$1" != "" ]
then
  USER=$1
fi

# Build debian package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
USER=${1:-"${DEBFULLNAME} <${DEBEMAIL}>"}
if [ "$USER" = "" -o "$USER" = " " -o "$USER" = " <>" ] ; then
  USER=`dpkg-parsechangelog | sed -n 's/^Maintainer: //p'`
fi
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# Go to build area..
HOMEDIR=`pwd`
cd ../debian-builds

# Packages to upload; list all to upload here (normally just the one).
UPLOAD_PKGS="${PACKAGE}"

# Upload all packages..
for PKG in $UPLOAD_PKGS ; do
  if [ -d ${PKG} ] ; then
    echo "uploading version ${VERSION} of ${PKG}"
    cd $PKG
    if [ -f ${PKG}_${VERSION}_i386.changes ] ; then
      echo "package found: ${PKG}_${VERSION}_i386.changes"
      echo -n "upload it? [yN] : "
      read ANS
      if [ "$ANS" = "y" ] ; then
        dupload --to anonymous-ftp-master ${PKG}_${VERSION}_i386.changes
      fi
    else
      echo "no changes file ${PKG}_${VERSION}_i386.changes found!"
    fi
    cd ..
  else
    echo "package ${PKG} does not have a build directory!"
    exit 2
  fi
done

# ENDS 
