/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.net.catalyst.lucene.testclient.StressControl;

public class StressClient
implements Runnable {
    String name = "";
    int query_number = 0;
    int delay = 0;

    public StressClient(String name, int query_number, int delay) {
        this.name = name;
        this.query_number = query_number;
        this.delay = delay;
    }

    public void run() {
        block12: {
            long tStart = System.currentTimeMillis();
            long tOpenedConnection = 0L;
            long tAfterExecuting = 0L;
            long tClosedConnection = 0L;
            try {
                try {
                    String serverOutput;
                    if (this.delay > 0) {
                        StressClient stressClient = this;
                        synchronized (stressClient) {
                            try {
                                this.wait(this.delay);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss S");
                    String output = sdf.format(new Date());
                    Socket echoSocket = null;
                    PrintWriter out = null;
                    BufferedReader in = null;
                    echoSocket = new Socket("localhost", 22222);
                    out = new PrintWriter(echoSocket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
                    tOpenedConnection = System.currentTimeMillis();
                    String query = StressControl.queries[this.query_number];
                    output = String.valueOf(output) + "\tThread: " + this.name + " query: " + this.query_number;
                    out.println(query);
                    BufferedReader br = new BufferedReader(in);
                    while ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END")) {
                        if (!serverOutput.startsWith("Count:")) continue;
                        output = String.valueOf(output) + "\t" + serverOutput + "\t";
                    }
                    tAfterExecuting = System.currentTimeMillis();
                    out.close();
                    in.close();
                    echoSocket.close();
                    tClosedConnection = System.currentTimeMillis();
                    output = String.valueOf(output) + "\to: " + (tOpenedConnection - tStart);
                    output = String.valueOf(output) + "\te: " + (tAfterExecuting - tOpenedConnection);
                    output = String.valueOf(output) + "\tc: " + (tClosedConnection - tAfterExecuting);
                    output = String.valueOf(output) + "\tt: " + (tAfterExecuting - tStart);
                    System.out.println(output);
                    StressControl.threadTime += tAfterExecuting - tStart;
                }
                catch (Exception e) {
                    System.err.println("Thread: " + this.name + ": Couldn't get I/O for the connection or connection dropped.");
                    ++StressControl.errorCount;
                }
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                if (--StressControl.threadCountDown <= 0) {
                    StressControl.printStats();
                }
                throw throwable;
            }
            Object var17_17 = null;
            if (--StressControl.threadCountDown > 0) break block12;
            StressControl.printStats();
        }
    }
}

