/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.cache.IndexSearcherCache;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.DateField;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.QueryException;
import nz.net.catalyst.lucene.server.RangeDef;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.WriterControl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

public class Query
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    Query(Transmission transmission) {
        this.input = transmission;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Transmission execute() {
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            queryStart = System.currentTimeMillis();
                            response = new Transmission(ECommand.QUERY_RESPONSE);
                            response.setSerial(this.input.getSerial());
                            appName = this.input.get("Application", Constants.NO_APP);
                            try {
                                this.application = Application.getAppOrDefault(appName);
                            }
                            catch (ApplicationMissingException e) {
                                return this.error(e.getMessage());
                            }
                            this.input.setApplication(this.application);
                            analyzer = Application.getAnalyzer(this.input);
                            defaultField = this.input.get("Default-Field");
                            if (defaultField == null) {
                                defaultField = "UNDEFINED_FIELD";
                            }
                            fieldMap = this.mapFields(this.input.getFields());
                            beforeParse = System.currentTimeMillis();
                            try {
                                query = this.buildQuery(analyzer, defaultField, fieldMap);
                            }
                            catch (QueryException e) {
                                return this.error(e.getMessage());
                            }
                            beforeOpenSearcher = System.currentTimeMillis();
                            luceneStoreDir = Application.getIndexDirectory(this.application);
                            searcher = null;
                            returnFields = this.getReturnFields(fieldMap);
                            try {
                                try {
                                    exceptionMessage = "closing idle IndexWriter";
                                    WriterControl.closeIdleWriter(luceneStoreDir);
                                    exceptionMessage = "opening Index";
                                    try {
                                        isc = IndexSearcherCache.getInstance(luceneStoreDir);
                                        searcher = isc.getSearcher();
                                    }
                                    catch (IOException e) {
                                        Log.error("Query performed on non-existing index!");
                                        Log.error("An index needs to have at least one document successfully indexed before Querying.");
                                        Log.error(e.getMessage());
                                        message = "Error during query: Index not found. Index documents first or check settings.";
                                        Log.error(message);
                                        var41_23 = this.error(message);
                                        var39_31 = null;
                                        if (searcher == null) return var41_23;
                                        try {
                                            searcher.close();
                                            return var41_23;
                                        }
                                        catch (Throwable e) {
                                            message = "Error while closing IndexReader: " + e.toString();
                                            Log.error(message);
                                        }
                                        return var41_23;
                                    }
                                    beforeSearch = System.currentTimeMillis();
                                    exceptionMessage = "searching Index";
                                    hits = searcher.search(query);
                                    hitCount = hits.length();
                                    Log.debug("Found " + hitCount + " results in " + (System.currentTimeMillis() - beforeSearch) + "ms");
                                    limit = -1;
                                    try {
                                        limit = Integer.parseInt(this.input.get("Limit"));
                                        if (limit < 0) {
                                            limit = -1;
                                        }
                                    }
                                    catch (Exception var26_63) {
                                        // empty catch block
                                    }
                                    first = 1;
                                    try {
                                        first = Integer.parseInt(this.input.get("First"));
                                        if (first < 1) {
                                            first = 1;
                                        }
                                    }
                                    catch (Exception var27_65) {
                                        // empty catch block
                                    }
                                    --first;
                                    beforeSort = System.currentTimeMillis();
                                    docs = null;
                                    sortList = this.getSortList();
                                    if (sortList != null) {
                                        sortLimitSystem = -1;
                                        sortLimitUser = -1;
                                        try {
                                            sortLimitSystem = Integer.parseInt(System.getProperty(String.valueOf(IPackage.PACKAGE) + "SortLimitSystem"));
                                            sortLimitUser = Integer.parseInt(this.input.get("Sort-Limit"));
                                        }
                                        catch (NumberFormatException var31_71) {
                                            // empty catch block
                                        }
                                        Log.debug("sortLimitSystem: " + sortLimitSystem);
                                        Log.debug("sortLimitUser: " + sortLimitUser);
                                        if (sortLimitSystem != -1 && sortLimitUser > sortLimitSystem) {
                                            sortLimitUser = sortLimitSystem;
                                            Log.debug("Resetting Sort-Limit sent from client because was greater than the system sort limit. Sort-Limit=" + sortLimitUser + " Sort-Limit=" + sortLimitUser);
                                        }
                                        if (sortLimitUser != -1 && limit > sortLimitUser) {
                                            sortLimitUser = -1;
                                            Log.debug("Ignoring Sort-Limit sent from client because it is less than their specified limit. Limit=" + limit + " Sort-Limit=" + sortLimitUser);
                                        }
                                        if (sortLimitUser != -1 && hitCount > sortLimitUser) {
                                            Log.debug("Number of results exceeds user sort limit. HitCount=" + hitCount + " Sort-Limit=" + sortLimitUser);
                                            var41_24 = this.error("Number of results exceeds user sort limit. Please restrict search or do not sort results.");
                                            var39_32 = null;
                                            if (searcher == null) return var41_24;
                                            break block55;
                                        }
                                        if (sortLimitSystem != -1 && hitCount > sortLimitSystem) {
                                            Log.debug("Number of results exceeds system sort limit. HitCount=" + hitCount + " System Sort-Limit=" + sortLimitSystem);
                                            var41_25 = this.error("Number of results exceeds system sort limit. Please restrict search or do not sort results.");
                                            break block56;
                                        }
                                        if (Log.isDebugEnabled()) {
                                            Log.debug("Sort override requested -- will retrieve all matching documents into memory for sorting.");
                                            sb = new StringBuffer();
                                            i = 0;
                                            while (true) {
                                                if (i >= sortList.length) {
                                                    Log.debug("Sort order is: " + sb);
                                                    break;
                                                }
                                                if (i > 0) {
                                                    sb.append(", ");
                                                }
                                                sb.append(sortList[i].field == null ? "RANK" : sortList[i].field);
                                                sb.append(':');
                                                sb.append(sortList[i].descending != false ? "Desc" : "Asc");
                                                ++i;
                                            }
                                        }
                                        docs = new SortObject[hitCount];
                                        exceptionMessage = "building sort keys";
                                        beforeResultsRetrieve = System.currentTimeMillis();
                                        Log.debug("about to put result set into array for sorting");
                                        i = 0;
                                        while (true) {
                                            if (i >= hitCount) {
                                                afterResultsRetrieve = System.currentTimeMillis();
                                                Log.debug("Time taken to retrieve results into docs array: " + (afterResultsRetrieve - beforeResultsRetrieve) + "ms.");
                                                comparator = new DocCompare(sortList);
                                                try {
                                                    exceptionMessage = "sorting results";
                                                    Arrays.sort(docs, comparator);
                                                    break;
                                                }
                                                catch (QueryException e) {
                                                    var41_26 = this.error("Ran out of memory while sorting " + hitCount + " search results.  Please restrict search or do not sort them.");
                                                    var39_34 = null;
                                                    if (searcher == null) return var41_26;
                                                    ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl145:
                                                    // 1 sources

                                                    searcher.close();
                                                    return var41_26;
lbl147:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        message = "Error while closing IndexReader: " + e.toString();
                                                        Log.error(message);
                                                    }
                                                    return var41_26;
                                                }
                                                catch (OutOfMemoryError e) {
                                                    Log.error("OutOfMemoryError - while sorting " + hitCount + " documents.");
                                                    var41_27 = this.error("Ran out of memory while sorting " + hitCount + " search results.  Please restrict search or do not sort them.");
                                                    var39_35 = null;
                                                    if (searcher == null) return var41_27;
                                                    ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl158:
                                                    // 1 sources

                                                    searcher.close();
                                                    return var41_27;
lbl160:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        message = "Error while closing IndexReader: " + e.toString();
                                                        Log.error(message);
                                                    }
                                                    return var41_27;
                                                }
                                            }
                                            docs[i] = this.makeSortObject(sortList, hits, i);
                                            ++i;
                                        }
                                        afterSort = System.currentTimeMillis();
                                        Log.debug("Sort took (in ms):" + (afterSort - beforeSort));
                                    }
                                    beforeOutput = System.currentTimeMillis();
                                    exceptionMessage = "retrieving results";
                                    last = first + limit;
                                    response.add("Count", String.valueOf(hitCount));
                                    i = first;
                                    block34: while (i != last && i < hitCount) {
                                        index = i;
                                        if (docs != null) {
                                            sort = docs[i];
                                            if (sort == null) {
                                                var41_28 = this.error("Ran out of memory while retrieving sorted documents after sorting " + hitCount + " search results.  Please restrict search " + "or do not sort them.");
                                                break block57;
                                            }
                                            index = sort.index;
                                        }
                                        d = hits.doc(index);
                                        score = hits.score(index);
                                        response.add("I", String.valueOf(i + 1));
                                        response.add("RANK", String.valueOf(score));
                                        fld = returnFields.iterator();
                                        while (true) {
                                            if (!fld.hasNext()) {
                                                ++i;
                                                continue block34;
                                            }
                                            returnField = (FieldDef)fld.next();
                                            value = d.get(returnField.name);
                                            if (value == null) {
                                                value = "";
                                            } else if (returnField.date) {
                                                try {
                                                    msec = DateField.stringToTime(value);
                                                    value = String.valueOf(msec / 1000L);
                                                }
                                                catch (NumberFormatException e) {
                                                    errorMsg = "Invalid Timestamp for datefield:" + returnField.name + ". " + e.getMessage();
                                                    Log.error(errorMsg);
                                                    var41_29 = this.error(errorMsg);
                                                    var39_37 = null;
                                                    if (searcher == null) return var41_29;
                                                    ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl210:
                                                    // 1 sources

                                                    searcher.close();
                                                    return var41_29;
lbl212:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        message = "Error while closing IndexReader: " + e.toString();
                                                        Log.error(message);
                                                    }
                                                    return var41_29;
                                                }
                                            }
                                            response.add(returnField.name, value);
                                        }
                                    }
                                    break block58;
                                }
                                catch (IOException e) {
                                    message = "Error during query: " + e.toString();
                                    Log.error(message);
                                    var41_30 = this.error(message);
                                    var39_38 = null;
                                    if (searcher == null) return var41_30;
                                    ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl227:
                                    // 1 sources

                                    searcher.close();
                                    return var41_30;
lbl229:
                                    // 1 sources

                                    catch (Throwable e) {
                                        message = "Error while closing IndexReader: " + e.toString();
                                        Log.error(message);
                                    }
                                    return var41_30;
                                }
                            }
                            catch (Throwable var40_91) {
                                var39_39 = null;
                                if (searcher == null) throw var40_91;
                                ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl238:
                                // 1 sources

                                searcher.close();
                                throw var40_91;
lbl240:
                                // 1 sources

                                catch (Throwable e) {
                                    message = "Error while closing IndexReader: " + e.toString();
                                    Log.error(message);
                                }
                                throw var40_91;
                            }
                        }
                        ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl246:
                        // 1 sources

                        searcher.close();
                        return var41_24;
lbl248:
                        // 1 sources

                        catch (Throwable e) {
                            message = "Error while closing IndexReader: " + e.toString();
                            Log.error(message);
                        }
                        return var41_24;
                    }
                    var39_33 = null;
                    if (searcher == null) return var41_25;
                    ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl256:
                    // 1 sources

                    searcher.close();
                    return var41_25;
lbl258:
                    // 1 sources

                    catch (Throwable e) {
                        message = "Error while closing IndexReader: " + e.toString();
                        Log.error(message);
                    }
                    return var41_25;
                }
                var39_36 = null;
                if (searcher == null) return var41_28;
                ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl266:
                // 1 sources

                searcher.close();
                return var41_28;
lbl268:
                // 1 sources

                catch (Throwable e) {
                    message = "Error while closing IndexReader: " + e.toString();
                    Log.error(message);
                }
                return var41_28;
            }
            var39_40 = null;
            if (searcher != null) {
                ** try [egrp 10[TRYBLOCK] [11 : 1473->1483)] { 
lbl276:
                // 1 sources

                searcher.close();
                break block59;
lbl278:
                // 1 sources

                catch (Throwable e) {
                    message = "Error while closing IndexReader: " + e.toString();
                    Log.error(message);
                }
            }
        }
        end = System.currentTimeMillis();
        Log.debug("ReadQuery:" + String.valueOf(beforeParse - queryStart));
        Log.debug("Parse/BuildQuery:" + String.valueOf(beforeOpenSearcher - beforeParse));
        Log.debug("OpenSearcher:" + String.valueOf(beforeSearch - beforeOpenSearcher));
        Log.debug("Search: " + String.valueOf(beforeSort - beforeSearch));
        Log.debug("Sort: " + String.valueOf(beforeOutput - beforeSort));
        Log.debug("Output: " + String.valueOf(end - beforeOutput));
        return response;
    }

    private org.apache.lucene.search.Query buildQuery(Analyzer a, String field, Map fieldMap) {
        try {
            int clauseLimitSystem = Integer.parseInt(System.getProperty(String.valueOf(IPackage.PACKAGE) + "ClauseLimitSystem"));
            BooleanQuery.setMaxClauseCount((int)clauseLimitSystem);
            Log.debug("setting max clause count to:" + clauseLimitSystem);
        }
        catch (NumberFormatException e) {
            Log.error("invalid setting for ClauseLimitSystem:" + System.getProperty(String.valueOf(IPackage.PACKAGE) + "ClauseLimitSystem"));
        }
        QueryParser qp = new QueryParser(field, a);
        BooleanQuery result = new BooleanQuery();
        boolean anyTerms = false;
        String domain = this.input.get("Domain");
        if (domain != null) {
            Term domainSearch = new Term("Domain", domain);
            result.add((org.apache.lucene.search.Query)new TermQuery(domainSearch), true, false);
            anyTerms = true;
        }
        String query = this.input.get("Query");
        Log.debug("Query (Unparsed): " + query);
        if (query != null) {
            try {
                result.add(qp.parse(query), true, false);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query: " + query);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query \"" + query + "\"", e);
            }
            catch (ParseException e) {
                Log.warn("Error parsing query: " + query);
                Log.info(e.getMessage());
                BooleanClause[] b = result.getClauses();
                Log.error(" Number of clauses before error: " + b.length);
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
            catch (TokenMgrError e) {
                Log.warn("Error parsing query: " + query);
                Log.info(e.getMessage());
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
        }
        Iterator it = this.getRangeQueries(fieldMap).iterator();
        while (it.hasNext()) {
            org.apache.lucene.search.Query theRange = null;
            try {
                theRange = (org.apache.lucene.search.Query)it.next();
                result.add(theRange, true, false);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query when adding range: " + theRange);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query when adding range \"" + theRange + "\"", e);
            }
        }
        if (!anyTerms) {
            throw new QueryException("No search expression!");
        }
        if (Log.willDebug()) {
            Log.debug("Query (Parsed):   " + result.toString(""));
            BooleanClause[] b = result.getClauses();
            Log.debug(" Number of clauses in query: " + b.length);
        }
        return result;
    }

    private Map mapFields(List fieldList) {
        HashMap<String, FieldDef> result = new HashMap<String, FieldDef>();
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            FieldDef field = (FieldDef)it.next();
            result.put(field.name, field);
        }
        return result;
    }

    private List getReturnFields(Map fieldMap) {
        List<String> requestedFields = Arrays.asList(this.input.get("Return", Constants.USE_APP, Constants.SPLIT));
        LinkedList<String> returnFields = new LinkedList<String>(requestedFields);
        if (!returnFields.contains("Id")) {
            returnFields.add(0, "Id");
        }
        LinkedList<FieldDef> result = new LinkedList<FieldDef>();
        Iterator it = returnFields.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            FieldDef field = (FieldDef)fieldMap.get(name);
            if (field == null) {
                field = new FieldDef(name);
            }
            result.add(field);
        }
        return result;
    }

    private List getRangeQueries(Map fieldMap) {
        LinkedList<RangeQuery> result = new LinkedList<RangeQuery>();
        Iterator it = this.input.getRanges().iterator();
        while (it.hasNext()) {
            RangeDef range = (RangeDef)it.next();
            if (range.from == null && range.to == null) {
                throw new QueryException("Missing From or To value for Range field." + range.name);
            }
            FieldDef field = (FieldDef)fieldMap.get(range.name);
            boolean date = field != null && field.date;
            try {
                String from = range.from;
                if (date && from != null) {
                    from = DateField.dateToString(Application.makeDate(from));
                }
                String to = range.to;
                if (date && to != null) {
                    to = DateField.dateToString(Application.makeDate(to));
                }
                result.add(new RangeQuery(from == null ? null : new Term(range.name, from), to == null ? null : new Term(range.name, to), true));
            }
            catch (IllegalArgumentException e) {
                throw new QueryException("Error in range field \"" + range.name + "\": " + e.getMessage());
            }
        }
        return result;
    }

    private Sort[] getSortList() {
        String[] fieldSpecs = this.input.get("Sort", Constants.USE_APP, Constants.SPLIT);
        if (fieldSpecs.length == 0) {
            return null;
        }
        Sort[] result = new Sort[fieldSpecs.length];
        int i = 0;
        while (i < result.length) {
            String[] subSpec = Util.split(fieldSpecs[i], ":");
            if (subSpec.length < 1 || subSpec.length > 2) {
                throw new QueryException("Invalid sort spec: \"" + this.input.get("Sort") + '\"');
            }
            String field = subSpec[0];
            if (field.equals("RANK")) {
                field = null;
            }
            boolean descending = false;
            if (subSpec.length == 2) {
                String direction = subSpec[1].toLowerCase();
                if (direction.startsWith("d")) {
                    Log.debug("Setting sort order for field(" + field + ") to descending.");
                }
                descending = true;
            }
            result[i] = new Sort(field, descending);
            ++i;
        }
        if (result.length == 1 && result[0].field == null && !result[0].descending) {
            Log.debug("Sort term specified was default term.  Ignoring sort request.");
            return null;
        }
        return result;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.QUERY_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }

    private SortObject makeSortObject(Sort[] sortList, Hits hits, int index) throws IOException {
        SortObject result = new SortObject(index, sortList.length);
        Document d = hits.doc(index);
        int i = 0;
        while (i < sortList.length) {
            if (sortList[i].field == null) {
                result.key[i] = new Float(hits.score(index));
            } else {
                String key = d.get(sortList[i].field);
                if (key == null) {
                    key = "";
                }
                result.key[i] = key;
            }
            ++i;
        }
        return result;
    }

    private static class DocCompare
    implements Comparator {
        Sort[] sortList;

        DocCompare(Sort[] sortList) {
            this.sortList = sortList;
        }

        public int compare(Object objA, Object objB) {
            SortObject a = (SortObject)objA;
            SortObject b = (SortObject)objB;
            if (a == null || b == null) {
                throw new QueryException("Not enough memory to hold all results");
            }
            int i = 0;
            while (i < a.key.length) {
                int result = a.key[i].compareTo(b.key[i]);
                if (result != 0) {
                    if (this.sortList[i].descending) {
                        result = -result;
                    }
                    return result;
                }
                ++i;
            }
            return 0;
        }
    }

    private static class SortObject {
        final int index;
        final Comparable[] key;

        SortObject(int index, int keyCount) {
            this.index = index;
            this.key = new Comparable[keyCount];
        }
    }

    private static class Sort {
        final String field;
        final boolean descending;

        Sort(String field, boolean descending) {
            this.field = field;
            this.descending = descending;
        }
    }
}

