/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.NumberFunction;

public class SumFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            return SumFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("sum() requires one argument.");
    }

    public static Double evaluate(Object obj, Navigator nav) {
        double sum = 0.0;
        double term = 0.0;
        if (obj instanceof List) {
            Iterator nodeIter = ((List)obj).iterator();
            while (nodeIter.hasNext()) {
                term = NumberFunction.evaluate(nodeIter.next(), nav);
                sum += term;
            }
        } else {
            sum += NumberFunction.evaluate(obj, nav).doubleValue();
        }
        return new Double(sum);
    }
}

