/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */
 

package nz.net.catalyst.lucene.testclient;


/**
 *
 * @author  hamish
 */
public class SequentialControl {
    
    public static long startTime       = 0L;
    
    public static int  timeToRun         = 1; //in seconds
	public static int  repeatCount       = 10; //no of times to repeat for each query
    public static int  thread_count      = 1;
    public static int  errorCount        = 0;
    public static boolean run            = true;
    public static int  requestsCompleted = 0;
    
    public static int  threadsRunning  = thread_count;
    public static long threadTime      = 0L;
    
    public static String [] queries = {
        //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1990/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: (Name:(goo*^2 OR plan*^2) Teaser:(goo* OR plan*) Details:(goo* OR plan*)) AND NOT (Cancel:Y)\nLimit: 5\nEND"
        
    	//"QUERY\nApplication: sos\nLimit: 1\nSort: DisplayStartDate\nRange-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2002-04-01\nQuery: Cancelled:Y\nEND\n"
    	
    	"QUERY\n" +
    							 "Application: nqst\n" +
    							 //"Query: category:sport\n" +
    							"Field-Name: date\n" +
    							"Field-Type: Date\n" +
    							"Field-Indexed: Yes\n" +
    							"Field-Stored: No\n" +
    							 "Range-Field: date\n" +
    							 "Range-From: 2002-02-16\n" +
    							//"Range-To: 2003-01-16\n" +
    							 //"Limit: 1000000\n" +
    							 "Query: Text:snow\n" +
    							"Limit: 100\n" +
    							 "Sort: date:dsc\n"+ //Newest documents first (adds performance AND memory overhead).
    							//"Sort: Id:dsc\n"+
    							 "END\n"
    	
    	
    	//"<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneRequest type=\"QUERY\"><Application>sos</Application><Query>Name:cat</Query><Limit>3</Limit></LuceneRequest>"
        
/*    	
    	//56 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Location:11 +Location:12 +Location:13 +Location:14\nLimit: 5\nSort: Name EndDate Teaser\nEND",
    	//112 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Category:12 +Category:10 +Details:him +Location:16 +Name:\"cat\"\nLimit: 0\nSort: Name EndDate Teaser\nEND",
    	//472 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Category:13 +Details:god +Location:16 +Name:\"dvd\"\nLimit: 0\nSort: Name EndDate Teaser\nEND",
    	//1044 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Location:12 +Location:13 +Name:red +Location:12\nLimit: 0\nSort: Name EndDate Teaser\nEND",
    	//5191 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Teaser:just +Details:god +Location:14 \nLimit: 0\nSort: Name EndDate Teaser\nEND",
    	//9109 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Details:every +Location:11\nLimit: 0\nSort: Name EndDate Teaser\nEND",
    	//25,000 results
    	"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" + "Query: +Name:\"cat\"\nLimit: 0\nSort: Name EndDate Teaser\nEND"
*/

            // ~0 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: (Name:pepper  ^1) OR (Teaser:pepper) OR (Details:pepper) AND (Cancelled:N)\nLimit: 5\nEND",
            // ~ 100 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",  
            // ~ 100 results (WITH SORT)
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nSort: Name\nLimit: 5\nEND",  
            // ~ 1000 results  
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nLimit: 5\nEND",
            // ~ 1000 results  (WITH SORT)
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nSort: Name\nLimit: 5\nEND",
            // ~ 10000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-06-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // ~ 20000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // all results
            //"QUERY\nApplication: sos\nQuery: \nQuery: Domain:sos\nLimit: 5\nEND"
    };
    
    
    /** Creates a new instance of SocketTest */
    public SequentialControl() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        SequentialControl sc = new SequentialControl();
        sc.go();
    }
        
    public void go() {
        System.out.println("============= STATISTICS ==============");
        System.out.println("Time\tThreads\tCompl\tAvgTime\tThroughput");
      //for (int numthreads = 5; numthreads < 20; numthreads+=2) {
      //   thread_count = numthreads;
      int query_number = 0;
      for (;query_number< queries.length; query_number++) {
      	System.out.println("Query Number: "+query_number);
      for (int repeatCounter = 1; repeatCounter <= repeatCount; repeatCounter++) {
        //System.out.print("about to pause for 2 seconds...");
        synchronized (this) {
                        try {
                this.wait(2000);
                        } catch (Exception e) { /*do nothing */ }
        }
        //System.out.println("now running tests...");  
          
        errorCount        = 0;
        run            = true;
        requestsCompleted = 0;
        threadsRunning  = thread_count;
        threadTime      = 0L;
        
        startTime = System.currentTimeMillis();

        java.util.Random r = new java.util.Random();
         
        for (int i = 0; i < thread_count; i++) {
            //int query_number = r.nextInt(queries.length);
            Thread t = new Thread(new SequentialClient(("T"+i), query_number, 0));
            t.start();
        }
        
        synchronized (this) {
                        try {
                this.wait(1000 * timeToRun);
                        } catch (Exception e) { /*do nothing */ }
        }

        run = false;
       
        while (threadsRunning > 0) {
            synchronized (this) {
                            try {
                    this.wait(500);
                            } catch (Exception e) { /*do nothing */ }
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
       
        System.out.println(timeToRun + "\t" + thread_count + "\t" + requestsCompleted + "\t" + (threadTime / requestsCompleted) + "\t" + ((requestsCompleted) / (totalTime/1000d)));
        /*
        System.out.println(" Time to run test over: " + timeToRun + " second(s).");
        System.out.println(" Actual Time Test ran:  " + totalTime);
        System.out.println(" Threads Spawned:       " + thread_count);
        System.out.println(" Requests Completed:    " + requestsCompleted);
        System.out.println(" ");
        System.out.println("Total Time:             " + threadTime + "   (should be approx TimeToRun * Threads)");
        System.out.println("Average time:           " + (threadTime / requestsCompleted));
        System.out.println("Throughput:             " + (double) ((requestsCompleted) / (totalTime/1000d)) + " (requests per second)");
        System.out.println("Error Count:             " + errorCount);
        System.out.println("============= STATISTICS ==============");
        */
      } //end of timer for loop
      }
      //} //end of numthreads for loop
      System.out.println("============= ALL DONE ==============");
    }
}
