/*
 * Decompiled with CFR 0.152.
 */
package com.holub.asynch;

import com.holub.asynch.Socket_server;
import com.holub.asynch.Thread_pool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

public class Socket_server
extends Thread {
    private ServerSocket main;
    private Thread_pool pool;
    private Class action;
    private Death shutdown;
    private LinkedList connections = new LinkedList();

    public Socket_server(int port_number, int expected_connections, Class action, Death shutdown) throws Not_created {
        try {
            this.main = new ServerSocket(port_number);
            this.pool = new Thread_pool(expected_connections, 0);
            this.action = action;
            this.shutdown = shutdown;
            System.out.println("set variables. about to create pool");
            int i = expected_connections;
            while (--i >= 0) {
                this.connections.addLast(new Client((Client_action)action.newInstance()));
            }
            System.out.println("created pool.");
            this.setDaemon(true);
        }
        catch (Exception e) {
            throw new Not_created(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (!this.isInterrupted()) {
                    Client client;
                    LinkedList linkedList = this.connections;
                    synchronized (linkedList) {
                        if (this.connections.size() > 0) {
                            client = (Client)this.connections.removeLast();
                            System.out.println("reusing client");
                        } else {
                            client = new Client((Client_action)this.action.newInstance());
                            System.out.println("making new client");
                        }
                    }
                    client.socket = this.main.accept();
                    if (!this.isInterrupted()) {
                        this.pool.execute(client);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (this.shutdown != null) {
                    this.shutdown.action(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.pool.close();
            if (this.shutdown == null) throw throwable;
            this.shutdown.action(null);
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.pool.close();
            if (this.shutdown == null) return;
            this.shutdown.action(null);
            return;
        }
    }

    public void kill() {
        try {
            this.pool.close();
            this.interrupt();
            this.main.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public interface Client_action {
        public void action(Socket var1);
    }

    public interface Death {
        public void action(Exception var1);
    }

    private class Client
    implements Runnable {
        private final Client_action action;
        public Socket socket;

        Client(Client_action action) {
            this.action = action;
        }

        public void run() {
            this.action.action(this.socket);
            LinkedList linkedList = Socket_server.this.connections;
            synchronized (linkedList) {
                Socket_server.this.connections.addLast(this);
            }
        }
    }

    public class Not_created
    extends RuntimeException {
        public Not_created(Exception e) {
            super("Couldn't create socket: " + e.getMessage());
        }
    }

    public static class Test {
        static /* synthetic */ Class class$0;

        public static void main(String[] args) throws Exception {
            class Action
            implements Client_action {
                Action() {
                }

                public void action(Socket socket) {
                    try {
                        String line;
                        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                        OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                        while ((line = in.readLine()) != null) {
                            out.write(line, 0, line.length());
                            out.write("\n", 0, 1);
                            out.flush();
                        }
                        socket.close();
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                }
            }
            Action act = new Action();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.holub.asynch.Socket_server$1$Action");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Socket_server echo_server = new Socket_server(9999, 10, clazz, new Death(){

                public void action(Exception e) {
                    System.out.println("goodbye world (" + e + ")");
                }
            });
            echo_server.start();
            Test.connect("Hello\n");
            Test.connect("World\n");
            echo_server.kill();
        }

        private static void connect(String s) throws Exception {
            Socket client = new Socket("localhost", 9999);
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8"));
            OutputStreamWriter out = new OutputStreamWriter(client.getOutputStream(), "UTF-8");
            out.write(s, 0, s.length());
            out.flush();
            s = in.readLine();
            System.out.println(s);
            client.close();
        }
    }
}

