#!/bin/bash

# Sanity check..
if [ ! -d debian ] ; then
  echo "you are not in a debian packaging directory!"
fi

# Allow user override
if [ "$1" != "" ]
then
  USER=$1
fi

# Build debian package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
USER=${1:-"${DEBFULLNAME} <${DEBEMAIL}>"}
if [ "$USER" = "" -o "$USER" = " " -o "$USER" = " <>" ] ; then
  USER=`dpkg-parsechangelog | sed -n 's/^Maintainer: //p'`
fi
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# CVS repositories..
PACKAGE_CVSROOT=catalyst/codeforge/php/${PACKAGE}

# If not present, always build ChangeLog, else ask..
if [ ! -f ChangeLog ]; then
  ANS=y
else
  echo -n "refresh ChangeLog? (y/n) [n]: "
  read ANS
fi
if [ "$ANS" = "y" -o "$ANS" = "Y" ]
then
  echo "generating ChangeLog.."
  cvs2cl >/dev/null 2>&1
fi


# Ensure we have latest Luceneserver locally..
if [ -d luceneserver/lib ] ; then
  echo -n "refresh luceneserver libs and code? [n] :"
  read ANS
  if [ "$ANS" = "y" ] ; then
    rm -rf luceneserver
  fi
fi
if [ ! -d luceneserver/lib ]; then
  rm -rf luceneserver
  echo "exporting a copy of Luceneserver.."
  cvs export -r HEAD -d luceneserver catalyst/luceneserver
fi

echo "constructing package to build.."
HOMEDIR=`pwd`
cd ..
[ ! -d debian-builds ] && mkdir debian-builds
[ ! -d debian-builds/${PACKAGE} ] && mkdir debian-builds/${PACKAGE}
cd debian-builds/${PACKAGE}
WRKDIR="${PACKAGE}-${VERSION}"
sudo rm -rf $WRKDIR
cp -a $HOMEDIR/ $WRKDIR
cd $WRKDIR
# Cleanse of unwanted stuff..
find . -depth -type d -name "CVS" -exec rm -rf {} \;
find . -name ".cvsignore" -exec rm -f {} \;
find . -name ".#*" -exec rm -f {} \;
find . -name "*.log" -exec rm -f {} \;
find . -name "diffs.sql" -exec rm -f {} \;

echo "building version ${VERSION} of ${PACKAGE} in directory `pwd`"

cp $HOMEDIR/ChangeLog .

# Fix perms..
find . -iname "*.php" -exec chmod 664 {} \;
find . -iname "*.sh" -exec chmod 775 {} \;
find . -iname "*.jpg" -exec chmod 664 {} \;
find . -iname "*.gif" -exec chmod 664 {} \;
find . -iname "*.png" -exec chmod 664 {} \;
find . -iname "*.wbmp" -exec chmod 664 {} \;
find . -iname "*.pdm" -exec chmod 664 {} \;
find . -iname "*.pdf" -exec chmod 664 {} \;
find . -iname "*.sql" -exec chmod 664 {} \;
find . -iname "*.xml" -exec chmod 664 {} \;
find . -iname "*.db" -exec chmod 664 {} \;
find . -iname ".htaccess" -exec chmod 664 {} \;
find . -iname "ChangeLog" -exec chmod 664 {} \;

# Build it!
dpkg-buildpackage -tc -rsudo -sgpg -m"${USER}" -k"${USER}"

