/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

/**
 *
 * @author  hamish
 */
public class StressClient implements Runnable {
    
    String name = "";
    int query_number = 0;
    int delay = 0;
    
    
    /** Creates a new instance of SocketTest */
    public StressClient(String name, int query_number, int delay) {
        this.name  = name;
        this.query_number = query_number;
        this.delay = delay;
    }
    
    public void run() {
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 0L;
        long tAfterExecuting   = 0L;
        long tClosedConnection = 0L;

        try {
          if (delay > 0) {
            synchronized(this) {
                    try {
                this.wait(delay);
                // sleep(100L);
                    } catch (Exception e) {
                        //do nothing
                    }
            }
          }
        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("HH:mm:ss S");
        String output = sdf.format(new java.util.Date());
        
        
        
        
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        
            echoSocket = new Socket("localhost", 22222);
            //echoSocket = new Socket("democritus.servers.catalyst.net.nz", 22223);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        tOpenedConnection = System.currentTimeMillis();
        
        String query = StressControl.queries[query_number];  
        output += "\tThread: " + name + " query: " + query_number;

        out.println(query);
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END"))  ) {            
            if (serverOutput.startsWith("Count:")) {
               output += "\t" + (serverOutput) + "\t";
            } else {
               // System.out.println("\t\t\t\t\t\t\t\t\t" + serverOutput);
            }
        }
            
        tAfterExecuting = System.currentTimeMillis();
        
	out.close();
	in.close();
	echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        output += "\to: " + (tOpenedConnection - tStart);
        output += "\te: " + (tAfterExecuting - tOpenedConnection);
        output += "\tc: " + (tClosedConnection - tAfterExecuting);
        output += "\tt: " + (tAfterExecuting - tStart);
        
        System.out.println(output);
        StressControl.threadTime += (tAfterExecuting - tStart);
        
      } catch (Exception e) {
            System.err.println("Thread: " + name + ": Couldn't get I/O for the connection or connection dropped.");
            StressControl.errorCount++;
      } finally {
            --StressControl.threadCountDown;

            if (StressControl.threadCountDown <= 0) {
                StressControl.printStats();
            }
      }


      
    }

   

    
}
