#!/usr/bin/php4 -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    layout-version-reset.php                                */
/* Author:      Paul Waite                                              */
/* Description: Fixup for problems with layout vers sharing same block. */
/*              This script removes all versions apart from the very    */
/*              latest one ("Pending") and all associated blocks etc.   */
/*              for each and every layout on the system.                */
/*                                                                      */
/* ******************************************************************** */
// CLI Program working dir is always its own directory
// so we need to get into the website root directory..
chdir("../..");

include_once("application.php");
include_once("layout-defs.php");

debug_on(DBG_DIAGNOSTIC);
debug_output(DBG_O_CLI);

debugbr("layout fixup begins..");

start_transaction();

// Remove dangling layout-sets..
dbcommand("DELETE FROM ax_layout_set WHERE NOT EXISTS (SELECT layout_id FROM ax_layout WHERE ax_layout.layout_name=ax_layout_set.layout_name)");

$layoutset = dbrecordset("SELECT * FROM ax_layout_set");
if ($layoutset->hasdata) {
  do {
    $layout_name  = $layoutset->field("layout_name");

    // Grab all relevant versions of the layout..
    $Lq  = "SELECT layout_id FROM ax_layout";
    $Lq .= " WHERE layout_name='". escape_string($layout_name) . "'";
    $Lq .= " ORDER BY layout_id DESC";
    $layout = dbrecordset($Lq);

    if ($layout->rowcount > 1) {
      // Get the first one. This is the one we are keeping..
      $thelayout = new layout( $layout->field("layout_id") );
      $theblocks = array();
      foreach ($thelayout->layout_blocks as $rowcol => $blockid) {
        $theblocks[] = $blockid;
      }

      // Skip to the next layout now..
      $layout->get_next();
      $delblocks = 0;
      do {
        $layoutid = $layout->field("layout_id");

        // Remove all blocks apart from ones the master layout requires..
        $block = dbrecordset("SELECT * FROM ax_block WHERE layout_id=$layoutid");
        if ($block->hasdata) {
          do {
            $blockid = $block->field("block_id");
            if (!in_array($blockid, $theblocks)) {
              $bb = dbrecordset("SELECT * FROM ax_block_blocklet WHERE block_id=$blockid");
              if ($bb->hasdata) {
                do {
                  $blockletid = $bb->field("blocklet_id");
                  dbcommand("DELETE FROM ax_blocklet WHERE blocklet_id=$blockletid");
                } while ($bb->get_next());
                dbcommand("DELETE FROM ax_block_blocklet WHERE block_id=$blockid");
              }
              dbcommand("DELETE FROM ax_block WHERE block_id=$blockid");
              $delblocks += 1;
            }
          } while ($block->get_next());
        }
        // Prevent RI removing any blocks we want to keep..
        $blup = new dbupdate("ax_block");
        $blup->set("layout_id", NULLVALUE);
        $blup->where("layout_id=$layoutid");
        $blup->execute();
        // Finally delete this layout..
        dbcommand("DELETE FROM ax_layout WHERE layout_id=$layoutid");
      } while ($layout->get_next());
      debugbr("$layout_name: deleted $delblocks blocks");
    }
    else {
      debugbr("$layout_name: clean");
    }
  } while ($layoutset->get_next());
}

commit();

debugbr("finished..");

?>
