#!/bin/sh
# Upgrade/patch a SQL SERVER database for an Axyl website.

# NOTE: This is not normally run standalone. The main DB upgrade
# script 'install/upgrade-axyl-databases.sh normally runs this.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# INCOMING PARAMETERS
#  $1  - DBNAME
#  $2  - DBUSER
#  $3  - DBPASSWD ('none' means a blank password)
#  $4  - DBHOST ('direct' means a local database server)
#  $5  - DBPORT
#  $6  - AXYL_VERSION (Axyl version, '' or 'n.n.n'
DBNAME=""
DBUSER=""
DBPASSWD=""
DBHOST=""
DBPORT=5432
AXYL_VERSION="unknown"

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  DBNAME=$1
        ;;
    2)  DBUSER=$1
        ;;
    3)  DBPASSWD=$1
        ;;
    4)  DBHOST=$1
        ;;
    5)  DBPORT=$1
        ;;
    6)  AXYL_VERSION=$1
        ;;
  esac
  shift
done

# No Oracle upgrade/patch path yet..
echo " ${DBNAME} (SQL Server patcher not yet implemented)"
exit 0

# END