<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-metaschema.php                                     */
/* Author:      Paul Waite                                              */
/* Description: Metaschema maintenance page                             */
/*              This maintenance page allows administrators to set up   */
/*              Metadata schemas, and their element sets.               */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$maint_formname = "schemaset_form";
$HEADING = "METADATA SCHEMA DEFINITION";
$RESPONSE->page($HEADING, "maint", $theme);

$RESPONSE->set_onload("initialise()");
$RESPONSE->head->add_script(
   "function initialise() {\n"
 . " for (var i=0; i < document.forms[0].length; i++) {\n"
 . "   var e=document.forms[0].elements[i];\n"
 . "   if (e.type == \"text\") {\n"
 . "     e.focus();\n"
 . "     break;\n"
 . "   }\n"
 . " }\n"
 . "}\n"
);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("recmaint-defs.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_output(DBG_O_LOG);

// -----------------------------------------------------------------------------------------------
// AUTHORISATION

// Only Editors and Admin allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take

// -----------------------------------------------------------------------------------------------
// HEADING
$recvalid = false;

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT

// ###############################################################################################
// POST PROCESSING

// DELETE SCHEMA
if ($mode == "select") {
  $mode = "edit";
}
elseif ($mode == "remove") {
  if (isset($schema_name)) {
    start_transaction();

    // First delete all site records, including meta-data..
    $elems = new dbselect("ax_meta_element");
    $elems->where("parent_schema='" . escape_string($schema_name) . "'");
    $elems->execute();
    if ($elems->hasdata) {
      do {
        $elemid = $elems->field("element_id");
        $edel = new dbdelete("ax_layout_metadata");
        $edel->where("element_id=$elemid");
        $edel->execute();
        $edel = new dbdelete("ax_site_meta_element");
        $edel->where("element_id=$elemid");
        $edel->execute();
      } while ($elems->get_next());
    }
    // Then all meta elements spawned by this schema..
    $edel = new dbdelete("ax_meta_element");
    $edel->where("parent_schema='" . escape_string($schema_name) . "'");
    $edel->execute();

    // Then all meta elements in the set list for this schema..
    $edel = new dbdelete("ax_meta_element_set");
    $edel->where("schema_name='" . escape_string($schema_name) . "'");
    $edel->execute();

    // And finally, the schema record itself..
    $edel = new dbdelete("ax_meta_schema");
    $edel->where("schema_name='" . escape_string($schema_name) . "'");
    $edel->execute();

    commit();
  }
  $mode = "edit";
  $schema_name = "";
}
// ADDING A NEW SCHEMA
elseif (isset($add_x)) {
  $mode = "add";
  $schema_name = "New Schema";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}
// SAVE DATA FOR EXISTING SCHEMA OR INSERT NEW ONE..
elseif ( isset($siterecmaintpost_form)
        && $siterecmaintpost_form == $maint_formname) {
  if (isset($schema_name)) {
    if ($mode == "add") {
      $query = new dbinsert("ax_meta_schema");
      $query->set("schema_name", $schema_name);
      $mode = "edit";
    }
    else {
      $query = new dbupdate("ax_meta_schema");
      $query->where("schema_name='" . escape_string($schema_name) . "'");
    }
    $query->set("description", $description);
    $query->set("namespace", $namespace);
    $query->set("namespace_uri", $namespace_uri);
    $query->execute();
  }

  // Deal with deletes..
  if (isset($siterecmaintpost_dels) && $siterecmaintpost_dels != "") {
    $delids = explode(FIELD_DELIM, $siterecmaintpost_dels);
    foreach ($delids as $del_elemid) {
      $delset = new dbdelete("ax_meta_element_set");
      $delset->where("schema_name='" . escape_string($schema_name) . "'");
      $delset->where("AND element_id=$del_elemid");
      $delset->execute();
    }
  }

  // Element adds and saves..
  if (isset($siterecmaintpost_data) && $siterecmaintpost_data != "") {
    $recs = explode(RECORD_DELIM, $siterecmaintpost_data);
    $elemfields = explode(",", $siterecmaintpost_flds);
    foreach ($recs as $elemrec) {
      $elemvalues = explode(FIELD_DELIM, $elemrec);
      $elemid = array_shift($elemvalues);
      if (strstr($elemid, "NEW_")) {
        // Insert new element into the set..
        $savedid = $elemid;
        $um = new dbinsert("ax_meta_element_set");
        $um->set("schema_name", $schema_name);
        $um->set("display_order", 999);
        $newelem = true;
      }
      else {
        // Update the existing element data..
        $um = new dbupdate("ax_meta_element_set");
        $um->where("schema_name='" . escape_string($schema_name) . "'");
        $um->where("AND element_id=$elemid");
        $newelem = false;
      }
      $pos = 0;
      $encids = array();
      foreach ($elemfields as $elemfield) {
        $elemval = $elemvalues[$pos++];
        if ($elemfield == "enc_scheme_id") {
          if ($elemval != "") {
            $encids = explode(",", $elemval);
          }
        }
        else {
          if ($elemfield == "preferred_enc_scheme") {
            if ($elemval == "") {
              $elemval = NULLVALUE;
            }
          }
          elseif ($elemfield == "element_id") {
            // Fix up potential re-ordering id..
            $elemid = $elemval;
            if (isset($siterecmaintpost_order)) {
              $siterecmaintpost_order = str_replace($savedid, $elemid, $siterecmaintpost_order);
            }
          }
          $um->set($elemfield, $elemval);
        }
      }
      $doupdate = true;
      // Check for duplicates..
      if ($newelem) {
        $chk = new dbselect("ax_meta_element_set");
        $chk->where("schema_name='" . escape_string($schema_name) . "'");
        $chk->where("AND element_id=$elemid");
        $chk->execute();
        if ($chk->rowcount > 0) {
          $doupdate = false;
        }
      }
      // Update or insert the record..
      if ($doupdate) {
        $um->execute();
      }
      // Now finish off with the encoding schemes..
      $edel = new dbdelete("ax_element_set_enc");
      $edel->where("schema_name='" . escape_string($schema_name) . "'");
      $edel->where("AND element_id=$elemid");
      $edel->execute();
      if (is_array($encids) && count($encids) > 0) {
        foreach ($encids as $encid) {
          $ein = new dbinsert("ax_element_set_enc");
          $ein->set("schema_name",   $schema_name);
          $ein->set("element_id",    $elemid);
          $ein->set("enc_scheme_id", $encid);
          $ein->execute();
        }
      }
    } // foreach saved record
  }

  // Check/save ordering..
  if (isset($siterecmaintpost_order) && $siterecmaintpost_order != "") {
    $ord = 1;
    $idlist = explode(FIELD_DELIM, $siterecmaintpost_order);
    foreach ($idlist as $elemid) {
      $upd = new dbupdate("ax_meta_element_set");
      $upd->where("schema_name='" . escape_string($schema_name) . "'");
      $upd->where("AND element_id=$elemid");
      $upd->set("display_order", $ord);
      $upd->execute();
      $ord += 1;
    }
  }
}

// -----------------------------------------------------------------------------------------------
// Get current schema, if any..
if (isset($schema_name)) {
  $q  = "SELECT *";
  $q .= "  FROM ax_meta_schema";
  $q .= " WHERE schema_name='" . escape_string($schema_name) . "'";
  $cur_schema = dbrecordset($q);
  if ($cur_schema->hasdata) {
    $schema_name = $cur_schema->field("schema_name");
    $description = $cur_schema->field("description");
    $namespace = $cur_schema->field("namespace");
    $namespace_uri = $cur_schema->field("namespace_uri");
    $recvalid = true;
    $HEADING .= " - " . $schema_name;
  }
}

// ###############################################################################################
// FORM ELEMENTS

// Width of large form elements..
$ewidth = "400px";
$cwidth = "150px";
$pwidth = "90px";

// -----------------------------------------------------------------------------------------------
// SCHEMA SELECT schemasetup
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("schema_name", "Schemas", $schema_name);
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.$maint_formname.mode.value='select';document.forms.$maint_formname.submit()");
  $Q = dbrecordset("SELECT * FROM ax_meta_schema ORDER BY schema_name");
  if ($Q->rowcount > 0) {
    do {
      $sname = $Q->field("schema_name");
      $sdesc = $Q->field("description");
      $nspace = $Q->field("namespace");
      $nspace_uri = $Q->field("namespace_uri");
      $Sel_F->additem($sname, $sdesc);
    } while ($Q->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Select:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$SCHEMA_SELECT = $s;

// -----------------------------------------------------------------------------------------------
// CONTROL BUTTONS & MAINTAINER

// KEYFIELD and RECORD MAINTAINER
// Meta Schema Set Listbox
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$schemaset_listbox = new form_combofield("key_element_id");
$schemaset_listbox->setclass("axlistbox");
$schemaset_listbox->setstyle("width:$ewidth;");
$schemaset_listbox->size = 16;

// Make a new record maintainer, and attach the buttons..
$maintainer = new recmaintainer($maint_formname, $schemaset_listbox, "site");

// Create maintainer buttons..
$bup    = new form_imagebutton("_up",    "", "", "$LIBDIR/img/_up.gif",     "Move up",              57, 15);
$bdown  = new form_imagebutton("_down",  "", "", "$LIBDIR/img/_down.gif",   "Move down",            57, 15);
$badd   = new form_imagebutton("_add",   "", "", "$LIBDIR/img/_add.gif",    "Add new meta element", 57, 15);
$bdel   = new form_imagebutton("_del",   "", "", "$LIBDIR/img/_delete.gif", "Delete element",       57, 15);
$breset = new form_imagebutton("_reset", "", "", "$LIBDIR/img/_reset.gif",  "Reset form",           57, 15);

$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new meta schema",   57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this schema",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");

// Register all relevant buttons to the maintainer..
$maintainer->register_button("up" ,   $bup);
$maintainer->register_button("down",  $bdown);
$maintainer->register_button("add",   $badd);
$maintainer->register_button("del",   $bdel);
$maintainer->register_button("reset", $breset);
$maintainer->register_button("save",  $savbtn);

$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this schema, and all associated metadata?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.$maint_formname.mode.value='remove';\n"
  . "   document.forms.$maint_formname.submit();\n"
  . " }\n"
  . " else alert(\"Schema survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------------------------------
// SCHEMA DETAILS

$Ted = new table("schema_$schema_name");
$Ted->setpadding(2);

// ..................................................................
// Global Menu Options..
$Ted->tr("axhdg");
$Ted->td("<b>SCHEMA SETTINGS</b>", "axhdg");
$Ted->td_colspan(2);

if ($recvalid) {
  // Schema description..
  $sdesc_F = new form_memofield("description", "", $description);
  $sdesc_F->setstyle("width:$ewidth;height:100px;");
  $sdesc_F->setclass("axmemo");
  $Ted->tr("axbglite");
  $Ted->td("Description:", "axfg");
  $Ted->td_alignment("", "top");
  $Ted->td( $sdesc_F->render() );

  // Schema namespace identifier..
  $sns_F = new form_textfield("namespace", "", $namespace);
  $sns_F->setstyle("width:$pwidth;");
  $sns_F->setclass("axtxtbox");
  $Ted->tr("axbgdark");
  $Ted->td("Namespace:", "axfg");
  $Ted->td( $sns_F->render() );

  // Reference URI for schema..
  $snsuri_F = new form_textfield("namespace_uri", "", $namespace_uri);
  $snsuri_F->setstyle("width:$ewidth;");
  $snsuri_F->setclass("axtxtbox");
  $Ted->tr("axbglite");
  $Ted->td("Namespace URI:", "axfg");
  $Ted->td( $snsuri_F->render() );

  // ..................................................................
  // Menu Options Editing Fields..
  $Ted->tr("axhdg");
  $Ted->td("<b>SCHEMA METADATA ELEMENTS</b>", "axhdg");
  $Ted->td_colspan(2);

  // Continue defining listbox..
  $q  = "SELECT *";
  $q .= "  FROM ax_meta_element_set es, ax_meta_element e";
  $q .= " WHERE es.schema_name='" . escape_string($schema_name) . "'";
  $q .= "   AND e.element_id=es.element_id";
  $q .= "   AND e.enabled";
  $q .= " ORDER BY es.display_order";
  $elemset = dbrecordset($q);
  if ($elemset->hasdata) {
    do {
      // Populate listbox..
      $elemid    = $elemset->field("element_id");
      $elemlbl   = $elemset->field("label");
      $prefenc   = $elemset->field("preferred_enc_scheme");
      $oblig     = $elemset->field("obligation");
      $default   = $elemset->field("default_value");
      $list      = $elemset->field("list_of_values");
      $comments  = $elemset->field("comments");
      $enabled   = $elemset->istrue("enabled");
      $schemaset_listbox->additem($elemid, $elemlbl);

      // Get list of encoding schemes for this element..
      $elemenc = array();
      $q  = "SELECT enc_scheme_id FROM ax_element_set_enc";
      $q .= " WHERE schema_name='" . escape_string($schema_name) . "'";
      $q .= "   AND element_id=$elemid";
      $encset = dbrecordset($q);
      if ($encset->hasdata) {
        do {
          $elemenc[] = $encset->field("enc_scheme_id");
        } while ($encset->get_next());
      }

      // Populate maintainer data. The maintainer add_record method
      // requires an associative array keyed on listbox key id..
      $rec = array(
              "element_id" => $elemid,
              "enc_scheme_id" => implode(",", $elemenc),
              "preferred_enc_scheme" => $prefenc,
              "obligation" => $oblig,
              "default_value" => $default,
              "list_of_values" => $list,
              "comments" => $comments,
              "enabled" => ($enabled ? "t" : "f")
              );
      $maintainer->add_record($elemid, $rec);

      // If this is the element being edited, make sure
      // that it gets focussed..
      if (isset($element_id) && $element_id == $elemid) {
        $maintainer->initial_record($elemid);
      }
    } while ($elemset->get_next());
  }
  // Now set the defaults for each of the fields. These are
  // necessary for when a new record is created..
  $defaults = array(
            "",
            "enc_scheme_id" => "",
            "preferred_enc_scheme" => "",
            "obligation" => "o",
            "default_value" => "",
            "list_of_values" => "",
            "comments" => "",
            "enabled" => "t"
            );
  $maintainer->add_defaults($defaults);

  // The listbox field..
  //$schemaset_listbox->setvalue($elemid);
  $Ted->tr("axbgdark");
  $Ted->td(
        $badd->render()  . "<br>"
      . $bdel->render()  . "<br>"
      . $bup->render()   . "<br>"
      . $bdown->render()
      );
  $Ted->td_alignment("", "top");
  $Ted->td( $schemaset_listbox->render() );
  $Ted->td_alignment("", "top");

  // ..................................................................
  $Ted->tr("axhdg");
  $Ted->td("<b>ELEMENT SETTINGS</b>", "axhdg");
  $Ted->td_colspan(2);

  // ..................................................................
  // Metadata Element ID..
  $elemSel = new form_combofield("element_id");
  $elemSel->setstyle("width:$ewidth;");
  $elemSel->setclass("axcombo");
  $maintainer->register_field($elemSel);
  $elemSel->additem("", "");
  $q  = "SELECT *";
  $q .= "  FROM ax_meta_element e";
  $q .= " WHERE e.enabled=TRUE";
  $q .= " ORDER BY e.tag_name";
  $eQ = dbrecordset($q);
  if ($eQ->hasdata) {
    do {
      $elemid = $eQ->field("element_id");
      $elemname = $eQ->field("tag_name");
      $elemSel->additem($elemid, $elemname);
    } while ($eQ->get_next());
  }
  $Ted->tr("axbglite");
  $Ted->td( "Meta data element:", "axfg" );
  $Ted->td( $elemSel->render() );

  // ..................................................................
  // Encoding Schemes..
  $schemSel = new form_combofield("enc_scheme_id");
  $schemSel->setstyle("width:$ewidth;");
  $schemSel->setclass("axlistbox");
  $schemSel->multiselect = true;
  $schemSel->size = 8;
  $maintainer->register_field($schemSel);
  $schemSel->additem("", "None");
  $q  = "SELECT *";
  $q .= "  FROM ax_enc_scheme";
  $q .= " WHERE enabled=TRUE";
  $q .= " ORDER BY tag_name,label";
  $eQ = dbrecordset($q);
  if ($eQ->hasdata) {
    do {
      $schid = $eQ->field("enc_scheme_id");
      $schtag = $eQ->field("tag_name");
      $schname = $eQ->field("enc_scheme_name");
      $schlabel = $eQ->field("label");
      $label = $schlabel;
      if ($schtag != "") {
        $label = "$schtag - $label";
      }
      $schemSel->additem($schid, $label);
    } while ($eQ->get_next());
  }
  $Ted->tr("axbgdark");
  $Ted->td( "Encoding schemes:", "axfg" );
  $Ted->td_alignment( "", "top" );
  $Ted->td( $schemSel->render() );

  // ..................................................................
  // Preferred encoding scheme..
  $prefencSel = new form_combofield("preferred_enc_scheme");
  $prefencSel->setstyle("width:$ewidth;");
  $prefencSel->setclass("axcombo");
  $maintainer->register_field($prefencSel);
  $prefencSel->additem("", "None");
  // Using same query already executed above..
  if ($eQ->hasdata) {
    $eQ->get_first();
    do {
      $schid = $eQ->field("enc_scheme_id");
      $schtag = $eQ->field("tag_name");
      $schname = $eQ->field("enc_scheme_name");
      $schlabel = $eQ->field("label");
      $label = $schlabel;
      if ($schtag != "") {
        $label = "$schtag - $label";
      }
      $prefencSel->additem($schid, $label);
    } while ($eQ->get_next());
  }
  $Ted->tr("axbglite");
  $Ted->td( "Preferred Encoding Scheme:", "axfg" );
  $Ted->td_alignment( "", "top" );
  $Ted->td( $prefencSel->render() );

  // ..................................................................
  // Obligation of metadata data-entry..
  $obSel = new form_combofield("obligation");
  $obSel->setstyle("width:$cwidth;");
  $obSel->setclass("axcombo");
  $maintainer->register_field($obSel);
  $obSel->additem("", "");
  $obSel->additem('o', "Optional");
  $obSel->additem('m', "Mandatory");
  $obSel->additem('c', "Conditional");
  $obSel->additem('r', "Recommended");
  $Ted->tr("axbgdark");
  $Ted->td( "Obligation:", "axfg" );
  $Ted->td( $obSel->render() );

  // ..................................................................
  $defTxt = new form_textfield("default_value");
  $defTxt->setstyle("width:$cwidth;");
  $defTxt->setclass("axtxtbox");
  $maintainer->register_field($defTxt);
  $Ted->tr("axbglite");
  $Ted->td( "Default value:", "axfg" );
  $Ted->td_alignment( "", "top" );
  $Ted->td( $defTxt->render() );

  // ..................................................................
  $lstTxt = new form_textfield("list_of_values");
  $lstTxt->setstyle("width:$ewidth;");
  $lstTxt->setclass("axtxtbox");
  $maintainer->register_field($lstTxt);
  $Ted->tr("axbgdark");
  $Ted->td( "List of values:", "axfg" );
  $Ted->td_alignment( "", "top" );
  $Ted->td( $lstTxt->render() );

  // ..................................................................
  $coMem = new form_memofield("comments");
  $coMem->setstyle("width:$ewidth;height:130px;");
  $coMem->setclass("axmemo");
  $maintainer->register_field($coMem);
  $Ted->tr("axbglite");
  $Ted->td( "Comments:", "axfg" );
  $Ted->td_alignment( "", "top" );
  $Ted->td( $coMem->render() );

  // ..................................................................
  $enbChk = new form_checkbox("enabled");
  $enbChk->setclass("axchkbox");
  $maintainer->register_field($enbChk);
  $Ted->tr("axbgdark");
  $Ted->td( "Enabled:", "axfg" );
  $Ted->td( $enbChk->render() );

  // ..................................................................
  // Render the whole form..
  $Ted->tr("axtitle");
  $Ted->td("&nbsp;", "axtitle");
  $Ted->td_colspan(2);

  $Ted->set_width_profile("30%,70%");
  $SCHEMA_DETAILS .= $Ted->render();

  // Render the maintainer. This adds the Javascript data structures
  // and renders the hidden fields for submitting changed field data..
  $SCHEMA_DETAILS .= $maintainer->render();

} // record valid

// -----------------------------------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------------------------------
// mode field
$hid = new form_hiddenfield("mode", $mode);
$MODE_HIDDEN = $hid->render();

// ###############################################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="schemaset_form" method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--SCHEMA_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--SCHEMA_DETAILS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// ###############################################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("SCHEMA_SELECT",     $SCHEMA_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("SCHEMA_DETAILS",    $SCHEMA_DETAILS);

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>