/*==============================================================*/
/* Database name:  axyl                                         */
/* DBMS name:      Microsoft SQL Server 7.x                     */
/* Created on:     8/12/2004 4:03:50 p.m.                       */
/*==============================================================*/


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_block')
            and   name  = 'ax_block_layout_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_block.ax_block_layout_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_block_blocklet')
            and   name  = 'ax_block_blocklet_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_block_blocklet.ax_block_blocklet_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_block_blocklet')
            and   name  = 'ax_block_blocklet_FK2'
            and   indid > 0
            and   indid < 255)
   drop index ax_block_blocklet.ax_block_blocklet_FK2
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_configuration')
            and   name  = 'ax_configuration_config_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_configuration.ax_configuration_config_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_forum_member')
            and   name  = 'ax_forum_member_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_forum_member.ax_forum_member_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_forum_member')
            and   name  = 'ax_forum_member_FK2'
            and   indid > 0
            and   indid < 255)
   drop index ax_forum_member.ax_forum_member_FK2
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_forum_msg')
            and   name  = 'ax_fk_forum_msg_forum_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_forum_msg.ax_fk_forum_msg_forum_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_layout')
            and   name  = 'ax_layout_set_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_layout.ax_layout_set_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_layout_set')
            and   name  = 'ax_layout_set_sitepage_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_layout_set.ax_layout_set_sitepage_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_menu')
            and   name  = 'menu_language'
            and   indid > 0
            and   indid < 255)
   drop index ax_menu.menu_language
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_menuoption')
            and   name  = 'ax_menuoption_menu_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_menuoption.ax_menuoption_menu_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_organisation')
            and   name  = 'ax_org_contactinfo_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_organisation.ax_org_contactinfo_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_user')
            and   name  = 'ax_user_org_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_user.ax_user_org_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_user_group')
            and   name  = 'ax_user_group_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_user_group.ax_user_group_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_user_group')
            and   name  = 'ax_user_group_FK2'
            and   indid > 0
            and   indid < 255)
   drop index ax_user_group.ax_user_group_FK2
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_user_ip')
            and   name  = 'ax_user_ip_user_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_user_ip.ax_user_ip_user_FK
go


if exists (select 1
            from  sysindexes
           where  id    = object_id('ax_wwwsession')
            and   name  = 'ax_wwwsession_user_FK'
            and   indid > 0
            and   indid < 255)
   drop index ax_wwwsession.ax_wwwsession_user_FK
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_block')
            and   type = 'U')
   drop table ax_block
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_block_blocklet')
            and   type = 'U')
   drop table ax_block_blocklet
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_blocklet')
            and   type = 'U')
   drop table ax_blocklet
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_catalog')
            and   type = 'U')
   drop table ax_catalog
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_config')
            and   type = 'U')
   drop table ax_config
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_configuration')
            and   type = 'U')
   drop table ax_configuration
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_contactinfo')
            and   type = 'U')
   drop table ax_contactinfo
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_content_location')
            and   type = 'U')
   drop table ax_content_location
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_element_set_enc')
            and   type = 'U')
   drop table ax_element_set_enc
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_enc_qualifier')
            and   type = 'U')
   drop table ax_enc_qualifier
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_enc_scheme')
            and   type = 'U')
   drop table ax_enc_scheme
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_enc_value')
            and   type = 'U')
   drop table ax_enc_value
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_forum')
            and   type = 'U')
   drop table ax_forum
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_forum_member')
            and   type = 'U')
   drop table ax_forum_member
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_forum_msg')
            and   type = 'U')
   drop table ax_forum_msg
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_group')
            and   type = 'U')
   drop table ax_group
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_language')
            and   type = 'U')
   drop table ax_language
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_layout')
            and   type = 'U')
   drop table ax_layout
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_layout_metadata')
            and   type = 'U')
   drop table ax_layout_metadata
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_layout_set')
            and   type = 'U')
   drop table ax_layout_set
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_menu')
            and   type = 'U')
   drop table ax_menu
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_menuoption')
            and   type = 'U')
   drop table ax_menuoption
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_meta_element')
            and   type = 'U')
   drop table ax_meta_element
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_meta_element_set')
            and   type = 'U')
   drop table ax_meta_element_set
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_meta_schema')
            and   type = 'U')
   drop table ax_meta_schema
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_organisation')
            and   type = 'U')
   drop table ax_organisation
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_query_resource')
            and   type = 'U')
   drop table ax_query_resource
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_site_meta_element')
            and   type = 'U')
   drop table ax_site_meta_element
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_sitepage')
            and   type = 'U')
   drop table ax_sitepage
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_sitepage_group')
            and   type = 'U')
   drop table ax_sitepage_group
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story')
            and   type = 'U')
   drop table ax_story
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story_category')
            and   type = 'U')
   drop table ax_story_category
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story_category_locs')
            and   type = 'U')
   drop table ax_story_category_locs
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story_location')
            and   type = 'U')
   drop table ax_story_location
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story_media')
            and   type = 'U')
   drop table ax_story_media
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_story_translation')
            and   type = 'U')
   drop table ax_story_translation
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_user')
            and   type = 'U')
   drop table ax_user
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_user_group')
            and   type = 'U')
   drop table ax_user_group
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_user_ip')
            and   type = 'U')
   drop table ax_user_ip
go


if exists (select 1
            from  sysobjects
           where  id = object_id('ax_wwwsession')
            and   type = 'U')
   drop table ax_wwwsession
go


/*==============================================================*/
/* Table: ax_block                                              */
/*==============================================================*/
create table ax_block (
   block_id             int                  not null,
   layout_id            int                  not null,
   background_img       int                  null,
   lang_id              int                  not null default 0,
   block_desc           varchar(4000)        null,
   block_style          varchar(64)          null,
   block_type           varchar(64)          null,
   cols                 int                  not null,
   gutter_width         int                  not null,
   gutter_colour        varchar(64)          null,
   blocklet_sep         int                  not null,
   border_width         int                  not null,
   border_colour        varchar(64)          null,
   background_colour    varchar(64)          null,
   justify              varchar(16)          not null
      constraint CKC_JUSTIFY_AX_BLOCK check (justify in ('','left','center','right')),
   valign               varchar(50)          not null
      constraint CKC_VALIGN_AX_BLOCK check (valign in ('','top','middle','bottom')),
   exportable           smallint             not null,
   cache                varchar(64)          null,
   cache_updated        datetime             null,
   last_modified        datetime             not null,
   constraint ax_block_pkey primary key  (block_id)
)
go


execute sp_bindefault D_Integer_1, 'ax_block.cols'
go


execute sp_bindefault D_Integer, 'ax_block.gutter_width'
go


execute sp_bindefault D_Integer, 'ax_block.blocklet_sep'
go


execute sp_bindefault D_Integer, 'ax_block.border_width'
go


execute sp_bindefault D_JustifyType, 'ax_block.justify'
go


execute sp_bindefault D_ValignType, 'ax_block.valign'
go


execute sp_bindefault D_Bool_InitFalse, 'ax_block.exportable'
go


execute sp_bindefault D_TimeStampNow, 'ax_block.last_modified'
go


/*==============================================================*/
/* Index: ax_block_layout_FK                                    */
/*==============================================================*/
create   index ax_block_layout_FK on ax_block (
layout_id
)
go


/*==============================================================*/
/* Table: ax_block_blocklet                                     */
/*==============================================================*/
create table ax_block_blocklet (
   blocklet_id          int                  not null,
   block_id             int                  not null,
   display_order        int                  not null,
   visible              smallint             not null,
   constraint ax_block_blocklet_pkey primary key  (blocklet_id, block_id)
)
go


execute sp_bindefault D_Integer, 'ax_block_blocklet.display_order'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_block_blocklet.visible'
go


/*==============================================================*/
/* Index: ax_block_blocklet_FK                                  */
/*==============================================================*/
create   index ax_block_blocklet_FK on ax_block_blocklet (
blocklet_id
)
go


/*==============================================================*/
/* Index: ax_block_blocklet_FK2                                 */
/*==============================================================*/
create   index ax_block_blocklet_FK2 on ax_block_blocklet (
block_id
)
go


/*==============================================================*/
/* Table: ax_blocklet                                           */
/*==============================================================*/
create table ax_blocklet (
   blocklet_id          int                  not null,
   blocklet_desc        varchar(4000)        null,
   blocklet_type        varchar(50)          not null
      constraint CKC_BLOCKLET_TYPE_AX_BLOCKLET check (blocklet_type in ('text','list','ordered','bullets','table','raw')),
   blocklet_width       int                  not null
      constraint CKC_BLOCKLET_WIDTH_AX_BLOCKLET check (blocklet_width between 0 and 100),
   blocklet_style       varchar(64)          null,
   justify              varchar(16)          not null
      constraint CKC_JUSTIFY_AX_BLOCKLET check (justify in ('','left','center','right')),
   heading              varchar(64)          null,
   heading_level        int                  not null,
   heading_colour       varchar(64)          null,
   ruler                varchar(50)          not null
      constraint CKC_RULER_AX_BLOCKLET check (ruler in ('none','top','bottom')),
   ruler_width          int                  not null
      constraint CKC_RULER_WIDTH_AX_BLOCKLET check (ruler_width between 0 and 100),
   ruler_size           int                  not null,
   ruler_colour         varchar(64)          null,
   content              ntext                null,
   content_size         float                not null default 1.0,
   content_colour       varchar(64)          null,
   table_style          varchar(64)          null,
   table_autojustify    smallint             not null default false,
   table_rowstripes     smallint             not null default false,
   constraint ax_blocklet_pkey primary key  (blocklet_id)
)
go


execute sp_bindefault D_BlockletType, 'ax_blocklet.blocklet_type'
go


execute sp_bindefault D_WidthPct100, 'ax_blocklet.blocklet_width'
go


execute sp_bindefault D_JustifyType, 'ax_blocklet.justify'
go


execute sp_bindefault D_Integer_3, 'ax_blocklet.heading_level'
go


execute sp_bindefault D_RulerType, 'ax_blocklet.ruler'
go


execute sp_bindefault D_WidthPct100, 'ax_blocklet.ruler_width'
go


execute sp_bindefault D_Integer_1, 'ax_blocklet.ruler_size'
go


/*==============================================================*/
/* Table: ax_catalog                                            */
/*==============================================================*/
create table ax_catalog (
   cat_id               int                  not null,
   cat_name             varchar(64)          not null,
   cat_desc             varchar(64)          null,
   mime_type            varchar(64)          not null,
   mime_category        varchar(64)          not null,
   upload_timestamp     datetime             not null,
   category             varchar(64)          null,
   keywords             varchar(64)          null,
   filesize             int                  not null,
   filepath             varchar(64)          not null,
   width                int                  not null,
   height               int                  not null,
   constraint ax_catalog_pkey primary key  (cat_id)
)
go


execute sp_bindefault D_TimeStampNow, 'ax_catalog.upload_timestamp'
go


execute sp_bindefault D_Integer, 'ax_catalog.filesize'
go


execute sp_bindefault D_Integer, 'ax_catalog.width'
go


execute sp_bindefault D_Integer, 'ax_catalog.height'
go


/*==============================================================*/
/* Table: ax_config                                             */
/*==============================================================*/
create table ax_config (
   config_name          varchar(64)          not null,
   config_fields        varchar(64)          null,
   constraint ax_config_pkey primary key  (config_name)
)
go


/*==============================================================*/
/* Table: ax_configuration                                      */
/*==============================================================*/
create table ax_configuration (
   config_name          varchar(64)          not null,
   config_id            varchar(64)          not null,
   config_set           varchar(64)          null,
   constraint ax_configuration_pkey primary key  (config_name, config_id)
)
go


/*==============================================================*/
/* Index: ax_configuration_config_FK                            */
/*==============================================================*/
create   index ax_configuration_config_FK on ax_configuration (
config_name
)
go


/*==============================================================*/
/* Table: ax_contactinfo                                        */
/*==============================================================*/
create table ax_contactinfo (
   contactinfo_id       int                  not null,
   addr_postal          varchar(64)          null,
   addr_street          varchar(64)          null,
   addr_suburb          varchar(64)          null,
   addr_city            varchar(64)          null,
   addr_country         varchar(64)          null,
   addr_code            varchar(64)          null,
   addr_other           varchar(64)          null,
   emails               varchar(50)          null,
   phone                varchar(50)          null,
   phone_fax            varchar(50)          null,
   phone_work           varchar(50)          null,
   phone_mobile         varchar(50)          null,
   urls                 varchar(64)          null,
   constraint ax_contactinfo_pkey primary key  (contactinfo_id)
)
go


/*==============================================================*/
/* Table: ax_content_location                                   */
/*==============================================================*/
create table ax_content_location (
   location_id          INT4                 not null,
   location_name        varchar(64)          not null,
   location_desc        varchar(64)          null,
   enabled              smallint             not null default true,
   constraint PK_AX_CONTENT_LOCATION primary key  (location_id)
)
go


/*==============================================================*/
/* Table: ax_element_set_enc                                    */
/*==============================================================*/
create table ax_element_set_enc (
   schema_name          varchar(64)          not null,
   element_id           int                  not null,
   enc_scheme_id        int                  not null,
   constraint PK_AX_ELEMENT_SET_ENC primary key  (schema_name, element_id, enc_scheme_id)
)
go


/*==============================================================*/
/* Table: ax_enc_qualifier                                      */
/*==============================================================*/
create table ax_enc_qualifier (
   enc_scheme_id        int                  not null,
   qual_name            varchar(64)          not null,
   qual_label           varchar(64)          null,
   comments             varchar(64)          null,
   default_value        varchar(64)          null,
   list_of_values       varchar(64)          null,
   display_order        int                  not null default 999,
   constraint PK_AX_ENC_QUALIFIER primary key  (enc_scheme_id, qual_name)
)
go


/*==============================================================*/
/* Table: ax_enc_scheme                                         */
/*==============================================================*/
create table ax_enc_scheme (
   enc_scheme_id        int                  not null,
   enc_scheme_name      varchar(64)          not null,
   label                varchar(64)          null,
   tag_name             varchar(64)          not null,
   description          varchar(64)          null,
   datasrc_uri          varchar(64)          null,
   reference_url        varchar(64)          null,
   enabled              smallint             not null,
   constraint PK_AX_ENC_SCHEME primary key  (enc_scheme_id)
)
go


execute sp_bindefault D_EnabledFlag, 'ax_enc_scheme.enabled'
go


/*==============================================================*/
/* Table: ax_enc_value                                          */
/*==============================================================*/
create table ax_enc_value (
   enc_scheme_id        int                  not null,
   enc_value            varchar(64)          not null,
   enc_label            varchar(64)          null,
   constraint PK_AX_ENC_VALUE primary key  (enc_scheme_id, enc_value)
)
go


/*==============================================================*/
/* Table: ax_forum                                              */
/*==============================================================*/
create table ax_forum (
   forum_id             int                  not null,
   moderator            varchar(64)          null,
   forum_name           varchar(64)          not null,
   forum_desc           varchar(64)          null,
   enabled              smallint             not null,
   private              smallint             not null,
   last_author          varchar(64)          null,
   threadlast_author    int                  not null,
   datelast_author      datetime             null,
   posts                int                  not null,
   constraint ax_forum_pkey primary key  (forum_id)
)
go


execute sp_bindefault D_Bool_InitTrue, 'ax_forum.enabled'
go


execute sp_bindefault D_Bool_InitFalse, 'ax_forum.private'
go


execute sp_bindefault D_Integer, 'ax_forum.threadlast_author'
go


execute sp_bindefault D_Integer, 'ax_forum.posts'
go


/*==============================================================*/
/* Table: ax_forum_member                                       */
/*==============================================================*/
create table ax_forum_member (
   user_id              varchar(64)          not null,
   forum_id             int                  not null,
   constraint ax_forum_mbr_pkey primary key  (user_id, forum_id)
)
go


/*==============================================================*/
/* Index: ax_forum_member_FK                                    */
/*==============================================================*/
create   index ax_forum_member_FK on ax_forum_member (
user_id
)
go


/*==============================================================*/
/* Index: ax_forum_member_FK2                                   */
/*==============================================================*/
create   index ax_forum_member_FK2 on ax_forum_member (
forum_id
)
go


/*==============================================================*/
/* Table: ax_forum_msg                                          */
/*==============================================================*/
create table ax_forum_msg (
   msg_id               int                  not null,
   forum_id             int                  not null,
   msg_subject          varchar(64)          not null,
   msg_text             varchar(64)          not null,
   msg_author           varchar(64)          not null,
   msg_votes            int                  not null,
   last_modified        datetime             not null,
   parent_thread_id     int                  null,
   sticky               smallint             not null default false,
   locked               smallint             not null default false,
   views                int                  not null,
   enabled              smallint             not null,
   replies              int                  not null,
   constraint ax_forum_msg_pkey primary key  (msg_id)
)
go


execute sp_bindefault D_Integer, 'ax_forum_msg.msg_votes'
go


execute sp_bindefault D_TimeStampNow, 'ax_forum_msg.last_modified'
go


execute sp_bindefault D_Integer, 'ax_forum_msg.views'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_forum_msg.enabled'
go


execute sp_bindefault D_Integer, 'ax_forum_msg.replies'
go


/*==============================================================*/
/* Index: ax_fk_forum_msg_forum_FK                              */
/*==============================================================*/
create   index ax_fk_forum_msg_forum_FK on ax_forum_msg (
forum_id
)
go


/*==============================================================*/
/* Table: ax_group                                              */
/*==============================================================*/
create table ax_group (
   group_id             int                  not null,
   group_desc           varchar(4000)        not null,
   constraint ax_group_pkey primary key  (group_id)
)
go


/*==============================================================*/
/* Table: ax_language                                           */
/*==============================================================*/
create table ax_language (
   lang_id              int                  not null,
   lang_desc            varchar(64)          not null,
   char_encoding        varchar(64)          not null,
   direction            varchar(4)           not null default 'LTR'
      constraint CKC_DIRECTION_AX_LANGU check (direction in ('LTR','RTL')),
   is_default           smallint             not null,
   display_order        int                  not null default 999,
   enabled              smallint             not null,
   constraint PK_AX_LANGUAGE primary key  (lang_id)
)
go


execute sp_bindefault D_Bool_InitFalse, 'ax_language.is_default'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_language.enabled'
go


/*==============================================================*/
/* Table: ax_layout                                             */
/*==============================================================*/
create table ax_layout (
   layout_id            int                  not null,
   layout_name          varchar(64)          not null,
   lang_id              int                  not null default 0,
   index_category       varchar(64)          null,
   layout_table         varchar(64)          null,
   show_last_modified   smallint             not null default false,
   format_last_modified varchar(64)          null,
   prefix_last_modified varchar(64)          null,
   layout_style         varchar(64)          null,
   cache                varchar(64)          null,
   cache_updated        datetime             null,
   last_modified        datetime             not null,
   constraint ax_layout_pkey primary key  (layout_id)
)
go


execute sp_bindefault D_TimeStampNow, 'ax_layout.last_modified'
go


/*==============================================================*/
/* Index: ax_layout_set_FK                                      */
/*==============================================================*/
create   index ax_layout_set_FK on ax_layout (
layout_name
)
go


/*==============================================================*/
/* Table: ax_layout_metadata                                    */
/*==============================================================*/
create table ax_layout_metadata (
   layout_id            int                  not null,
   element_id           int                  not null,
   schema_name          varchar(64)          not null,
   meta_tag_value       varchar(64)          null,
   enc_scheme_id        int                  null,
   linked_uri           smallint             not null default false,
   language             varchar(64)          null,
   constraint PK_AX_LAYOUT_METADATA primary key  (element_id, schema_name, layout_id)
)
go


/*==============================================================*/
/* Table: ax_layout_set                                         */
/*==============================================================*/
create table ax_layout_set (
   layout_name          varchar(64)          not null,
   page_id              int                  null,
   constraint ax_layout_set_pkey primary key  (layout_name)
)
go


/*==============================================================*/
/* Index: ax_layout_set_sitepage_FK                             */
/*==============================================================*/
create   index ax_layout_set_sitepage_FK on ax_layout_set (
page_id
)
go


/*==============================================================*/
/* Table: ax_menu                                               */
/*==============================================================*/
create table ax_menu (
   menu_id              int                  not null,
   menu_name            varchar(64)          not null,
   lang_id              int                  not null default 0,
   menu_desc            varchar(64)          null,
   menu_user_groups     varchar(64)          null,
   active               smallint             not null,
   last_modified        datetime             not null,
   constraint ax_menu_pkey primary key  (menu_id)
)
go


execute sp_bindefault D_Bool_InitTrue, 'ax_menu.active'
go


execute sp_bindefault D_TimeStampNow, 'ax_menu.last_modified'
go


/*==============================================================*/
/* Index: menu_language                                         */
/*==============================================================*/
create unique  index menu_language on ax_menu (
menu_name,
lang_id
)
go


/*==============================================================*/
/* Table: ax_menuoption                                         */
/*==============================================================*/
create table ax_menuoption (
   menuoption_id        int                  not null,
   menu_id              int                  not null,
   parent_id            int                  null default 0,
   user_groups          varchar(64)          null,
   user_type            varchar(64)          null,
   menu_level           int                  not null,
   label                varchar(64)          null,
   description          varchar(64)          null,
   display_order        int                  not null,
   action               varchar(64)          null,
   sitepage             varchar(64)          null,
   sitepage_parms       varchar(64)          null,
   auth_code            smallint             not null default false,
   active               smallint             not null,
   last_modified        datetime             not null,
   width                int                  not null default 80,
   height               int                  not null default 20,
   is_parent            smallint             not null,
   constraint ax_menuoption_pkey primary key  (menuoption_id)
)
go


execute sp_bindefault D_Integer, 'ax_menuoption.menu_level'
go


execute sp_bindefault D_Integer, 'ax_menuoption.display_order'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_menuoption.active'
go


execute sp_bindefault D_TimeStampNow, 'ax_menuoption.last_modified'
go


execute sp_bindefault D_Bool_InitFalse, 'ax_menuoption.is_parent'
go


/*==============================================================*/
/* Index: ax_menuoption_menu_FK                                 */
/*==============================================================*/
create   index ax_menuoption_menu_FK on ax_menuoption (
menu_id
)
go


/*==============================================================*/
/* Table: ax_meta_element                                       */
/*==============================================================*/
create table ax_meta_element (
   element_id           int                  not null,
   label                varchar(64)          null,
   tag_name             varchar(64)          not null,
   definition           varchar(64)          null,
   parent_element       int                  null,
   parent_schema        varchar(64)          null,
   enabled              smallint             not null,
   constraint PK_AX_META_ELEMENT primary key  (element_id)
)
go


execute sp_bindefault D_EnabledFlag, 'ax_meta_element.enabled'
go


/*==============================================================*/
/* Table: ax_meta_element_set                                   */
/*==============================================================*/
create table ax_meta_element_set (
   schema_name          varchar(64)          not null,
   element_id           int                  not null,
   preferred_enc_scheme int                  null,
   comments             varchar(64)          null,
   obligation           char(1)              not null
      constraint CKC_OBLIGATION_AX_META_ check (obligation in ('m','c','r','o')),
   default_value        varchar(64)          null,
   list_of_values       varchar(64)          null,
   display_order        int                  not null default 999,
   enabled              smallint             not null,
   constraint PK_AX_META_ELEMENT_SET primary key  (schema_name, element_id)
)
go


execute sp_bindefault D_Obligation, 'ax_meta_element_set.obligation'
go


execute sp_bindefault D_EnabledFlag, 'ax_meta_element_set.enabled'
go


/*==============================================================*/
/* Table: ax_meta_schema                                        */
/*==============================================================*/
create table ax_meta_schema (
   schema_name          varchar(64)          not null,
   description          varchar(64)          null,
   namespace            varchar(64)          null,
   namespace_uri        varchar(64)          null,
   constraint PK_AX_META_SCHEMA primary key  (schema_name)
)
go


/*==============================================================*/
/* Table: ax_organisation                                       */
/*==============================================================*/
create table ax_organisation (
   org_id               int                  not null,
   contactinfo_id       int                  null,
   org_name             varchar(64)          not null,
   org_desc             varchar(64)          null,
   org_contact          varchar(64)          null,
   enabled              smallint             not null,
   constraint ax_org_pkey primary key  (org_id)
)
go


execute sp_bindefault D_Bool_InitTrue, 'ax_organisation.enabled'
go


/*==============================================================*/
/* Index: ax_org_contactinfo_FK                                 */
/*==============================================================*/
create   index ax_org_contactinfo_FK on ax_organisation (
contactinfo_id
)
go


/*==============================================================*/
/* Table: ax_query_resource                                     */
/*==============================================================*/
create table ax_query_resource (
   quid                 int                  not null,
   q_desc               varchar(64)          null,
   q_query              varchar(64)          null,
   q_script             varchar(64)          null,
   enabled              smallint             not null,
   constraint ax_query_key primary key  (quid)
)
go


execute sp_bindefault D_Bool_InitTrue, 'ax_query_resource.enabled'
go


/*==============================================================*/
/* Table: ax_site_meta_element                                  */
/*==============================================================*/
create table ax_site_meta_element (
   element_id           int                  not null,
   schema_name          varchar(64)          not null,
   label                varchar(64)          null,
   description          varchar(64)          null,
   indexed              smallint             not null default false,
   searchable           smallint             not null default false,
   obligation           char(1)              not null
      constraint CKC_OBLIGATION_AX_SITE_ check (obligation in ('m','c','r','o')),
   default_value        varchar(64)          null,
   list_of_values       varchar(64)          null,
   display_order        int                  not null default 999,
   enabled              smallint             null,
   constraint PK_AX_SITE_META_ELEMENT primary key  (element_id, schema_name)
)
go


execute sp_bindefault D_Obligation, 'ax_site_meta_element.obligation'
go


execute sp_bindefault D_EnabledFlag, 'ax_site_meta_element.enabled'
go


/*==============================================================*/
/* Table: ax_sitepage                                           */
/*==============================================================*/
create table ax_sitepage (
   page_id              int                  not null,
   page_title           varchar(64)          not null,
   page_path            varchar(64)          not null,
   managed              smallint             not null,
   enabled              smallint             not null,
   constraint ax_sitepage_pkey primary key  (page_id)
)
go


execute sp_bindefault D_Bool_InitTrue, 'ax_sitepage.managed'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_sitepage.enabled'
go


/*==============================================================*/
/* Table: ax_sitepage_group                                     */
/*==============================================================*/
create table ax_sitepage_group (
   page_id              int                  not null,
   group_id             int                  not null
)
go


/*==============================================================*/
/* Table: ax_story                                              */
/*==============================================================*/
create table ax_story (
   story_id             INT4                 not null,
   lang_id              INT4                 not null default '0',
   category_id          INT4                 null,
   story_author         varchar(64)          null,
   story_icon           INT4                 null,
   story_icon_url       varchar(64)          null,
   story_headline       varchar(64)          null,
   story_precis         varchar(64)          null,
   story_content        varchar(64)          null,
   story_type           varchar(64)          null,
   story_url            varchar(64)          null,
   story_date           datetime             not null default CURRENT_TIMESTAMP,
   expiry_date          datetime             null,
   last_modified        datetime             not null default CURRENT_TIMESTAMP,
   deleted              smallint             not null default false,
   visible              smallint             not null default true,
   constraint PK_AX_STORY primary key  (story_id)
)
go


/*==============================================================*/
/* Table: ax_story_category                                     */
/*==============================================================*/
create table ax_story_category (
   category_id          INT4                 not null,
   category_desc        varchar(64)          not null,
   has_media            smallint             not null default false,
   has_precis           smallint             not null default true,
   has_expiry           smallint             not null default false,
   has_multilang        smallint             not null default true,
   has_multimedia       smallint             not null default false,
   constraint PK_AX_STORY_CATEGORY primary key  (category_id)
)
go


/*==============================================================*/
/* Table: ax_story_category_locs                                */
/*==============================================================*/
create table ax_story_category_locs (
   category_id          INT4                 not null,
   location_id          INT4                 not null
)
go


/*==============================================================*/
/* Table: ax_story_location                                     */
/*==============================================================*/
create table ax_story_location (
   story_id             INT4                 not null,
   location_id          INT4                 not null,
   display_order        int                  not null default 999
)
go


/*==============================================================*/
/* Table: ax_story_media                                        */
/*==============================================================*/
create table ax_story_media (
   story_id             INT4                 not null,
   cat_id               INT4                 not null,
   caption              varchar(64)          null,
   width                int                  not null default 0,
   height               int                  not null default 0,
   justify              varchar(16)          not null default ''
      constraint CKC_JUSTIFY_AX_STORY check (justify in ('','left','center','right')),
   display_order        int                  not null default 999,
   constraint PK_AX_STORY_MEDIA primary key  (story_id, cat_id)
)
go


/*==============================================================*/
/* Table: ax_story_translation                                  */
/*==============================================================*/
create table ax_story_translation (
   story_id             INT4                 not null,
   translated_story_id  INT4                 not null,
   constraint PK_AX_STORY_TRANSLATION primary key  (story_id, translated_story_id)
)
go


/*==============================================================*/
/* Table: ax_user                                               */
/*==============================================================*/
create table ax_user (
   user_id              varchar(64)          not null,
   org_id               int                  not null default 0,
   password             varchar(64)          null,
   full_name            varchar(64)          null,
   user_type            varchar(50)          not null
      constraint CKC_USER_TYPE_AX_USER check (user_type in ('user','sys')),
   email                varchar(50)          null,
   address              varchar(50)          null,
   phone                varchar(50)          null,
   fax                  varchar(50)          null,
   mobile               varchar(50)          null,
   last_login           datetime             null,
   total_logins         int                  not null,
   limit_logins         int                  not null,
   enabled              smallint             not null,
   auth_code            varchar(64)          null,
   constraint ax_user_pkey primary key  (user_id)
)
go


execute sp_bindefault D_UserType, 'ax_user.user_type'
go


execute sp_bindefault D_Integer, 'ax_user.total_logins'
go


execute sp_bindefault D_Integer, 'ax_user.limit_logins'
go


execute sp_bindefault D_Bool_InitTrue, 'ax_user.enabled'
go


/*==============================================================*/
/* Index: ax_user_org_FK                                        */
/*==============================================================*/
create   index ax_user_org_FK on ax_user (
org_id
)
go


/*==============================================================*/
/* Table: ax_user_group                                         */
/*==============================================================*/
create table ax_user_group (
   group_id             int                  not null,
   user_id              varchar(64)          not null,
   constraint ax_ugroup_pkey primary key  (group_id, user_id)
)
go


/*==============================================================*/
/* Index: ax_user_group_FK                                      */
/*==============================================================*/
create   index ax_user_group_FK on ax_user_group (
group_id
)
go


/*==============================================================*/
/* Index: ax_user_group_FK2                                     */
/*==============================================================*/
create   index ax_user_group_FK2 on ax_user_group (
user_id
)
go


/*==============================================================*/
/* Table: ax_user_ip                                            */
/*==============================================================*/
create table ax_user_ip (
   user_id              varchar(64)          not null,
   ip                   varchar(15)          not null,
   constraint ax_user_ip_pkey primary key  (user_id, ip)
)
go


/*==============================================================*/
/* Index: ax_user_ip_user_FK                                    */
/*==============================================================*/
create   index ax_user_ip_user_FK on ax_user_ip (
user_id
)
go


/*==============================================================*/
/* Table: ax_wwwsession                                         */
/*==============================================================*/
create table ax_wwwsession (
   session_id           varchar(64)          not null,
   user_id              varchar(64)          not null,
   menuoption_id        int                  null,
   lang_id              int                  not null default 0,
   menu_status          varchar(64)          null,
   user_groups          varchar(64)          null,
   login_type           int                  not null
      constraint CKC_LOGIN_TYPE_AX_WWWSE check (login_type between 0 and 4),
   login_datetime       datetime             not null,
   constraint wwwsession_pkey primary key  (session_id)
)
go


execute sp_bindefault D_LoginType, 'ax_wwwsession.login_type'
go


execute sp_bindefault D_TimeStampNow, 'ax_wwwsession.login_datetime'
go


/*==============================================================*/
/* Index: ax_wwwsession_user_FK                                 */
/*==============================================================*/
create   index ax_wwwsession_user_FK on ax_wwwsession (
user_id
)
go


alter table ax_block
   add constraint FK_AX_BLOCK_AX_BLOCK__AX_CATAL foreign key (background_img)
      references ax_catalog (cat_id)
go


alter table ax_block
   add constraint fk_ax_block_language foreign key (lang_id)
      references ax_language (lang_id)
go


alter table ax_block
   add constraint ax_block_layout foreign key (layout_id)
      references ax_layout (layout_id)
go


alter table ax_block_blocklet
   add constraint ax_block_blocklet_block foreign key (block_id)
      references ax_block (block_id)
go


alter table ax_block_blocklet
   add constraint ax_block_blocklet_blocklet foreign key (blocklet_id)
      references ax_blocklet (blocklet_id)
go


alter table ax_configuration
   add constraint ax_configuration_config foreign key (config_name)
      references ax_config (config_name)
go


alter table ax_element_set_enc
   add constraint fk_ax_elemset_enc_enc foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
go


alter table ax_element_set_enc
   add constraint fk_ax_elemset_enc_set foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id)
go


alter table ax_enc_qualifier
   add constraint fk_ax_enc_qual_scheme foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
go


alter table ax_enc_value
   add constraint fk_ax_enc_schema_value foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
go


alter table ax_forum
   add constraint FK_AX_FORUM_MODERATOR foreign key (moderator)
      references ax_user (user_id)
go


alter table ax_forum_member
   add constraint ax_forum_mbr_forum foreign key (forum_id)
      references ax_forum (forum_id)
go


alter table ax_forum_member
   add constraint ax_forum_mbr_user foreign key (user_id)
      references ax_user (user_id)
go


alter table ax_forum_msg
   add constraint ax_forum_msg_forum foreign key (forum_id)
      references ax_forum (forum_id)
go


alter table ax_forum_msg
   add constraint FK_AX_FORUM_PARENT_TH_AX_FORUM foreign key (parent_thread_id)
      references ax_forum_msg (msg_id)
go


alter table ax_layout
   add constraint fk_ax_layout_language foreign key (lang_id)
      references ax_language (lang_id)
go


alter table ax_layout
   add constraint ax_layout_set_layout foreign key (layout_name)
      references ax_layout_set (layout_name)
go


alter table ax_layout_metadata
   add constraint fk_ax_lay_metadata_elem foreign key (element_id, schema_name)
      references ax_site_meta_element (element_id, schema_name)
go


alter table ax_layout_metadata
   add constraint fk_ax_lay_metadata_scheme foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
go


alter table ax_layout_metadata
   add constraint fk_ax_layout_meta_data foreign key (layout_id)
      references ax_layout (layout_id)
go


alter table ax_layout_set
   add constraint ax_layout_set_sitepage foreign key (page_id)
      references ax_sitepage (page_id)
go


alter table ax_menu
   add constraint fk_ax_menu_language foreign key (lang_id)
      references ax_language (lang_id)
go


alter table ax_menuoption
   add constraint fk_ax_menuoption_menu foreign key (menu_id)
      references ax_menu (menu_id)
go


alter table ax_meta_element
   add constraint fk_ax_meta_elem_parent_schema foreign key (parent_schema)
      references ax_meta_schema (schema_name)
go


alter table ax_meta_element
   add constraint fk_ax_parent_element foreign key (parent_element)
      references ax_meta_element (element_id)
go


alter table ax_meta_element_set
   add constraint fk_ax_meta_elem_set_elem foreign key (element_id)
      references ax_meta_element (element_id)
go


alter table ax_meta_element_set
   add constraint fk_ax_meta_elem_set_schema foreign key (schema_name)
      references ax_meta_schema (schema_name)
go


alter table ax_meta_element_set
   add constraint fk_ax_pref_enc_scheme foreign key (preferred_enc_scheme)
      references ax_enc_scheme (enc_scheme_id)
go


alter table ax_organisation
   add constraint ax_org_contactinfo foreign key (contactinfo_id)
      references ax_contactinfo (contactinfo_id)
go


alter table ax_site_meta_element
   add constraint fk_ax_site_meta_element foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id)
go


alter table ax_sitepage_group
   add constraint fk_ax_sitepage_gp_group foreign key (group_id)
      references ax_group (group_id)
go


alter table ax_sitepage_group
   add constraint fk_ax_sitepage_gp_page foreign key (page_id)
      references ax_sitepage (page_id)
go


alter table ax_story
   add constraint fk_ax_story_author foreign key (story_author)
      references ax_user (user_id)
go


alter table ax_story
   add constraint fk_ax_story_category foreign key (category_id)
      references ax_story_category (category_id)
go


alter table ax_story
   add constraint fk_ax_story_language foreign key (lang_id)
      references ax_language (lang_id)
go


alter table ax_story
   add constraint fk_story_icon foreign key (story_icon)
      references ax_catalog (cat_id)
go


alter table ax_story_category_locs
   add constraint fk_ax_story_categ_loc foreign key (category_id)
      references ax_story_category (category_id)
go


alter table ax_story_category_locs
   add constraint fk_ax_story_categ_loc_loc foreign key (location_id)
      references ax_content_location (location_id)
go


alter table ax_story_location
   add constraint fk_ax_content_location foreign key (location_id)
      references ax_content_location (location_id)
go


alter table ax_story_location
   add constraint fk_ax_story_location foreign key (story_id)
      references ax_story (story_id)
go


alter table ax_story_media
   add constraint fk_ax_story_media_cat_id foreign key (cat_id)
      references ax_catalog (cat_id)
go


alter table ax_story_media
   add constraint fk_ax_story_media_story foreign key (story_id)
      references ax_story (story_id)
go


alter table ax_story_translation
   add constraint fk_ax_original_story foreign key (story_id)
      references ax_story (story_id)
go


alter table ax_story_translation
   add constraint FK_AX_STORY_AX_TRANSL_AX_STORY foreign key (translated_story_id)
      references ax_story (story_id)
go


alter table ax_user
   add constraint ax_user_organisation foreign key (org_id)
      references ax_organisation (org_id)
go


alter table ax_user_group
   add constraint ax_user_group_group foreign key (group_id)
      references ax_group (group_id)
go


alter table ax_user_group
   add constraint ax_user_group_user foreign key (user_id)
      references ax_user (user_id)
go


alter table ax_user_ip
   add constraint ax_user_ip_user foreign key (user_id)
      references ax_user (user_id)
go


alter table ax_wwwsession
   add constraint fk_ax_session_language foreign key (lang_id)
      references ax_language (lang_id)
go


alter table ax_wwwsession
   add constraint ax_wwwsession_user foreign key (user_id)
      references ax_user (user_id)
go


alter table ax_wwwsession
   add constraint FK_AX_WWWSE_SESSION_M_AX_MENUO foreign key (menuoption_id)
      references ax_menuoption (menuoption_id)
go


