#! /bin/sh
# Set Axyl distribution permissions
# Execute this script to set the permissions for the Axyl HOME
# distribution tree in its entirety.
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e

# Gotta have the power..
if [ $(id -u) != 0 ]
then
  echo "You must be root to run this script."
  exit 1
fi

# Acquire the local configuration..
CONF=/etc/axyl/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 1
else
  . $CONF
fi

# Get access to some common stuff..
. ${AXYL_HOME}/install/axyl-common.sh

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# ASSERT MAIN INSTALLATION PERMISSIONS and OWNERSHIP
if [ "${AXYL_HOME}" != "" ]
then
  chown -R ${AXUSER}.${AXUSER} ${AXYL_HOME}
  chmod -R 0664 ${AXYL_HOME}
  chmod -R g+sw ${AXYL_HOME}
  find ${AXYL_HOME} -type d -exec chmod a+x {} \;

  # Logging area..
  chown -R ${AXUSER}:${AXUSER} ${AXYL_LOGS}
  find ${AXYL_LOGS} -type f -exec chmod 0664 {} \;
  find ${AXYL_LOGS} -type d -exec chmod 0755 {} \;

  # Executable Perl scripts..
  find ${AXYL_HOME} -type f -name "*.pl" -exec chmod ug+x {} \;

  # Php executables in the scripts directory..
  if [ -d ${AXYL_HOME}/scripts ]
  then
    find ${AXYL_HOME}/scripts -type f -name "*.php" -exec chmod ug+x {} \;
  fi

  # Make all shell scripts executable..
  scripts=`find ${AXYL_HOME} -type f -exec grep -l -E -e "(\#\![[:space:]]*\/bin\/bash)|(\#\![[:space:]]*\/bin\/sh)" {} \;`
  if [ "$scripts" != "" ]
  then
    for script in $scripts
    do
      chmod ug+x $script
    done
  fi
fi

exit 0