/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    fieldvalidation.js                                      */
/* Author:      Paul Waite                                              */
/* Description: Javascript function for validating fields in a form.    */
/*                                                                      */
/* ******************************************************************** */
function limitInt(fld, lo, hi, dflt) {
  vali = parseInt(fld.value.replace(/\$|,|%/g, ""));
  if (isNaN(vali)) {
    if (dflt) vali = dflt;
    else vali = lo;
  }
  else if (vali < lo) vali = lo;
  else if (vali > hi) vali = hi;
  fld.value = vali;
}
