<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    index.php                                               */
/* Author:      Paul Waite                                              */
/* Description: The main website index page/default page                */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// Re-direct any WAP phones to the wap pages..
if ($RESPONSE->browser == BROWSER_PHONE) {
  // Guests get re-directed to About page..
  if ($RESPONSE->ismemberof_group("Guest")) {
    include("wap-logo.php");
  }
  else {
    // Wap users get access just fine..
    include("wap-index.php");
  }
  exit;
}
// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Home", "index", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// The website logo in a table..
$Tlogo = new table("logo");
$Tlogo->setwidth("100%");
$Tlogo->setpadding(5);
$logo = new img("$IMAGESDIR/axyl_logo.gif", "logo", "Axyl");
$Tlogo->tr();
$Tlogo->td( $logo->render() );
$Tlogo->td_alignment("center");

// -----------------------------------------------------------------------
// PLUGIN CONTENT
$RESPONSE->plugin("HEADER_CONTENT", $Tlogo->render());
$RESPONSE->plugin("FEATURED_NEWS_ITEM", "featured_news_item()");
$RESPONSE->plugin("MAIN_CONTENT", "<!--LAYOUTID=\"axylindex\"-->");

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>