/*==============================================================*/
/* Database name:  axyl                                         */
/* DBMS name:      ORACLE Version 8i2 (8.1.6)                   */
/* Created on:     15/02/2005 8:09:13 a.m.                      */
/*==============================================================*/



-- Integrity package declaration
create or replace package IntegrityPackage AS
 procedure InitNestLevel;
 function GetNestLevel return number;
 procedure NextNestLevel;
 procedure PreviousNestLevel;
 end IntegrityPackage;
/

-- Integrity package definition
create or replace package body IntegrityPackage AS
 NestLevel number;

-- Procedure to initialize the trigger nest level
 procedure InitNestLevel is
 begin
 NestLevel := 0;
 end;


-- Function to return the trigger nest level
 function GetNestLevel return number is
 begin
 if NestLevel is null then
     NestLevel := 0;
 end if;
 return(NestLevel);
 end;

-- Procedure to increase the trigger nest level
 procedure NextNestLevel is
 begin
 if NestLevel is null then
     NestLevel := 0;
 end if;
 NestLevel := NestLevel + 1;
 end;

-- Procedure to decrease the trigger nest level
 procedure PreviousNestLevel is
 begin
 NestLevel := NestLevel - 1;
 end;

 end IntegrityPackage;
/


drop procedure "modstamp"
/



CREATE FUNCTION "modstamp" () RETURNS opaque AS 'BEGIN NEW.last_modified := CURRENT_TIMESTAMP; RETURN NEW; END; '
LANGUAGE 'plpgsql';
/



create trigger "ax_block"_"modstamp" before update on "ax_block"
   for each row execute procedure "modstamp"();


create trigger "ax_forum_msg"_"modstamp" before update on "ax_forum_msg"
   for each row execute procedure "modstamp"();


create trigger "ax_layout"_"modstamp" before update on "ax_layout"
   for each row execute procedure "modstamp"();


create trigger "ax_menu"_"modstamp" before update on "ax_menu"
   for each row execute procedure "modstamp"();


create trigger "ax_menuoption"_"modstamp" before update on "ax_menuoption"
   for each row execute procedure "modstamp"();


create trigger "ax_microsite"_"modstamp" before update on "ax_microsite"
   for each row execute procedure "modstamp"();


create trigger "ax_story"_"modstamp" before update on "ax_story"
   for each row execute procedure "modstamp"();

